/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class Util {
    public static Color mergeColor(Color colorA, Color colorB, double proportion) {
        int r = (int)Math.max(0.0, Math.min(255.0, (double)colorA.getRed() * proportion + (double)colorB.getRed() * (1.0 - proportion)));
        int g = (int)Math.max(0.0, Math.min(255.0, (double)colorA.getGreen() * proportion + (double)colorB.getGreen() * (1.0 - proportion)));
        int b = (int)Math.max(0.0, Math.min(255.0, (double)colorA.getBlue() * proportion + (double)colorB.getBlue() * (1.0 - proportion)));
        return new Color(r, g, b);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByDescendingValue(Map<K, V> map) {
        return map.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public static long factorial(int n) {
        long res = 1L;
        int i = 2;
        while (i <= n) {
            res *= (long)i;
            ++i;
        }
        return res;
    }

    public static int nChooseK(int n, int k) {
        return (int)(Util.factorial(n) / (Util.factorial(n - k) * Util.factorial(k)));
    }

    public static double[][] getCombinationsOfLength(double[] values, int lengthOfCombinationsToKeep) {
        double[][] combinations = new double[Util.nChooseK(values.length, lengthOfCombinationsToKeep)][lengthOfCombinationsToKeep];
        int idCombination = 0;
        int i = 1;
        while ((double)i < Math.pow(2.0, values.length)) {
            ArrayList<Double> combination = new ArrayList<Double>();
            int j = 0;
            while (j < values.length) {
                if (((long)i & (long)Math.pow(2.0, j)) > 0L) {
                    combination.add(values[j]);
                }
                ++j;
            }
            if (combination.size() == lengthOfCombinationsToKeep) {
                int idValue = 0;
                while (idValue < combination.size()) {
                    combinations[idCombination][idValue] = (Double)combination.get(idValue);
                    ++idValue;
                }
                ++idCombination;
            }
            ++i;
        }
        return combinations;
    }

    public static String toPythonArrayString(double[] values, boolean rounded) {
        String str = "[";
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            str = String.valueOf(str) + (rounded ? (double)((int)Math.round(value)) : value) + ", ";
            ++n2;
        }
        str = String.valueOf(str.substring(0, str.length() - 2)) + "]";
        return str;
    }

    public static String toExcelColumnString(double[] values) {
        String str = "";
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            str = String.valueOf(str) + String.valueOf(value).replace('.', ',') + "\n";
            ++n2;
        }
        return str;
    }

    public static Font getDefaultFont(int size) {
        return new Font("Dialog", 0, size);
    }

    public static String format(String format, Object ... args) {
        return String.format(Locale.US, format, args);
    }

    public static void log(String log, Object ... args) {
        System.out.println(Util.format(log, args));
    }

    public static void log(Object object) {
        System.out.println(object == null ? "null" : object.toString());
    }
}

