/*
 * Decompiled with CFR 0.152.
 */
package utils;

import audio.ChordIdentifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import utils.Chord;
import utils.Cluster;
import utils.TablatureLine;
import utils.Util;

public class TablatureInProgress {
    private ArrayList<TablatureLine> tablatureLines;
    private ArrayList<Integer> timestamps;
    private int[] clusterizedDeltaTs = new int[0];
    private double confidenceScore;
    private long initialTimestamp;
    private int idTablatureLineBeingTimestamped = 0;
    private int idChordBeingTimestampedInTablatureLine = 0;

    public TablatureInProgress() {
        this.tablatureLines = new ArrayList();
        this.timestamps = new ArrayList();
    }

    public void addTablatureLine(TablatureLine tablatureLine) {
        this.tablatureLines.add(tablatureLine);
    }

    public boolean addTimestamp(long timestamp) {
        int nbChords;
        if (this.idTablatureLineBeingTimestamped == 0 && this.idChordBeingTimestampedInTablatureLine == 0) {
            this.initialTimestamp = timestamp;
        }
        timestamp -= this.initialTimestamp;
        if (this.idTablatureLineBeingTimestamped < this.tablatureLines.size() && this.idChordBeingTimestampedInTablatureLine < (nbChords = this.tablatureLines.get(this.idTablatureLineBeingTimestamped).getNbChords())) {
            this.timestamps.add((int)timestamp);
            if (++this.idChordBeingTimestampedInTablatureLine == nbChords) {
                ++this.idTablatureLineBeingTimestamped;
                this.idChordBeingTimestampedInTablatureLine = 0;
            }
            return true;
        }
        return false;
    }

    public void removeLastRawTimestamp() {
    }

    public int getIdTablatureLineBeingTimestamped() {
        return this.idTablatureLineBeingTimestamped;
    }

    public int getIdChordBeingTimestampedInTablatureLine() {
        return this.idChordBeingTimestampedInTablatureLine;
    }

    public int getNbTablatureLines() {
        return this.tablatureLines.size();
    }

    public TablatureLine getTablatureLine(int id) {
        return this.tablatureLines.get(id);
    }

    public int getTimestamp(int id) {
        return id < this.timestamps.size() ? this.timestamps.get(id) : -1;
    }

    public Chord getChord(int id) {
        int currentId = 0;
        for (TablatureLine tablatureLine : this.tablatureLines) {
            int nbChords = tablatureLine.getNbChords();
            if (id < currentId + nbChords) {
                return tablatureLine.getChord(id - currentId);
            }
            currentId += nbChords;
        }
        return null;
    }

    public int getNbChords() {
        int nbChords = 0;
        for (TablatureLine tablatureLine : this.tablatureLines) {
            nbChords += tablatureLine.getNbChords();
        }
        return nbChords;
    }

    public Chord[] getChords() {
        Chord[] chords = new Chord[this.getNbChords()];
        int idChord = 0;
        for (TablatureLine tablatureLine : this.tablatureLines) {
            Chord[] chordArray = tablatureLine.getChords();
            int n = chordArray.length;
            int n2 = 0;
            while (n2 < n) {
                Chord chord = chordArray[n2];
                chords[idChord++] = chord;
                ++n2;
            }
        }
        return chords;
    }

    public String toString() {
        String str = "[TablatureInProgress:\n";
        for (TablatureLine tablatureLine : this.tablatureLines) {
            str = String.valueOf(str) + "\t" + tablatureLine.toString() + "\n";
        }
        str = String.valueOf(str.substring(0, str.length() - 1)) + "]";
        return str;
    }

    public void beautifyTimestamps() {
        int[] deltaTs = new int[this.timestamps.size()];
        int idT = 0;
        while (idT < deltaTs.length - 1) {
            int deltaT;
            deltaTs[idT] = deltaT = this.timestamps.get(idT + 1) - this.timestamps.get(idT);
            ++idT;
        }
        int distMinBetweenClusters = 350;
        ArrayList<Cluster<Integer>> deltaTsClusters = Cluster.clusterize(deltaTs, distMinBetweenClusters);
        for (Cluster<Integer> cluster : deltaTsClusters) {
            Util.log(cluster);
        }
        String tablatureCsv = "";
        double confidenceScore = 0.0;
        int[] clusterizedDeltaTs = new int[deltaTs.length];
        Chord[] chords = this.getChords();
        int idT2 = 0;
        while (idT2 < deltaTs.length) {
            int roundedClusturizedDeltaT;
            int deltaT = deltaTs[idT2];
            int clusturizedDeltaT = Cluster.getBelongingCluster(deltaT, deltaTsClusters).getAverageValue();
            clusterizedDeltaTs[idT2] = roundedClusturizedDeltaT = (int)(Math.round((double)clusturizedDeltaT / (double)distMinBetweenClusters) * (long)distMinBetweenClusters);
            double confidence = 1.0 - (double)Math.abs(roundedClusturizedDeltaT - clusturizedDeltaT) / (double)distMinBetweenClusters;
            confidenceScore += confidence;
            tablatureCsv = String.valueOf(tablatureCsv) + Util.format("%d,%s\n", roundedClusturizedDeltaT, chords[idT2]);
            ++idT2;
        }
        this.clusterizedDeltaTs = clusterizedDeltaTs;
        this.confidenceScore = confidenceScore /= (double)deltaTs.length;
        Util.log("CSV:");
        Util.log(tablatureCsv);
    }

    public static TablatureInProgress loadExternTablatureFile(File file) {
        TablatureInProgress tablatureInProgress = new TablatureInProgress();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            String currentTitle = "";
            ArrayList currentChords = new ArrayList();
            String currentLyrics = "";
            while ((line = br.readLine()) != null) {
                line = line.trim();
                ArrayList<Chord> lineChords = new ArrayList<Chord>();
                String word = "";
                int i = 0;
                while (i < line.length()) {
                    char c = line.charAt(i);
                    if (c == ' ' || c == ',' || i == line.length() - 1) {
                        Chord chord;
                        if (i == line.length() - 1) {
                            word = String.valueOf(word) + c;
                        }
                        if ((chord = ChordIdentifier.getChordByName(word)) != null) {
                            lineChords.add(chord);
                        }
                        word = "";
                    } else {
                        word = String.valueOf(word) + c;
                    }
                    ++i;
                }
                if (lineChords.size() > 0) {
                    if (currentChords.size() == 0) {
                        currentChords = lineChords;
                        continue;
                    }
                    tablatureInProgress.addTablatureLine(new TablatureLine(currentTitle, currentChords.toArray(new Chord[0]), currentLyrics));
                    currentTitle = "";
                    currentLyrics = "";
                    currentChords = lineChords;
                    continue;
                }
                if (line.length() == 0) {
                    if (currentChords.size() <= 0) continue;
                    tablatureInProgress.addTablatureLine(new TablatureLine(currentTitle, currentChords.toArray(new Chord[0]), currentLyrics));
                    currentTitle = "";
                    currentLyrics = "";
                    currentChords.clear();
                    continue;
                }
                if (currentChords.size() > 0) {
                    currentLyrics = line;
                    continue;
                }
                currentTitle = line;
            }
            if (currentChords.size() > 0) {
                tablatureInProgress.addTablatureLine(new TablatureLine(currentTitle, currentChords.toArray(new Chord[0]), currentLyrics));
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tablatureInProgress;
    }
}

