/*
 * Decompiled with CFR 0.152.
 */
package utils;

import utils.HalfNote;
import utils.Octave;

public final class Note {
    public static final Note G4 = new Note(Octave.OCTAVE_4, HalfNote.G);
    public static final Note C4 = new Note(Octave.OCTAVE_4, HalfNote.C);
    public static final Note E4 = new Note(Octave.OCTAVE_4, HalfNote.E);
    public static final Note A4 = new Note(Octave.OCTAVE_4, HalfNote.A);
    private static double[][] frequenciesPerOctaveAndHalfNote;
    private final Octave octave;
    private final HalfNote halfNote;

    public Note(Octave octave, HalfNote halfNote) {
        this.octave = octave;
        this.halfNote = halfNote;
    }

    public Note(int idOctave, int idHalfNote) {
        this.octave = Octave.byId(idOctave);
        this.halfNote = HalfNote.byId(idHalfNote);
    }

    public Note(Octave octave, int idHalfNote) {
        this.octave = octave;
        this.halfNote = HalfNote.byId(idHalfNote);
    }

    public Note(int idOctave, HalfNote halfNote) {
        this.octave = Octave.byId(idOctave);
        this.halfNote = halfNote;
    }

    public String getName() {
        return String.valueOf(this.halfNote.getName()) + this.octave.getName();
    }

    public double getFrequency() {
        return frequenciesPerOctaveAndHalfNote[this.octave.ordinal()][this.halfNote.ordinal()];
    }

    public Note getFollowingNoteInFrequency() {
        return this.getShiftedNote(1);
    }

    /*
     * Unable to fully structure code
     */
    public Note getShiftedNote(int nbHalfNotesToShift) {
        idHalfNote = this.halfNote.ordinal();
        idOctave = this.octave.ordinal();
        if (nbHalfNotesToShift >= 0) ** GOTO lbl12
        System.err.println("TODO: handle negative value for getShiftedNote");
        return null;
lbl-1000:
        // 1 sources

        {
            if (idHalfNote < HalfNote.NB_HALF_NOTES - 1) {
                ++idHalfNote;
                continue;
            }
            if (idOctave >= Octave.NB_OCTAVES - 1) break;
            ++idOctave;
            idHalfNote = 0;
lbl12:
            // 3 sources

            ** while (nbHalfNotesToShift-- > 0)
        }
lbl13:
        // 2 sources

        return new Note(idOctave, idHalfNote);
    }

    public boolean equals(Object o) {
        if (o instanceof Note) {
            Note other = (Note)o;
            return this.getFrequency() == other.getFrequency();
        }
        return false;
    }

    public static Note getClosestNote(double frequency) {
        int idOctave = 0;
        while (idOctave < Octave.NB_OCTAVES - 1 && frequenciesPerOctaveAndHalfNote[idOctave + 1][0] <= frequency) {
            ++idOctave;
        }
        int idHalfNote = 0;
        while (idHalfNote < HalfNote.NB_HALF_NOTES - 1 && frequenciesPerOctaveAndHalfNote[idOctave][idHalfNote + 1] <= frequency) {
            ++idHalfNote;
        }
        Note note = new Note(idOctave, idHalfNote);
        Note nextNote = note.getFollowingNoteInFrequency();
        if (nextNote.getFrequency() - frequency < frequency - note.getFrequency()) {
            note = nextNote;
        }
        return note;
    }

    private static void initFrequenciesTable() {
        frequenciesPerOctaveAndHalfNote = new double[Octave.NB_OCTAVES][HalfNote.NB_HALF_NOTES];
        int idOctave = 0;
        while (idOctave < Octave.NB_OCTAVES) {
            int idHalfNote = 0;
            while (idHalfNote < HalfNote.NB_HALF_NOTES) {
                Note.frequenciesPerOctaveAndHalfNote[idOctave][idHalfNote] = 440.0 * Math.pow(2.0, (double)(12 * idOctave + idHalfNote - 57) / 12.0);
                ++idHalfNote;
            }
            ++idOctave;
        }
    }

    public static void init() {
        Note.initFrequenciesTable();
    }
}

