/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.ArrayList;
import java.util.Collections;

public class Cluster<T extends Comparable<? super T>>
implements Comparable<Cluster<T>> {
    private ArrayList<T> values;
    private int averageValue;
    private boolean mustRecomputeAverageValue = true;

    public Cluster(ArrayList<T> values) {
        this.values = values;
        Collections.sort(this.values);
    }

    public Cluster() {
        this(new ArrayList());
    }

    public void add(T value) {
        assert (value.compareTo(this.getMaximumValue()) > 0);
        this.values.add(value);
        this.mustRecomputeAverageValue = true;
    }

    public T get(int index) {
        return (T)((Comparable)this.values.get(index));
    }

    public ArrayList<T> getValues() {
        return this.values;
    }

    public T getMinimumValue() {
        return (T)((Comparable)this.values.get(0));
    }

    public T getMaximumValue() {
        return (T)((Comparable)this.values.get(this.values.size() - 1));
    }

    public T getMedianValue() {
        return (T)((Comparable)this.values.get(this.values.size() / 2));
    }

    public int getAverageValue() {
        if (this.mustRecomputeAverageValue) {
            this.averageValue = 0;
            for (Comparable value : this.values) {
                this.averageValue += ((Integer)value).intValue();
            }
            this.averageValue /= this.values.size();
            this.mustRecomputeAverageValue = false;
        }
        return this.averageValue;
    }

    public boolean contains(T value) {
        return this.values.contains(value);
    }

    public int distanceTo(Cluster<Integer> cluster) {
        return Math.min(Math.abs(cluster.getMinimumValue() - (Integer)this.getMaximumValue()), Math.abs((Integer)this.getMinimumValue() - cluster.getMaximumValue()));
    }

    @Override
    public int compareTo(Cluster<T> o) {
        return (Integer)this.getMedianValue() - (Integer)o.getMedianValue();
    }

    public Cluster<T> clone() {
        return new Cluster<T>(this.values);
    }

    public String toString() {
        String str = String.format("[Cluster: averageValue=%d nbPoints=%d:\t", this.getAverageValue(), this.values.size());
        int i = 0;
        while (i < this.values.size()) {
            str = String.valueOf(str) + this.values.get(i) + " ";
            ++i;
        }
        str = String.valueOf(str.substring(0, str.length() - 1)) + "]";
        return str;
    }

    public static Cluster<Integer> mergeClusters(Cluster<Integer> cluster0, Cluster<Integer> cluster1) {
        Object cluster = cluster0.clone();
        for (Integer value : cluster1.getValues()) {
            ((Cluster)cluster).add(value);
        }
        return cluster;
    }

    public static ArrayList<Cluster<Integer>> clusterize(int[] values, int distMinBetweenClusters) {
        ArrayList<Cluster<Integer>> clusters = new ArrayList<Cluster<Integer>>();
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            Cluster<Integer> cluster = new Cluster<Integer>();
            cluster.add(value);
            clusters.add(cluster);
            ++n2;
        }
        boolean someClustersMerged = true;
        while (someClustersMerged) {
            someClustersMerged = false;
            Collections.sort(clusters);
            ArrayList<Cluster<Integer>> mergedClusters = new ArrayList<Cluster<Integer>>();
            if (clusters.size() > 1) {
                int idCluster = 0;
                while (idCluster < clusters.size() - 1) {
                    Cluster<Integer> clusterB;
                    Cluster<Integer> clusterA = clusters.get(idCluster);
                    int dist = clusterA.distanceTo(clusterB = clusters.get(idCluster + 1));
                    if (dist < distMinBetweenClusters) {
                        mergedClusters.add(Cluster.mergeClusters(clusterA, clusterB));
                        if (idCluster + 1 == clusters.size() - 2) {
                            mergedClusters.add(clusters.get(idCluster + 2));
                        }
                        ++idCluster;
                        someClustersMerged = true;
                    } else {
                        mergedClusters.add(clusterA);
                        if (idCluster == clusters.size() - 2) {
                            mergedClusters.add(clusterB);
                        }
                    }
                    ++idCluster;
                }
            } else if (clusters.size() > 0) {
                mergedClusters.add(clusters.get(0));
            }
            clusters = mergedClusters;
        }
        return clusters;
    }

    public static Cluster<Integer> getBelongingCluster(int value, ArrayList<Cluster<Integer>> clusters) {
        for (Cluster<Integer> cluster : clusters) {
            if (!cluster.contains(value)) continue;
            return cluster;
        }
        return null;
    }
}

