/*
 * Decompiled with CFR 0.152.
 */
package utils;

import app.App;
import audio.AudioManager;
import fft.FftResult;
import java.awt.Color;
import java.util.Comparator;
import java.util.Vector;
import utils.Fret;
import utils.Instrument;
import utils.Note;
import utils.Style;

public final class Chord {
    public static final Chord A = new Chord("A", Fret.FRET_2, Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_NONE);
    public static final Chord C = new Chord("C", Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_3);
    public static final Chord F = new Chord("F", Fret.FRET_2, Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_NONE);
    public static final Chord D = new Chord("D", Fret.FRET_2, Fret.FRET_2, Fret.FRET_2, Fret.FRET_NONE);
    public static final Chord G = new Chord("G", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_3, Fret.FRET_2);
    public static final Chord G7 = new Chord("G7", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_1, Fret.FRET_2);
    public static final Chord C7 = new Chord("C7", Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_1);
    public static final Chord Em = new Chord("Em", Fret.FRET_NONE, Fret.FRET_4, Fret.FRET_3, Fret.FRET_2);
    public static final Chord Am = new Chord("Am", Fret.FRET_2, Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_NONE);
    public static final Chord A7 = new Chord("A7", Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_NONE);
    public static final Chord B = new Chord("B", Fret.FRET_4, Fret.FRET_3, Fret.FRET_2, Fret.FRET_2);
    public static final Chord Bm = new Chord("Bm", Fret.FRET_4, Fret.FRET_2, Fret.FRET_2, Fret.FRET_2);
    public static final Chord B7 = new Chord("B7", Fret.FRET_2, Fret.FRET_3, Fret.FRET_2, Fret.FRET_2);
    public static final Chord Cm = new Chord("Cm", Fret.FRET_NONE, Fret.FRET_3, Fret.FRET_3, Fret.FRET_3);
    public static final Chord Dm = new Chord("Dm", Fret.FRET_2, Fret.FRET_2, Fret.FRET_1, Fret.FRET_NONE);
    public static final Chord D7 = new Chord("D7", Fret.FRET_2, Fret.FRET_2, Fret.FRET_2, Fret.FRET_3);
    public static final Chord E = new Chord("E", Fret.FRET_1, Fret.FRET_4, Fret.FRET_NONE, Fret.FRET_2);
    public static final Chord E7 = new Chord("E7", Fret.FRET_1, Fret.FRET_2, Fret.FRET_NONE, Fret.FRET_2);
    public static final Chord Fm = new Chord("Fm", Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_3);
    public static final Chord F7 = new Chord("F7", Fret.FRET_2, Fret.FRET_3, Fret.FRET_1, Fret.FRET_3);
    public static final Chord Gm = new Chord("Gm", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_3, Fret.FRET_1);
    public static final Chord A5 = new Chord("A5", Fret.FRET_2, Fret.FRET_4, Fret.FRET_NONE, Fret.FRET_NONE);
    public static final Chord Am7 = new Chord("Am7", Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_NONE);
    public static final Chord Amaj7 = new Chord("Amaj7", Fret.FRET_1, Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_NONE);
    public static final Chord Asus2 = new Chord("Asus2", Fret.FRET_2, Fret.FRET_4, Fret.FRET_5, Fret.FRET_2);
    public static final Chord Asus4 = new Chord("Asus4", Fret.FRET_2, Fret.FRET_2, Fret.FRET_NONE, Fret.FRET_NONE);
    public static final Chord A7sus4 = new Chord("A7sus4", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_NONE, Fret.FRET_NONE);
    public static final Chord A6 = new Chord("A6", Fret.FRET_2, Fret.FRET_4, Fret.FRET_2, Fret.FRET_4);
    public static final Chord Am6 = new Chord("Am6", Fret.FRET_2, Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_NONE);
    public static final Chord A9 = new Chord("A9", Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_2);
    public static final Chord Am9 = new Chord("Am9", Fret.FRET_2, Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_2);
    public static final Chord Aaug = new Chord("Aaug", Fret.FRET_2, Fret.FRET_1, Fret.FRET_1, Fret.FRET_4);
    public static final Chord Adim = new Chord("Adim", Fret.FRET_2, Fret.FRET_3, Fret.FRET_2, Fret.FRET_3);
    private final String name;
    private final Fret[] frets;
    private final Note[] notes;
    private final double[] notesFrequencies;
    private final FftResult theoreticalFft;

    private Chord(String name, Fret[] frets) {
        Instrument instrument = App.getSingleton().getInstrument();
        assert (frets.length == instrument.getNbCords());
        this.name = name;
        this.frets = frets;
        Vector<Note> notes = new Vector<Note>();
        int idCord = 0;
        while (idCord < instrument.getNbCords()) {
            Note note;
            Fret fret = frets[idCord];
            if (fret != Fret.IGNORE_CORD && !notes.contains(note = instrument.getTuningNotes()[idCord].getShiftedNote(fret.getHalfNotesToShift()))) {
                notes.add(note);
            }
            ++idCord;
        }
        notes.sort(new Comparator<Note>(){

            @Override
            public int compare(Note note0, Note note1) {
                double f1;
                double f0 = note0.getFrequency();
                return f0 == (f1 = note1.getFrequency()) ? 0 : (f0 < f1 ? -1 : 1);
            }
        });
        this.notes = notes.toArray(new Note[0]);
        this.notesFrequencies = new double[notes.size()];
        int idNote = 0;
        while (idNote < notes.size()) {
            this.notesFrequencies[idNote] = ((Note)notes.get(idNote)).getFrequency();
            ++idNote;
        }
        this.theoreticalFft = AudioManager.computeTheoreticalFft(this);
    }

    public String getName() {
        return this.name;
    }

    public Note[] getNotes() {
        return this.notes;
    }

    public double[] getNotesFrequencies() {
        return this.notesFrequencies;
    }

    public FftResult getTheoreticalFft() {
        return this.theoreticalFft;
    }

    public boolean equals(Object o) {
        if (o instanceof Chord) {
            Chord chord = (Chord)o;
            return this.name.equals(chord.getName());
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public Chord(String name, Fret fret0, Fret fret1, Fret fret2, Fret fret3) {
        this(name, new Fret[]{fret0, fret1, fret2, fret3});
    }

    public static Color getChordColor(Chord chord) {
        switch (chord.getName().charAt(0)) {
            case 'A': {
                return Style.DARKORANGE;
            }
            case 'B': {
                return Style.LIGHTSALMON;
            }
            case 'C': {
                return Style.GOLD;
            }
            case 'D': {
                return Style.MEDIUMSEAGREEN;
            }
            case 'E': {
                return Style.STEELBLUE;
            }
            case 'F': {
                return Style.MEDIUMPURPLE;
            }
            case 'G': {
                return Style.MEDIUMVIOLETRED;
            }
        }
        return Color.black;
    }
}

