/*
 * Decompiled with CFR 0.152.
 */
package modes;

import audio.ChordIdentificationResult;
import audio.ChordIdentifier;
import audio.PlayedChord;
import audio.PlayingTablature;
import audio.TablatureDatabase;
import fft.AudioChunk;
import fft.FftResult;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import listeners.PointsScoredListener;
import modes.AbstractMode;
import utils.Chord;
import utils.StrummingPattern;
import utils.Style;
import utils.Util;

public class TablaturePlayingMode
extends AbstractMode
implements PointsScoredListener {
    private static final int PLAYED_CHORDS_DURATION_TO_SHOW_IN_MS = 3000;
    private static final int TOTAL_CHORDS_DURATION_TO_SHOW_IN_MS = 8000;
    private long lastDrawTimestamp = System.currentTimeMillis();
    private PlayingTablature playingTablature;
    private ChordIdentificationResult chordIdentificationResult = null;
    private boolean paused = false;
    private int mouseX;
    private int mouseY;
    private boolean mousePressed = false;
    private ChordIdentificationResult chordIdentificationResultToShow = null;
    private int displayedPoints = 0;
    private double newPointsScoredAlpha = 0.0;
    private double commentAlpha = 1.0;
    private int newPointsScored;
    private int points;
    private int combo;
    private int streak;
    private String comment = "Get ready!";

    @Override
    public void enterMode() {
        this.playingTablature = new PlayingTablature(TablatureDatabase.getTablatureByTitle("demo"), StrummingPattern.d_du_udu);
        this.playingTablature.addPointsScoredListener(this);
    }

    @Override
    public void exitMode() {
    }

    @Override
    public void update(FftResult fftResult) {
        AudioChunk audioChunk;
        boolean enoughVolume;
        if (!this.paused && (enoughVolume = (audioChunk = fftResult.getAudioChunk()).isVolumeHighEnough())) {
            this.chordIdentificationResult = ChordIdentifier.identifyFftResult(fftResult, true);
            this.playingTablature.addChordIdentificationResult(this.chordIdentificationResult);
        }
    }

    @Override
    public void draw(Graphics2D g, int W, int H) {
        long timestamp = System.currentTimeMillis();
        if (!this.paused) {
            this.playingTablature.advanceTimestamp((int)(timestamp - this.lastDrawTimestamp));
        }
        int freqMax = 0;
        if (this.chordIdentificationResultToShow != null) {
            g.setColor(Color.yellow);
            FftResult fftToShow = this.chordIdentificationResultToShow.getFftResult();
            freqMax = (int)Math.ceil(fftToShow.getMaxFrequency());
            double[] magnitudes = fftToShow.getMagnitudes(true);
            double highestMagnitude = fftToShow.getHighestMagnitude(true);
            int idFreq = 0;
            while (idFreq < magnitudes.length) {
                int x = idFreq * W / magnitudes.length;
                int y = (int)(magnitudes[idFreq] / highestMagnitude * (double)H);
                g.drawLine(x, H - y, x, H);
                ++idFreq;
            }
        }
        g.setColor(Style.POWDERBLUE);
        int currentTimestampLinePosition = 3000 * W / 8000;
        g.drawLine(currentTimestampLinePosition, (int)((double)H * 0.2), currentTimestampLinePosition, (int)((double)H * 0.8));
        g.setFont(Util.getDefaultFont(20));
        String label = "";
        if (this.chordIdentificationResult != null && this.chordIdentificationResult.getNbResults() > 0) {
            label = Util.format("%s: score=%.2f confidence=%.2f", this.chordIdentificationResult.getChord(0).getName(), this.chordIdentificationResult.getSimilarityScore(0), this.chordIdentificationResult.getConfidenceScore(0));
        }
        TreeMap<Integer, PlayedChord> playedChords = this.playingTablature.getPlayedChords();
        for (Map.Entry<Integer, PlayedChord> entry : playedChords.entrySet()) {
            this.paintPlayedChord(g, W, H, entry.getValue(), entry.getKey(), this.playingTablature.getCurrentTimestamp());
        }
        this.paintScore(g, W, H);
        this.paintProgress(g, W, H);
        if (freqMax != 0) {
            g.setFont(Util.getDefaultFont(12));
            g.setColor(Color.black);
            int freq = 0;
            while (freq <= freqMax) {
                if (freq % 100 == 0 || freq == freqMax) {
                    String text = String.valueOf(freq) + "Hz";
                    int textWidth = g.getFontMetrics().stringWidth(text);
                    int x = (int)Math.max(0L, Math.min((long)(W - textWidth), Math.round((double)freq * (double)W / (double)(freqMax + 1) - (double)(textWidth / 2))));
                    int y = H - g.getFontMetrics().getDescent();
                    g.drawString(text, x, y);
                }
                ++freq;
            }
        }
        this.lastDrawTimestamp = timestamp;
        this.mousePressed = false;
    }

    private void paintPlayedChord(Graphics2D g, int W, int H, PlayedChord playedChord, int chordTimestamp, int currentTimestamp) {
        int chordDuration = this.playingTablature.getTablature().getStrummingPatternDuration() / this.playingTablature.getStrummingPattern().getNbStrums();
        double msToPx = (double)W / 8000.0;
        int chordW = (int)Math.round((double)(chordDuration *= 2) * msToPx);
        int chordH = (int)((double)H * 0.2);
        g.setFont(Util.getDefaultFont(24));
        FontMetrics fm = g.getFontMetrics();
        int dT = chordTimestamp - currentTimestamp;
        if (dT + chordDuration < -3000 || dT >= 5000) {
            return;
        }
        int xChord = (int)Math.round((double)(chordTimestamp - currentTimestamp + 3000) * msToPx);
        int yChord = H / 2 - chordH / 2;
        Chord expectedChord = playedChord.getExpectedChord();
        Color chordColor = Chord.getChordColor(expectedChord);
        Color resultColor = null;
        double resultAlpha = 0.0;
        String strumArrow = "\u2193";
        double strumArrowAlpha = 1.0;
        int strumArrowOffset = chordH - fm.getDescent();
        if (playedChord.isUpStrum()) {
            strumArrow = "\u2191";
            strumArrowOffset = fm.getAscent();
        }
        double score = 0.0;
        String scoreLabel = "";
        if (playedChord.wasPlayed()) {
            if (playedChord.wasIdentifiedSuccessfully()) {
                resultColor = Style.SEAGREEN;
                score = playedChord.getScore();
                scoreLabel = String.format(Locale.US, "%d", Math.round(score * 100.0));
            } else if (playedChord.getIdentifiedChord() != null) {
                score = playedChord.getScore();
                resultColor = Style.TOMATO;
                scoreLabel = playedChord.getIdentifiedChord().getName();
            } else {
                resultColor = Style.CRIMSON;
                scoreLabel = "?";
            }
        } else if (chordTimestamp < currentTimestamp) {
            resultColor = Style.SLATEGREY;
            scoreLabel = "x";
        }
        Color currentColor = chordColor;
        if (dT > 0) {
            yChord += (int)Math.round((double)((playedChord.isUpStrum() ? 1 : -1) * chordH) * 0.75);
        } else if (-dT < chordDuration) {
            p = Math.pow(dT + chordDuration, 2.0) / (double)(chordDuration * chordDuration);
            yChord += (int)Math.round(p * (double)(playedChord.isUpStrum() ? 1 : -1) * (double)chordH * 0.75);
        } else {
            p = 0.0;
            resultAlpha = 1.0;
            if (-dT < 2 * chordDuration) {
                p = Math.pow(dT + chordDuration * 2, 2.0) / (double)(chordDuration * chordDuration);
                resultAlpha = 1.0 - p;
            }
            strumArrowAlpha = p;
            currentColor = Util.mergeColor(chordColor, resultColor, p);
        }
        if (score > 0.0) {
            g.setColor(Style.transparent(currentColor, resultAlpha * 0.5));
            int fillH = (int)Math.round(resultAlpha * score * (double)chordH);
            g.fillRect(xChord, yChord + chordH - fillH, chordW, fillH);
        }
        g.setPaint(new GradientPaint(xChord + chordW / 2, yChord + chordH / 2, Style.transparent(currentColor, 0.0), xChord, yChord, Style.transparent(currentColor, 0.5)));
        g.fillRect(xChord, yChord, chordW, chordH);
        g.setColor(currentColor);
        g.drawRect(xChord, yChord, chordW, chordH);
        g.drawString(expectedChord.getName(), xChord + (chordW - fm.stringWidth(expectedChord.getName())) / 2, yChord + chordH / 2);
        g.setColor(Style.transparent(currentColor, strumArrowAlpha));
        g.drawString(strumArrow, xChord + (chordW - fm.stringWidth(strumArrow)) / 2, yChord + strumArrowOffset);
        g.setColor(Style.transparent(currentColor, resultAlpha));
        g.drawString(scoreLabel, xChord + (chordW - fm.stringWidth(scoreLabel)) / 2, yChord + chordH / 2 + fm.getHeight());
    }

    private void paintScore(Graphics2D g, int W, int H) {
        g.setFont(Util.getDefaultFont(80));
        FontMetrics fmLarge = g.getFontMetrics();
        g.setColor(Style.POWDERBLUE);
        if (this.displayedPoints < this.points) {
            this.displayedPoints = (int)((double)this.displayedPoints + Math.ceil((double)(this.points - this.displayedPoints) * 0.5));
        }
        if (this.newPointsScoredAlpha > 0.0) {
            this.newPointsScoredAlpha *= 0.9;
        }
        if (this.commentAlpha > 0.0) {
            this.commentAlpha *= 0.95;
        }
        String pointsLabel = " " + this.displayedPoints;
        g.drawString(pointsLabel, 0, fmLarge.getHeight());
        g.setFont(Util.getDefaultFont(40));
        FontMetrics fmSmall = g.getFontMetrics();
        g.setColor(Style.transparent(Style.POWDERBLUE, this.newPointsScoredAlpha));
        if (this.newPointsScored > 0) {
            g.drawString(" +" + this.newPointsScored, fmLarge.stringWidth(pointsLabel), fmLarge.getHeight());
        }
        g.setColor(Style.transparent(Style.POWDERBLUE, this.commentAlpha));
        g.drawString(this.comment, (int)((double)W * 0.25 + ((double)W * 0.75 - (double)fmSmall.stringWidth(this.comment)) / 2.0), fmLarge.getHeight());
        g.setColor(Style.POWDERBLUE);
    }

    private void paintProgress(Graphics2D g, int W, int H) {
        double progression = (double)this.playingTablature.getCurrentTimestamp() / (double)this.playingTablature.getTablature().getDuration();
        int xStart = (int)((double)W * 0.1);
        int xEnd = (int)((double)W * 0.9);
        int xPos = (int)((double)xStart + progression * (double)(xEnd - xStart));
        int y = (int)((double)H * 0.95);
        g.setColor(Style.POWDERBLUE);
        g.drawLine(xStart, y, xEnd, y);
        g.setStroke(new BasicStroke(3.0f));
        g.drawLine(xStart, y, xPos, y);
        int radius = 4;
        g.fillOval(xStart - radius, y - radius, radius * 2, radius * 2);
        g.fillOval(xPos - radius, y - radius, radius * 2, radius * 2);
        g.fillOval(xEnd - radius, y - radius, radius * 2, radius * 2);
    }

    @Override
    public void pointScored(int newPointsScored, String comment, int totalPoints, int currentCombo, int currentStreak) {
        this.newPointsScored = newPointsScored;
        this.comment = comment;
        this.newPointsScoredAlpha = 1.0;
        this.commentAlpha = 1.0;
        this.points = totalPoints;
        this.combo = currentCombo;
        this.streak = currentStreak;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.paused = !this.paused;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.mousePressed = true;
    }
}

