/*
 * Decompiled with CFR 0.152.
 */
package modes;

import fft.FftResult;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import modes.AbstractMode;
import utils.Chord;
import utils.TablatureInProgress;
import utils.TablatureLine;
import utils.Util;

public class TablatureEditorMode
extends AbstractMode {
    private TablatureInProgress tablatureInProgress;

    @Override
    public void enterMode() {
        this.tablatureInProgress = TablatureInProgress.loadExternTablatureFile(new File("tablatures/raw/yt.txt"));
    }

    @Override
    public void exitMode() {
    }

    @Override
    public void update(FftResult fftResult) {
    }

    @Override
    public void draw(Graphics2D g, int W, int H) {
        g.setFont(Util.getDefaultFont(28));
        String text = "Press space to add a timestamp, enter to generate the tablature";
        int Y = 100;
        g.drawString(text, W / 2 - g.getFontMetrics().stringWidth(text) / 2, Y);
        Y += g.getFontMetrics().getHeight() * 2;
        g.setFont(Util.getDefaultFont(20));
        int idCurrentTablatureLine = this.tablatureInProgress.getIdTablatureLineBeingTimestamped();
        int idTimestamp = 0;
        int idTablatureLine = Math.max(0, idCurrentTablatureLine - 1);
        while (idTablatureLine < this.tablatureInProgress.getNbTablatureLines()) {
            TablatureLine tablatureLine = this.tablatureInProgress.getTablatureLine(idTablatureLine);
            int X = 50;
            g.setColor(Color.gray);
            String label = tablatureLine.getTitle();
            g.drawString(label, X, Y);
            Y += g.getFontMetrics().getHeight();
            int idChord = 0;
            while (idChord < tablatureLine.getNbChords()) {
                Chord chord = tablatureLine.getChord(idChord);
                label = chord.getName();
                Color color = idTablatureLine != this.tablatureInProgress.getIdTablatureLineBeingTimestamped() ? Color.black : (idChord != this.tablatureInProgress.getIdChordBeingTimestampedInTablatureLine() ? Color.blue : Color.cyan);
                g.setColor(color);
                g.drawString(label, X, Y);
                X += 50;
                ++idChord;
            }
            g.setColor(Color.darkGray);
            X = 50;
            g.setFont(Util.getDefaultFont(12));
            Y += g.getFontMetrics().getHeight();
            idChord = 0;
            while (idChord < tablatureLine.getNbChords()) {
                int timestamp = this.tablatureInProgress.getTimestamp(idTimestamp);
                label = timestamp == -1 ? "" : String.valueOf(timestamp);
                g.drawString(label, X, Y);
                X += 50;
                ++idTimestamp;
                ++idChord;
            }
            X = 50;
            g.setFont(Util.getDefaultFont(20));
            g.setColor(Color.gray);
            label = tablatureLine.getLyrics();
            g.drawString(label, X, Y += g.getFontMetrics().getHeight());
            Y += g.getFontMetrics().getHeight() * 2;
            ++idTablatureLine;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            if (!this.tablatureInProgress.addTimestamp(System.currentTimeMillis())) {
                this.tablatureInProgress.beautifyTimestamps();
            }
        } else if (e.getKeyCode() == 8) {
            this.tablatureInProgress.removeLastRawTimestamp();
        } else if (e.getKeyCode() == 10) {
            this.tablatureInProgress.beautifyTimestamps();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

