/*
 * Decompiled with CFR 0.152.
 */
package modes;

import audio.ChordIdentificationResult;
import audio.ChordIdentifier;
import fft.AudioChunk;
import fft.FftResult;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import modes.AbstractMode;
import utils.Chord;
import utils.Style;
import utils.Util;

public class LiveAnalysisMode
extends AbstractMode {
    private FftResult lastFftResult;
    private static boolean showLiveFft = false;
    private double maxDeltaAmplitude = 1000.0;
    private boolean readyForNewSound = true;
    private double thresholdNewSound = 0.0;
    private FftResult identifiedFftResult = null;
    ChordIdentificationResult chordIdentificationResult = null;
    private long timestampLastBigSound = 0L;
    private int delayAfterBigSound = 300;
    private long lastT = 0L;

    @Override
    public void enterMode() {
        this.chordIdentificationResult = null;
    }

    @Override
    public void exitMode() {
    }

    @Override
    public void update(FftResult ffResult) {
        this.lastFftResult = ffResult;
    }

    @Override
    public void draw(Graphics2D g, int W, int H) {
        long T = System.currentTimeMillis();
        if (this.lastFftResult == null) {
            return;
        }
        AudioChunk audioChunk = this.lastFftResult.getAudioChunk();
        boolean enoughVolume = false;
        if (this.readyForNewSound) {
            boolean bl = enoughVolume = audioChunk.getDeltaAmplitude() > 4000.0;
            if (enoughVolume) {
                this.timestampLastBigSound = T;
            }
        }
        if (enoughVolume) {
            this.readyForNewSound = false;
            this.thresholdNewSound = 2000.0;
        }
        if (!this.readyForNewSound && audioChunk.getDeltaAmplitude() < this.thresholdNewSound) {
            this.readyForNewSound = true;
        }
        if (T - this.timestampLastBigSound > (long)this.delayAfterBigSound && T - this.timestampLastBigSound < (long)(this.delayAfterBigSound + 200)) {
            this.identifiedFftResult = this.lastFftResult;
            this.chordIdentificationResult = ChordIdentifier.identifyFftResult(this.lastFftResult, true);
            enoughVolume = false;
        }
        g.setColor(Style.POWDERBLUE);
        g.setFont(Util.getDefaultFont(16));
        FontMetrics fm = g.getFontMetrics();
        int xText = (int)((double)W * 0.9 - (double)fm.stringWidth("Identified Chords: "));
        int yText = (int)((double)H * 0.1);
        g.drawString("Identified Chords:", xText, yText);
        g.setFont(Util.getDefaultFont(16));
        fm = g.getFontMetrics();
        String text = showLiveFft ? "press (space) to disable Live FFT" : "press (space) to enable Live FFT";
        g.drawString(text, (W - fm.stringWidth(text)) / 2, (int)((double)H * 0.05));
        Stroke defaultStroke = g.getStroke();
        BasicStroke thickStroke = new BasicStroke(3.0f, 1, 1);
        g.setStroke(thickStroke);
        if (showLiveFft) {
            this.drawFftAndChordIdentificationResult(g, W, H, this.lastFftResult, ChordIdentifier.identifyFftResult(this.lastFftResult, true), Style.PAPAYAWHIP);
        } else {
            this.drawFftAndChordIdentificationResult(g, W, H, this.identifiedFftResult, this.chordIdentificationResult, Style.PINK);
        }
        g.setStroke(defaultStroke);
        double[] audio = audioChunk.getAudio();
        g.setColor(Style.POWDERBLUE);
        double wAud = (double)W / (double)audio.length;
        double currentDeltaAmplitude = 2.0 * Math.max(-audioChunk.getLowestAmplitude(), audioChunk.getHighestAmplitude());
        if (currentDeltaAmplitude > this.maxDeltaAmplitude) {
            this.maxDeltaAmplitude = currentDeltaAmplitude;
        } else {
            double p = 0.05;
            this.maxDeltaAmplitude = Math.max(5000.0, p * currentDeltaAmplitude + (1.0 - p) * this.maxDeltaAmplitude);
        }
        double deltaAmplitude = this.maxDeltaAmplitude;
        int dt = (int)Math.floor(audio.length / W);
        int t = 0;
        while (t < audio.length - dt) {
            int y0 = (int)((double)(H / 2) - audio[t] * (double)H / deltaAmplitude);
            int y1 = (int)((double)(H / 2) - audio[t + dt] * (double)H / deltaAmplitude);
            g.drawLine((int)Math.round((double)t * wAud), y0, (int)Math.round((double)(t + dt) * wAud), y1);
            t += dt;
        }
        g.setFont(Util.getDefaultFont(12));
        g.setColor(Style.GHOSTWHITE);
        int freqMax = (int)Math.ceil(this.lastFftResult.getMaxFrequency());
        int freq = 0;
        while (freq <= freqMax) {
            if (freq % 100 == 0 || freq == freqMax) {
                text = String.valueOf(freq) + "Hz";
                int textWidth = g.getFontMetrics().stringWidth(text);
                int x = (int)Math.max(0L, Math.min((long)(W - textWidth), Math.round((double)freq * (double)W / (double)(freqMax + 1) - (double)(textWidth / 2))));
                int y = H - g.getFontMetrics().getDescent();
                g.drawString(text, x, y);
            }
            ++freq;
        }
    }

    private void drawFftAndChordIdentificationResult(Graphics2D g, int W, int H, FftResult fftResult, ChordIdentificationResult chordIdentificationResult, Color color) {
        if (fftResult == null) {
            return;
        }
        Polygon fftPolygon = new Polygon();
        fftPolygon.addPoint(0, H);
        double[] magnitudes = fftResult.getMagnitudes(true);
        double highestMagnitude = fftResult.getHighestMagnitude(true);
        int idFreq = 0;
        while (idFreq < magnitudes.length) {
            int x = idFreq * W / magnitudes.length;
            int y = (int)(magnitudes[idFreq] / highestMagnitude * (double)H);
            fftPolygon.addPoint(x, H - y);
            ++idFreq;
        }
        fftPolygon.addPoint(W, H);
        g.setColor(Style.transparent(color, 0.3));
        g.fill(fftPolygon);
        g.setColor(color);
        g.draw(fftPolygon);
        if (chordIdentificationResult != null) {
            int nbFreqsToShow = 4;
            float[] paintFractions = new float[nbFreqsToShow * 3 + 2];
            Color[] paintColors = new Color[nbFreqsToShow * 3 + 2];
            int freqMax = (int)Math.ceil(fftResult.getMaxFrequency());
            g.setColor(color);
            double[] freqs = fftResult.getFrequenciesOfMagnitudesLocalHighs();
            int idFreq2 = 0;
            while (idFreq2 < nbFreqsToShow) {
                double freq = freqs[idFreq2];
                int x = (int)(freq * (double)W / (double)(freqMax + 1));
                int y = (int)(magnitudes[(int)(freq / fftResult.getFrequencyStep())] / highestMagnitude * (double)H);
                g.fillOval(x - 5, H - y - 5, 11, 11);
                g.fillOval(x - 5, H - 5, 11, 11);
                String string = Util.format("#%d(%dHz)", idFreq2, (int)Math.round(freq));
                ++idFreq2;
            }
            int nbResultsToShow = chordIdentificationResult.getNbResults();
            g.setFont(Util.getDefaultFont(20));
            FontMetrics fm = g.getFontMetrics();
            int idResult = 0;
            while (idResult < nbResultsToShow) {
                Chord chord = chordIdentificationResult.getChord(idResult);
                g.setColor(Chord.getChordColor(chord));
                freqs = chord.getNotesFrequencies();
                int idFreq3 = 0;
                while (idFreq3 < freqs.length) {
                    double freq = freqs[idFreq3];
                    int x = (int)(freq * (double)W / (double)(freqMax + 1));
                    int y = (int)(magnitudes[(int)(freq / fftResult.getFrequencyStep())] / highestMagnitude * (double)H);
                    g.fillOval(x - 4, H - y - 4, 9, 9);
                    g.fillOval(x - 4, H - 4, 9, 9);
                    g.setFont(Util.getDefaultFont(14));
                    String string = Util.format("#%d(%dHz)", idFreq3, (int)Math.round(freq));
                    ++idFreq3;
                }
                g.setFont(Util.getDefaultFont(40));
                fm = g.getFontMetrics();
                int xText = (int)((double)W * 0.9);
                int yText = (int)((double)H * 0.1 + (double)fm.getDescent());
                int y = yText + idResult * fm.getHeight();
                String label = chord.getName();
                g.drawString(label, xText, y);
                ++idResult;
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            showLiveFft = !showLiveFft;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

