/*
 * Decompiled with CFR 0.152.
 */
package fft;

import app.App;
import fft.AudioChunk;
import java.util.HashMap;
import java.util.Map;
import utils.Util;

public class FftResult {
    private static final int NB_MAGNITUDE_LOCAL_HIGHS_TO_KEEP = 5;
    private final AudioChunk audioChunk;
    private final double[] magnitudes;
    private final double[] normalizedMagnitudes;
    private final double highestMagnitude;
    private final double highestNormalizedMagnitude;
    private final double frequencyStep;

    public FftResult(AudioChunk audioChunk, double[] fftMagnitudes) {
        this.audioChunk = audioChunk;
        int fMax = App.getSingleton().getInstrument().getMaximumFrequencyToRecognize();
        this.frequencyStep = 24000.0 / (double)fftMagnitudes.length;
        int nbPointsToKeep = (int)Math.min(Math.ceil((double)fMax / this.frequencyStep), (double)fftMagnitudes.length);
        this.magnitudes = new double[nbPointsToKeep];
        this.normalizedMagnitudes = new double[nbPointsToKeep];
        double highestMagnitude = 0.0;
        double sumMagnitudes = 0.0;
        int idFreq = 0;
        while (idFreq < nbPointsToKeep) {
            double magn = fftMagnitudes[idFreq];
            sumMagnitudes += magn;
            this.magnitudes[idFreq] = magn;
            if (magn > highestMagnitude) {
                highestMagnitude = magn;
            }
            ++idFreq;
        }
        this.highestMagnitude = highestMagnitude;
        this.highestNormalizedMagnitude = highestMagnitude / sumMagnitudes;
        idFreq = 0;
        while (idFreq < nbPointsToKeep) {
            double normalizedMagn;
            this.normalizedMagnitudes[idFreq] = normalizedMagn = fftMagnitudes[idFreq] / sumMagnitudes;
            ++idFreq;
        }
    }

    public AudioChunk getAudioChunk() {
        return this.audioChunk;
    }

    public double[] getMagnitudes(boolean normalized) {
        return normalized ? this.normalizedMagnitudes : this.magnitudes;
    }

    public double getHighestMagnitude(boolean normalized) {
        return normalized ? this.highestNormalizedMagnitude : this.highestMagnitude;
    }

    public double getFrequencyStep() {
        return this.frequencyStep;
    }

    public double getMaxFrequency() {
        return (double)this.magnitudes.length * this.frequencyStep;
    }

    public double[] getFrequenciesOfMagnitudesLocalHighs() {
        HashMap localHighsFreqsAndMagns = new HashMap();
        double[] deltasMagnitudes = new double[this.magnitudes.length];
        deltasMagnitudes[0] = 0.0;
        int i = 1;
        while (i < this.magnitudes.length) {
            deltasMagnitudes[i] = this.magnitudes[i] - this.magnitudes[i - 1];
            ++i;
        }
        i = 1;
        while (i < this.magnitudes.length) {
            if (deltasMagnitudes[i] * deltasMagnitudes[i - 1] <= 0.0) {
                localHighsFreqsAndMagns.put((double)i * this.frequencyStep, this.magnitudes[i]);
            }
            ++i;
        }
        localHighsFreqsAndMagns = (HashMap)Util.sortByDescendingValue(localHighsFreqsAndMagns);
        double[] frequenciesOfMagnitudesLocalHighs = new double[5];
        int nbLocalHighsAdded = 0;
        for (Map.Entry entry : localHighsFreqsAndMagns.entrySet()) {
            frequenciesOfMagnitudesLocalHighs[nbLocalHighsAdded++] = (Double)entry.getKey();
            if (nbLocalHighsAdded == frequenciesOfMagnitudesLocalHighs.length) break;
        }
        return frequenciesOfMagnitudesLocalHighs;
    }
}

