/*
 * Decompiled with CFR 0.152.
 */
package fft;

public class AudioChunk {
    private static final int THRESOLD_VOLUME = 4000;
    private final long timestamp = System.currentTimeMillis();
    private final double[] audio;
    private final double lowestAmplitude;
    private final double highestAmplitude;

    public AudioChunk(double[] audio) {
        this.audio = audio;
        double lowestAmplitude = Double.MAX_VALUE;
        double highestAmplitude = Double.MIN_VALUE;
        int t = 0;
        while (t < audio.length) {
            if (audio[t] < lowestAmplitude) {
                lowestAmplitude = audio[t];
            }
            if (audio[t] > highestAmplitude) {
                highestAmplitude = audio[t];
            }
            ++t;
        }
        this.lowestAmplitude = lowestAmplitude;
        this.highestAmplitude = highestAmplitude;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public double[] getAudio() {
        return this.audio;
    }

    public int getLength() {
        return this.audio.length;
    }

    public double getLowestAmplitude() {
        return this.lowestAmplitude;
    }

    public double getHighestAmplitude() {
        return this.highestAmplitude;
    }

    public boolean isVolumeHighEnough() {
        return this.getDeltaAmplitude() >= 4000.0;
    }

    public double getDeltaAmplitude() {
        return this.highestAmplitude - this.lowestAmplitude;
    }
}

