/*
 * Decompiled with CFR 0.152.
 */
package audio;

import audio.ChordIdentifier;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import utils.Chord;
import utils.Tablature;

public abstract class TablatureDatabase {
    private static ArrayList<Tablature> allTablatures;

    private static void loadTablature(String filename) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader("tablatures/" + filename + ".txt"));
            TreeMap<Integer, Chord> chords = new TreeMap<Integer, Chord>();
            int timestamp = 3000;
            while ((line = br.readLine()) != null) {
                String[] data = line.split(",");
                int duration = Integer.parseInt(data[0]);
                Chord chord = ChordIdentifier.getChordByName(data[1]);
                chords.put(timestamp, chord);
                timestamp += duration;
            }
            br.close();
            allTablatures.add(new Tablature(filename, "unknown", 2000, chords));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Tablature getTablatureByTitle(String title) {
        for (Tablature tab : allTablatures) {
            if (!tab.getTitle().equals(title)) continue;
            return tab;
        }
        return null;
    }

    public static void init() {
        allTablatures = new ArrayList();
        TablatureDatabase.loadTablature("overTheRainbow");
        TablatureDatabase.loadTablature("demo");
        TreeMap<Integer, Chord> chords = new TreeMap<Integer, Chord>();
        allTablatures.add(new Tablature("emptyDebug", "debug", 2000, chords));
    }
}

