/*
 * Decompiled with CFR 0.152.
 */
package audio;

import audio.ChordIdentificationResult;
import audio.PlayedChord;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import listeners.PointsScoredListener;
import utils.Chord;
import utils.StrummingPattern;
import utils.Tablature;

public class PlayingTablature {
    private static final double MIN_SCORE_TO_INCREMENT_COMBO = 0.8;
    private static final double MAX_SCORE_TO_RESET_COMBO = 0.5;
    private static final int COMBO_MAX = 5;
    private double speedRatio = 1.0;
    private double slowingRatio = 2.0;
    private Tablature tablature;
    private StrummingPattern strummingPattern;
    private int currentTimestamp = 0;
    private int points = 0;
    private int combo = 1;
    private int streak = 0;
    private TreeMap<Integer, PlayedChord> playedChords;
    private TreeMap<Integer, ChordIdentificationResult> chordIdentifications;
    private TreeMap<Integer, ChordIdentificationResult> selectedChordIdentificationResults;
    private Vector<PointsScoredListener> pointsScoredListeners = new Vector();

    public PlayingTablature(Tablature tablature, StrummingPattern strummingPattern) {
        this.tablature = tablature;
        this.strummingPattern = strummingPattern;
        this.computePlayedChords();
        this.chordIdentifications = new TreeMap();
        this.selectedChordIdentificationResults = new TreeMap();
    }

    private void computePlayedChords() {
        this.playedChords = new TreeMap();
        TreeMap<Integer, Chord> chords = this.tablature.getChords();
        Integer[] timestamps = chords.keySet().toArray(new Integer[0]);
        int idTimestamp = 0;
        while (idTimestamp < timestamps.length - 1) {
            int timestamp = timestamps[idTimestamp];
            int duration = timestamps[idTimestamp + 1] - timestamp;
            int strumDuration = this.tablature.getStrummingPatternDuration() / this.strummingPattern.getNbStrums();
            int nbStrums = duration / strumDuration;
            Chord chord = chords.get(timestamps[idTimestamp]);
            int idStrum = 0;
            while (idStrum < nbStrums) {
                int timestampStrum = timestamp + idStrum * strumDuration;
                timestampStrum = (int)((double)timestampStrum * this.slowingRatio);
                int idStrumInPattern = idStrum % this.strummingPattern.getNbStrums();
                if (!this.strummingPattern.isMuteStrum(idStrumInPattern)) {
                    PlayedChord playedChord = new PlayedChord(chord, this.strummingPattern.isUpStrum(idStrumInPattern), timestampStrum);
                    this.playedChords.put(timestampStrum, playedChord);
                }
                ++idStrum;
            }
            ++idTimestamp;
        }
    }

    private void updatePoints(double scoreToAdd, String comment) {
        if (scoreToAdd >= 0.8 && this.combo < 5) {
            ++this.combo;
        } else if (scoreToAdd < 0.5) {
            this.combo = 1;
            this.streak = 0;
        }
        this.streak = scoreToAdd > 0.0 ? ++this.streak : 0;
        this.streak = 1;
        this.combo = 1;
        int pointsScored = (int)Math.round((double)this.combo * scoreToAdd * 100.0);
        this.points += pointsScored;
        this.firePointsScored(pointsScored, comment, this.points, this.combo, this.streak);
    }

    private void firePointsScored(int newPointsScored, String comment, int totalPoints, int currentCombo, int currentStreak) {
        for (PointsScoredListener listener : this.pointsScoredListeners) {
            listener.pointScored(newPointsScored, comment, totalPoints, currentCombo, currentStreak);
        }
    }

    public void addPointsScoredListener(PointsScoredListener listener) {
        this.pointsScoredListeners.add(listener);
    }

    public void advanceTimestamp(int deltaT) {
        PlayedChord chordAtLastT = this.getLastPlayedChordBeforeTimestamp(this.currentTimestamp);
        this.currentTimestamp = (int)((double)this.currentTimestamp + (double)deltaT * this.speedRatio);
        PlayedChord chordAtT = this.getLastPlayedChordBeforeTimestamp(this.currentTimestamp);
        if (chordAtT != null && !chordAtT.equals(chordAtLastT) && chordAtLastT != null) {
            this.updatePoints(chordAtLastT.getScore(), chordAtLastT.getComment());
        }
    }

    public void addChordIdentificationResult(ChordIdentificationResult identificationResult) {
        this.chordIdentifications.put(this.currentTimestamp, identificationResult);
        if (identificationResult != null) {
            PlayedChord nextChord;
            PlayedChord previousChord = this.getLastPlayedChordBeforeTimestamp(this.currentTimestamp);
            if (previousChord != null) {
                double previousScore = previousChord.getScore();
                previousChord.addIdentificationResult(this.currentTimestamp, identificationResult);
            }
            if ((nextChord = this.getFirstPlayedChordAfterTimestamp(this.currentTimestamp)) != null) {
                nextChord.addIdentificationResult(this.currentTimestamp, identificationResult);
            }
        }
    }

    public TreeMap<Integer, PlayedChord> getPlayedChords() {
        return this.playedChords;
    }

    public TreeMap<Integer, ChordIdentificationResult> getChordIdentificationResults() {
        return this.chordIdentifications;
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public StrummingPattern getStrummingPattern() {
        return this.strummingPattern;
    }

    public int getCurrentTimestamp() {
        return this.currentTimestamp;
    }

    public PlayedChord getLastPlayedChordBeforeTimestamp(int timestamp) {
        PlayedChord lastPlayedChordBeforeTimestamp = null;
        for (Map.Entry<Integer, PlayedChord> entry : this.playedChords.entrySet()) {
            if (entry.getKey() > timestamp) break;
            lastPlayedChordBeforeTimestamp = entry.getValue();
        }
        return lastPlayedChordBeforeTimestamp;
    }

    public PlayedChord getFirstPlayedChordAfterTimestamp(int timestamp) {
        Object firstPlayedChordAfterTimestamp = null;
        for (Map.Entry<Integer, PlayedChord> entry : this.playedChords.entrySet()) {
            if (entry.getKey() < timestamp) continue;
            return entry.getValue();
        }
        return null;
    }
}

