/*
 * Decompiled with CFR 0.152.
 */
package audio;

import audio.ChordIdentificationResult;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import utils.Chord;
import utils.Util;

public class PlayedChord {
    private static final int MAX_DELTA_TIMING = 2000;
    private final Chord expectedChord;
    private final boolean isUpStrum;
    private final int expectedTimestamp;
    private TreeMap<Integer, ChordIdentificationResult> identificationResults;
    private Chord identifiedChord;
    private double timingScore;
    private double clarityScore;
    private String timingComment = "";
    private String clarityComment = "";

    public PlayedChord(Chord expectedChord, boolean isUpStrum, int expectedTimestamp) {
        this.expectedChord = expectedChord;
        this.isUpStrum = isUpStrum;
        this.expectedTimestamp = expectedTimestamp;
        this.identificationResults = new TreeMap();
    }

    public void addIdentificationResult(int timestamp, ChordIdentificationResult idenficationResult) {
        this.identificationResults.put(timestamp, idenficationResult);
        HashMap<Chord, Integer> nbIdentificationsPerChord = new HashMap<Chord, Integer>();
        Chord mostIdentifiedChord = null;
        for (ChordIdentificationResult identificationResult : this.identificationResults.values()) {
            Chord chord = idenficationResult.getChord();
            if (chord == null) continue;
            int nbIdentifications = nbIdentificationsPerChord.getOrDefault(chord, 0) + 1;
            nbIdentificationsPerChord.put(chord, nbIdentifications);
            if (mostIdentifiedChord != null && nbIdentifications <= (Integer)nbIdentificationsPerChord.get(mostIdentifiedChord)) continue;
            mostIdentifiedChord = chord;
        }
        this.identifiedChord = mostIdentifiedChord;
        this.timingScore = -1.0;
        this.clarityScore = -1.0;
    }

    public TreeMap<Integer, ChordIdentificationResult> getIdentificationResults() {
        return this.identificationResults;
    }

    public Chord getExpectedChord() {
        return this.expectedChord;
    }

    public boolean isUpStrum() {
        return this.isUpStrum;
    }

    public boolean wasPlayed() {
        return this.identificationResults.size() > 0;
    }

    public Chord getIdentifiedChord() {
        return this.identifiedChord;
    }

    public boolean wasIdentifiedSuccessfully() {
        return this.expectedChord.equals(this.getIdentifiedChord());
    }

    public double getScore() {
        return this.getTimingScore() * this.getClarityScore();
    }

    public double getTimingScore() {
        if (this.timingScore == -1.0) {
            this.timingScore = this.computeTimingScore();
        }
        return this.timingScore;
    }

    public double getClarityScore() {
        if (this.clarityScore == -1.0) {
            this.clarityScore = this.computeClarityScore();
        }
        return this.clarityScore;
    }

    public String getComment() {
        if (this.wasIdentifiedSuccessfully()) {
            if (this.timingScore < this.clarityScore) {
                return Util.format("%s: %s", this.identifiedChord.getName(), this.timingComment);
            }
            return Util.format("%s: %s", this.identifiedChord.getName(), this.clarityComment);
        }
        if (this.identifiedChord != null) {
            return Util.format("You played an %s instead of an %s!", this.identifiedChord, this.expectedChord);
        }
        return Util.format("%s: Chord missed!", this.expectedChord.getName());
    }

    private double computeTimingScore() {
        int timestampFirstValidChord = -1;
        for (Map.Entry<Integer, ChordIdentificationResult> entry : this.identificationResults.entrySet()) {
            if (!this.expectedChord.equals(entry.getValue().getChord())) continue;
            timestampFirstValidChord = entry.getKey();
            break;
        }
        if (timestampFirstValidChord != -1) {
            boolean playedTooEarly;
            double timingScore = 1.0 - (double)Math.abs(this.expectedTimestamp - timestampFirstValidChord) / 2000.0;
            boolean bl = playedTooEarly = this.expectedTimestamp > timestampFirstValidChord;
            this.timingComment = timingScore > 0.9 ? "Perfect!" : (timingScore > 0.8 ? (playedTooEarly ? "A bit early!" : "A bit late!") : (timingScore > 0.6 ? (playedTooEarly ? "Too early!" : "Too late!") : (playedTooEarly ? "Way too early!" : "Way too late!")));
            return timingScore;
        }
        this.timingComment = "Chord missed!";
        return 0.0;
    }

    private double computeClarityScore() {
        int nbValidChords = 0;
        int nbTotalChords = 0;
        for (Map.Entry<Integer, ChordIdentificationResult> entry : this.identificationResults.entrySet()) {
            if (entry.getKey() < this.expectedTimestamp) continue;
            Chord identifiedChord = entry.getValue().getChord();
            if (this.expectedChord.equals(identifiedChord)) {
                ++nbValidChords;
            }
            if (identifiedChord == null) continue;
            ++nbTotalChords;
        }
        if (nbTotalChords > 0) {
            double clarityScore = (double)nbValidChords / (double)nbTotalChords;
            this.clarityComment = clarityScore > 0.9 ? "Perfect!" : (clarityScore > 0.8 ? "A bit noisy!" : (clarityScore > 0.6 ? "Too noisy!" : "Way too noisy!"));
            return clarityScore;
        }
        this.clarityComment = "Chord missed!";
        return 0.0;
    }
}

