/*
 * Decompiled with CFR 0.152.
 */
package audio;

import fft.AudioChunk;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import utils.Util;

public class Microphone {
    public static final int SAMPLE_RATE = 48000;
    private static final int SAMPLE_SIZE_IN_BITS = 16;
    private static final int NB_CHANNELS = 1;
    public static final int NB_BYTES_TO_READ = 8192;
    private TargetDataLine line;

    public boolean init() {
        try {
            AudioFormat format = new AudioFormat(48000.0f, 16, 1, true, true);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
            if (!AudioSystem.isLineSupported(info)) {
                System.err.println("Line not supported");
            }
            this.line = (TargetDataLine)AudioSystem.getLine(info);
            this.line.open(format, this.line.getBufferSize());
            return true;
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void start() {
        this.line.start();
    }

    public AudioChunk readAudio() {
        int nbBytesToRead = 8192;
        byte[] rawAudio = new byte[nbBytesToRead];
        int nbBytesAvailable = this.line.available();
        if (nbBytesAvailable >= nbBytesToRead) {
            int nbBytesRead = this.line.read(rawAudio, 0, nbBytesToRead);
            if (nbBytesRead != nbBytesToRead) {
                Util.log("read only %d/%d bytes of raw audio", nbBytesRead, nbBytesToRead);
            }
            double[] audio = new double[nbBytesRead / 2];
            int i = 0;
            while (i < audio.length) {
                audio[i] = rawAudio[i << 1] << 8 | rawAudio[(i << 1) + 1] & 0xFF;
                ++i;
            }
            return new AudioChunk(audio);
        }
        return null;
    }

    public void stop() {
        this.line.stop();
    }

    public void close() {
        this.line.close();
    }
}

