/*
 * Decompiled with CFR 0.152.
 */
package audio;

import audio.ChordIdentificationResult;
import fft.FftResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import utils.Chord;
import utils.Fret;
import utils.Util;

public abstract class ChordIdentifier {
    public static final int MAXIMUM_SIMILARITY_SCORE = 200;
    private static final boolean TWEAK_SIMILARITY_SCORE_FOR_SIMILAR_CHORDS = true;
    private static ArrayList<Chord> definedChords;
    private static HashMap<Chord, HashMap<Chord, Double>> allSimilarChords;
    private static double minimumSimilarityScoreTweakFactor;
    private static ArrayList<Double> frequenciesToLookFor;

    private static double getDistanceBetweenFrequencies(double f0, double f1) {
        return Math.pow(f0 - f1, 2.0);
    }

    private static double getDistanceBetweenFrequenciesArrays(double[] f0s, double[] f1s) {
        assert (f0s.length == f1s.length);
        double distance = 0.0;
        int idFreq = 0;
        while (idFreq < f0s.length) {
            distance += ChordIdentifier.getDistanceBetweenFrequencies(f0s[idFreq], f1s[idFreq]);
            ++idFreq;
        }
        return distance;
    }

    public static ChordIdentificationResult identifyFftResult(FftResult fftResult, boolean tweakSimilarityScoreForSimilarChords) {
        double[] fftResultFrequencies = fftResult.getFrequenciesOfMagnitudesLocalHighs();
        Arrays.sort(fftResultFrequencies);
        HashMap<Chord, Double> chordsSimilaritiesScores = new HashMap<Chord, Double>();
        for (Chord chord : definedChords) {
            double[][] combinationsOfFftResultFrequencies;
            double[] chordFrequencies = chord.getNotesFrequencies();
            double score = Double.MAX_VALUE;
            double[][] dArray = combinationsOfFftResultFrequencies = Util.getCombinationsOfLength(fftResultFrequencies, chordFrequencies.length);
            int n = combinationsOfFftResultFrequencies.length;
            int n2 = 0;
            while (n2 < n) {
                double[] frequencies = dArray[n2];
                Arrays.sort(frequencies);
                double combinationScore = ChordIdentifier.getDistanceBetweenFrequenciesArrays(frequencies, chordFrequencies);
                if (combinationScore < score) {
                    score = combinationScore;
                }
                ++n2;
            }
            if (!(score <= 200.0 / minimumSimilarityScoreTweakFactor)) continue;
            chordsSimilaritiesScores.put(chord, score);
        }
        if (tweakSimilarityScoreForSimilarChords) {
            for (Map.Entry entry : chordsSimilaritiesScores.entrySet()) {
                Chord chord = (Chord)entry.getKey();
                double similarityScore = (Double)entry.getValue();
                HashMap<Chord, Double> similarChords = ChordIdentifier.getSimimarChords(chord);
                for (Map.Entry<Chord, Double> entryBis : similarChords.entrySet()) {
                    Chord similarChord = entryBis.getKey();
                    Double similarChordSimilarityScore = chordsSimilaritiesScores.get(similarChord);
                    if (similarChordSimilarityScore == null) continue;
                    double tweakFactor = entryBis.getValue();
                    double tweakedSimilarityScore = similarityScore * tweakFactor;
                    Util.log("score tweaked for %s: %.2f -> %.2f", chord.getName(), similarityScore, tweakedSimilarityScore);
                    if (!(tweakedSimilarityScore < similarityScore)) continue;
                    chordsSimilaritiesScores.put(chord, tweakedSimilarityScore);
                }
            }
        }
        return new ChordIdentificationResult(fftResult, chordsSimilaritiesScores);
    }

    public static double getChordSimilarity(Chord c0, Chord c1) {
        return 0.0;
    }

    public static HashMap<Chord, Double> getSimimarChords(Chord chord) {
        return allSimilarChords.get(chord);
    }

    private static void defineChord(Chord chord) {
        if (!definedChords.contains(chord)) {
            definedChords.add(chord);
        } else {
            Util.log("Chord %s already defined", chord.getName());
        }
    }

    public static Chord getChordByName(String name) {
        for (Chord chord : definedChords) {
            if (!chord.getName().equals(name)) continue;
            return chord;
        }
        return null;
    }

    private static void defineChords(ChordsDefinitionsDificultyLevel level) {
        definedChords = new ArrayList();
        if (level.ordinal() == ChordsDefinitionsDificultyLevel.DEBUG.ordinal()) {
            ChordIdentifier.defineChord(Chord.C);
            ChordIdentifier.defineChord(Chord.C7);
        }
        if (level.ordinal() >= ChordsDefinitionsDificultyLevel.VERY_BASIC.ordinal()) {
            ChordIdentifier.defineChord(Chord.A);
            ChordIdentifier.defineChord(Chord.C);
            ChordIdentifier.defineChord(Chord.F);
            ChordIdentifier.defineChord(Chord.D);
        }
        if (level.ordinal() >= ChordsDefinitionsDificultyLevel.BASIC.ordinal()) {
            ChordIdentifier.defineChord(Chord.G);
            ChordIdentifier.defineChord(Chord.G7);
            ChordIdentifier.defineChord(Chord.C7);
            ChordIdentifier.defineChord(Chord.Em);
        }
        if (level.ordinal() >= ChordsDefinitionsDificultyLevel.SIMPLE.ordinal()) {
            ChordIdentifier.defineChord(Chord.Am);
            ChordIdentifier.defineChord(Chord.A7);
            ChordIdentifier.defineChord(Chord.B);
            ChordIdentifier.defineChord(Chord.Bm);
            ChordIdentifier.defineChord(Chord.B7);
            ChordIdentifier.defineChord(Chord.Cm);
            ChordIdentifier.defineChord(Chord.Dm);
            ChordIdentifier.defineChord(Chord.D7);
            ChordIdentifier.defineChord(Chord.E);
            ChordIdentifier.defineChord(Chord.E7);
            ChordIdentifier.defineChord(Chord.Fm);
            ChordIdentifier.defineChord(Chord.F7);
            ChordIdentifier.defineChord(Chord.Gm);
        }
        if (level.ordinal() >= ChordsDefinitionsDificultyLevel.ALL.ordinal()) {
            ChordIdentifier.defineChord(Chord.A5);
            ChordIdentifier.defineChord(Chord.Am7);
            ChordIdentifier.defineChord(Chord.Amaj7);
            ChordIdentifier.defineChord(Chord.Asus2);
            ChordIdentifier.defineChord(Chord.Asus4);
            ChordIdentifier.defineChord(Chord.A7sus4);
            ChordIdentifier.defineChord(Chord.A6);
            ChordIdentifier.defineChord(Chord.Am6);
            ChordIdentifier.defineChord(Chord.A9);
            ChordIdentifier.defineChord(Chord.Am9);
            ChordIdentifier.defineChord(Chord.Aaug);
            ChordIdentifier.defineChord(Chord.Adim);
            ChordIdentifier.defineChord(new Chord("Bb", Fret.FRET_3, Fret.FRET_2, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Bbm", Fret.FRET_3, Fret.FRET_1, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Bb5", Fret.IGNORE_CORD, Fret.IGNORE_CORD, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Bb7", Fret.FRET_1, Fret.FRET_2, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Bbm7", Fret.FRET_1, Fret.FRET_1, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Bbmaj7", Fret.FRET_3, Fret.FRET_2, Fret.FRET_1, Fret.FRET_NONE));
            ChordIdentifier.defineChord(new Chord("Bbsus2", Fret.FRET_3, Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Bbsus4", Fret.FRET_3, Fret.FRET_3, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Bb7sus4", Fret.FRET_1, Fret.FRET_3, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Bb6", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Bbm6", Fret.FRET_3, Fret.FRET_1, Fret.FRET_3, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Bb9", Fret.FRET_1, Fret.FRET_2, Fret.FRET_1, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Bbm9", Fret.FRET_3, Fret.FRET_1, Fret.FRET_1, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Bbaug", Fret.FRET_3, Fret.FRET_2, Fret.FRET_2, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Bbdim", Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("B5", Fret.FRET_4, Fret.FRET_6, Fret.FRET_7, Fret.IGNORE_CORD));
            ChordIdentifier.defineChord(new Chord("Bm7", Fret.FRET_2, Fret.FRET_2, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Bmaj7", Fret.FRET_3, Fret.FRET_3, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Bsus2", Fret.FRET_4, Fret.FRET_1, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Bsus4", Fret.FRET_4, Fret.FRET_4, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("B7sus4", Fret.FRET_2, Fret.FRET_4, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("B6", Fret.FRET_1, Fret.FRET_3, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Bm6", Fret.FRET_1, Fret.FRET_2, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("B9", Fret.FRET_2, Fret.FRET_3, Fret.FRET_2, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Bm9", Fret.FRET_2, Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Baug", Fret.FRET_NONE, Fret.FRET_3, Fret.FRET_3, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Bdim", Fret.FRET_1, Fret.FRET_2, Fret.FRET_1, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("C5", Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_3, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Cm7", Fret.FRET_3, Fret.FRET_3, Fret.FRET_3, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Cmaj7", Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Csus2", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_3, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Csus4", Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("C7sus4", Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("C6", Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_NONE));
            ChordIdentifier.defineChord(new Chord("Cm6", Fret.FRET_NONE, Fret.FRET_3, Fret.FRET_3, Fret.FRET_NONE));
            ChordIdentifier.defineChord(new Chord("C9", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_NONE, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Cm9", Fret.FRET_5, Fret.FRET_3, Fret.FRET_3, Fret.FRET_5));
            ChordIdentifier.defineChord(new Chord("Caug", Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Cdim", Fret.FRET_2, Fret.FRET_3, Fret.FRET_2, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Db", Fret.FRET_1, Fret.FRET_1, Fret.FRET_1, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Dbm", Fret.FRET_1, Fret.FRET_4, Fret.FRET_4, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Db5", Fret.FRET_1, Fret.FRET_1, Fret.FRET_4, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Db7", Fret.FRET_1, Fret.FRET_1, Fret.FRET_1, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Dbm7", Fret.FRET_1, Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Dbmaj7", Fret.FRET_1, Fret.FRET_1, Fret.FRET_1, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Dbsus2", Fret.FRET_1, Fret.FRET_3, Fret.FRET_4, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Dbsus4", Fret.FRET_1, Fret.FRET_1, Fret.FRET_2, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Db7sus4", Fret.FRET_1, Fret.FRET_1, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Db6", Fret.FRET_1, Fret.FRET_1, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Dbm6", Fret.FRET_1, Fret.FRET_4, Fret.FRET_4, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Db9", Fret.FRET_1, Fret.FRET_3, Fret.FRET_1, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Dbm9", Fret.FRET_1, Fret.FRET_3, Fret.FRET_NONE, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Dbaug", Fret.FRET_2, Fret.FRET_1, Fret.FRET_1, Fret.FRET_NONE));
            ChordIdentifier.defineChord(new Chord("Dbdim", Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("D5", Fret.FRET_2, Fret.FRET_2, Fret.IGNORE_CORD, Fret.FRET_NONE));
            ChordIdentifier.defineChord(new Chord("Dm7", Fret.FRET_2, Fret.FRET_2, Fret.FRET_1, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Dmaj7", Fret.FRET_2, Fret.FRET_2, Fret.FRET_2, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Dsus2", Fret.FRET_2, Fret.FRET_2, Fret.FRET_NONE, Fret.FRET_NONE));
            ChordIdentifier.defineChord(new Chord("Dsus4", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_3, Fret.FRET_NONE));
            ChordIdentifier.defineChord(new Chord("D7sus4", Fret.FRET_2, Fret.FRET_2, Fret.FRET_3, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("D6", Fret.FRET_2, Fret.FRET_2, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Dm6", Fret.FRET_2, Fret.FRET_2, Fret.FRET_1, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("D9", Fret.FRET_2, Fret.FRET_4, Fret.FRET_2, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Dm9", Fret.FRET_2, Fret.FRET_5, Fret.FRET_NONE, Fret.FRET_5));
            ChordIdentifier.defineChord(new Chord("Daug", Fret.FRET_3, Fret.FRET_2, Fret.FRET_2, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Ddim", Fret.FRET_1, Fret.FRET_2, Fret.FRET_1, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Eb", Fret.FRET_NONE, Fret.FRET_3, Fret.FRET_3, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Ebm", Fret.FRET_3, Fret.FRET_3, Fret.FRET_2, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Eb5", Fret.FRET_3, Fret.FRET_3, Fret.FRET_6, Fret.FRET_6));
            ChordIdentifier.defineChord(new Chord("Eb7", Fret.FRET_3, Fret.FRET_3, Fret.FRET_3, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Ebm7", Fret.FRET_3, Fret.FRET_3, Fret.FRET_2, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Ebmaj7", Fret.FRET_3, Fret.FRET_3, Fret.FRET_3, Fret.FRET_5));
            ChordIdentifier.defineChord(new Chord("Ebsus2", Fret.FRET_3, Fret.FRET_3, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Ebsus4", Fret.FRET_1, Fret.FRET_3, Fret.FRET_4, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Eb7sus4", Fret.FRET_3, Fret.FRET_3, Fret.FRET_4, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Eb6", Fret.FRET_3, Fret.FRET_3, Fret.FRET_3, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Ebm6", Fret.FRET_3, Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Eb9", Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Ebm9", Fret.FRET_3, Fret.FRET_5, Fret.IGNORE_CORD, Fret.FRET_6));
            ChordIdentifier.defineChord(new Chord("Ebaug", Fret.FRET_NONE, Fret.FRET_3, Fret.FRET_3, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Ebdim", Fret.FRET_2, Fret.FRET_3, Fret.FRET_2, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("E5", Fret.FRET_4, Fret.FRET_4, Fret.FRET_NONE, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Em7", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_NONE, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Emaj7", Fret.FRET_1, Fret.FRET_3, Fret.FRET_NONE, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Esus2", Fret.FRET_4, Fret.FRET_4, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Esus4", Fret.FRET_2, Fret.FRET_4, Fret.FRET_5, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("E7sus4", Fret.FRET_4, Fret.FRET_4, Fret.FRET_5, Fret.FRET_5));
            ChordIdentifier.defineChord(new Chord("E6", Fret.FRET_4, Fret.FRET_4, Fret.FRET_4, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Em6", Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("E9", Fret.FRET_1, Fret.FRET_2, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Em9", Fret.FRET_NONE, Fret.FRET_4, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Eaug", Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Edim", Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("F5", Fret.IGNORE_CORD, Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Fm7", Fret.FRET_1, Fret.FRET_3, Fret.FRET_1, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Fmaj7", Fret.FRET_2, Fret.FRET_4, Fret.FRET_1, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Fsus2", Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Fsus4", Fret.FRET_3, Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("F7sus4", Fret.FRET_5, Fret.FRET_5, Fret.FRET_6, Fret.FRET_6));
            ChordIdentifier.defineChord(new Chord("F6", Fret.FRET_2, Fret.FRET_2, Fret.FRET_1, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Fm6", Fret.FRET_1, Fret.FRET_2, Fret.FRET_1, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("F9", Fret.FRET_2, Fret.FRET_3, Fret.FRET_3, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Fm9", Fret.FRET_NONE, Fret.FRET_5, Fret.FRET_4, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Faug", Fret.FRET_2, Fret.FRET_1, Fret.FRET_1, Fret.FRET_NONE));
            ChordIdentifier.defineChord(new Chord("Fdim", Fret.FRET_1, Fret.FRET_2, Fret.FRET_1, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Gb", Fret.FRET_3, Fret.FRET_1, Fret.FRET_2, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Gbm", Fret.FRET_2, Fret.FRET_1, Fret.FRET_2, Fret.FRET_NONE));
            ChordIdentifier.defineChord(new Chord("Gb5", Fret.IGNORE_CORD, Fret.FRET_1, Fret.FRET_2, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Gb7", Fret.FRET_3, Fret.FRET_4, Fret.FRET_2, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Gbm7", Fret.FRET_2, Fret.FRET_4, Fret.FRET_2, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Gbmaj7", Fret.FRET_3, Fret.FRET_5, Fret.FRET_2, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Gbsus2", Fret.FRET_1, Fret.FRET_1, Fret.FRET_2, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Gbsus4", Fret.FRET_4, Fret.FRET_1, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Gb7sus4", Fret.FRET_6, Fret.FRET_6, Fret.FRET_7, Fret.FRET_7));
            ChordIdentifier.defineChord(new Chord("Gb6", Fret.FRET_3, Fret.FRET_3, Fret.FRET_2, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Gbm6", Fret.FRET_2, Fret.FRET_1, Fret.FRET_2, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Gb9", Fret.FRET_1, Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Gbm9", Fret.FRET_1, Fret.FRET_2, Fret.FRET_2, Fret.FRET_NONE));
            ChordIdentifier.defineChord(new Chord("Gbaug", Fret.FRET_3, Fret.FRET_2, Fret.FRET_2, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Gbdim", Fret.FRET_2, Fret.FRET_3, Fret.FRET_2, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("G5", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_3, Fret.FRET_5));
            ChordIdentifier.defineChord(new Chord("Gm7", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_1, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Gmaj7", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Gsus2", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_3, Fret.FRET_NONE));
            ChordIdentifier.defineChord(new Chord("Gsus4", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_3, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("G7sus4", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_1, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("G6", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_NONE, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Gm6", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_NONE, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("G9", Fret.FRET_2, Fret.FRET_2, Fret.FRET_1, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Gm9", Fret.FRET_2, Fret.FRET_2, Fret.FRET_3, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Gaug", Fret.FRET_NONE, Fret.FRET_3, Fret.FRET_3, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Gdim", Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Ab", Fret.FRET_5, Fret.FRET_3, Fret.FRET_4, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Abm", Fret.FRET_4, Fret.FRET_3, Fret.FRET_4, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Ab5", Fret.FRET_1, Fret.FRET_3, Fret.FRET_4, Fret.IGNORE_CORD));
            ChordIdentifier.defineChord(new Chord("Ab7", Fret.FRET_1, Fret.FRET_3, Fret.FRET_2, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Abm7", Fret.FRET_1, Fret.FRET_3, Fret.FRET_2, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Abmaj7", Fret.FRET_1, Fret.FRET_3, Fret.FRET_3, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Absus2", Fret.FRET_1, Fret.FRET_3, Fret.FRET_4, Fret.FRET_1));
            ChordIdentifier.defineChord(new Chord("Absus4", Fret.FRET_1, Fret.FRET_3, Fret.FRET_4, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Ab7sus4", Fret.FRET_1, Fret.FRET_3, Fret.FRET_2, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("Ab6", Fret.FRET_1, Fret.FRET_3, Fret.FRET_1, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Abm6", Fret.FRET_4, Fret.FRET_5, Fret.FRET_4, Fret.FRET_6));
            ChordIdentifier.defineChord(new Chord("Ab9", Fret.FRET_2, Fret.FRET_2, Fret.FRET_1, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Abm9", Fret.FRET_3, Fret.FRET_3, Fret.FRET_4, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Abaug", Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("Abdim", Fret.FRET_1, Fret.FRET_2, Fret.FRET_1, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("A/C#", Fret.FRET_2, Fret.FRET_1, Fret.FRET_NONE, Fret.FRET_4));
            ChordIdentifier.defineChord(new Chord("A/E", Fret.FRET_6, Fret.FRET_4, Fret.FRET_5, Fret.FRET_NONE));
            ChordIdentifier.defineChord(new Chord("Am/C", Fret.FRET_2, Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("C/B", Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("C/E", Fret.FRET_NONE, Fret.FRET_4, Fret.FRET_NONE, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("C/F", Fret.FRET_NONE, Fret.FRET_5, Fret.FRET_NONE, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("C/G", Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_NONE, Fret.FRET_7));
            ChordIdentifier.defineChord(new Chord("Dm/G", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_1, Fret.FRET_NONE));
            ChordIdentifier.defineChord(new Chord("Em/B", Fret.FRET_4, Fret.FRET_4, Fret.FRET_3, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("Em/D", Fret.FRET_7, Fret.FRET_7, Fret.FRET_7, Fret.FRET_7));
            ChordIdentifier.defineChord(new Chord("Em/G", Fret.FRET_NONE, Fret.FRET_4, Fret.FRET_3, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("F/C", Fret.FRET_2, Fret.FRET_NONE, Fret.FRET_1, Fret.FRET_3));
            ChordIdentifier.defineChord(new Chord("G/A", Fret.FRET_2, Fret.FRET_2, Fret.FRET_3, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("G/B", Fret.FRET_4, Fret.FRET_2, Fret.FRET_3, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("G/F", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_1, Fret.FRET_2));
            ChordIdentifier.defineChord(new Chord("G/F#", Fret.FRET_NONE, Fret.FRET_2, Fret.FRET_2, Fret.FRET_2));
        }
        Util.log("Chord definition level: %s (%d chords)", level.name(), definedChords.size());
    }

    private static void computeSimilarChords() {
        allSimilarChords = new HashMap();
        minimumSimilarityScoreTweakFactor = 1.0;
        for (Chord chord : definedChords) {
            ChordIdentificationResult chordIdentificationResult = ChordIdentifier.identifyFftResult(chord.getTheoreticalFft(), false);
            double ownSimilarityScore = 1.0;
            int idResultOfChord = chordIdentificationResult.getChordPositionInResults(chord);
            if (idResultOfChord != -1) {
                ownSimilarityScore = chordIdentificationResult.getSimilarityScore(idResultOfChord);
            }
            HashMap<Chord, Double> similarChords = new HashMap<Chord, Double>();
            int idResult = 0;
            while (idResult < chordIdentificationResult.getNbResults()) {
                double similarityScoreTweakFactor;
                Chord similarChord = chordIdentificationResult.getChord(idResult);
                if (!similarChord.equals(chord) && (similarityScoreTweakFactor = chordIdentificationResult.getSimilarityScore(idResult) / ownSimilarityScore) < 1.0) {
                    similarChords.put(similarChord, similarityScoreTweakFactor);
                    if (similarityScoreTweakFactor < minimumSimilarityScoreTweakFactor) {
                        minimumSimilarityScoreTweakFactor = similarityScoreTweakFactor;
                    }
                }
                ++idResult;
            }
            allSimilarChords.put(chord, similarChords);
        }
    }

    public static void init() {
        ChordIdentifier.defineChords(ChordsDefinitionsDificultyLevel.SIMPLE);
        ChordIdentifier.computeSimilarChords();
        frequenciesToLookFor = new ArrayList();
        for (Chord chord : definedChords) {
            double[] dArray = chord.getNotesFrequencies();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double freq = dArray[n2];
                if (!frequenciesToLookFor.contains(freq)) {
                    frequenciesToLookFor.add(freq);
                }
                ++n2;
            }
        }
    }

    public static Chord getChordFromName(String chordName) {
        for (Chord chord : definedChords) {
            if (!chord.getName().equals(chordName)) continue;
            return chord;
        }
        return null;
    }

    private static enum ChordsDefinitionsDificultyLevel {
        DEBUG,
        VERY_BASIC,
        BASIC,
        SIMPLE,
        ALL;

    }
}

