/*
 * Decompiled with CFR 0.152.
 */
package audio;

import fft.FftResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import utils.Chord;
import utils.Util;

public class ChordIdentificationResult {
    private final FftResult fftResult;
    private final Chord[] chords;
    private final double[] similarityScores;
    private final double[] confidenceScores;

    public ChordIdentificationResult(FftResult fftResult, HashMap<Chord, Double> chordsSimilaritiesScores) {
        this.fftResult = fftResult;
        chordsSimilaritiesScores = (HashMap)Util.sortByValue(chordsSimilaritiesScores);
        Chord[] chords = new Chord[chordsSimilaritiesScores.size()];
        double[] similarityScores = new double[chordsSimilaritiesScores.size()];
        double[] confidenceScores = new double[chordsSimilaritiesScores.size()];
        int idChord = 0;
        for (Map.Entry entry : chordsSimilaritiesScores.entrySet()) {
            chords[idChord] = (Chord)entry.getKey();
            similarityScores[idChord] = (Double)entry.getValue();
            if (idChord > 0) {
                confidenceScores[idChord - 1] = (similarityScores[idChord] - similarityScores[idChord - 1]) / similarityScores[idChord - 1];
            }
            if (similarityScores[idChord] > 200.0) break;
            ++idChord;
        }
        this.chords = Arrays.copyOf(chords, idChord);
        this.similarityScores = Arrays.copyOf(similarityScores, idChord);
        this.confidenceScores = Arrays.copyOf(confidenceScores, idChord);
    }

    public FftResult getFftResult() {
        return this.fftResult;
    }

    public int getNbResults() {
        return this.chords.length;
    }

    public Chord getChord(int idResult) {
        return this.chords[idResult];
    }

    public double getSimilarityScore(int idResult) {
        return this.similarityScores[idResult];
    }

    public double getConfidenceScore(int idResult) {
        return this.confidenceScores[idResult];
    }

    public int getChordPositionInResults(Chord chord) {
        int idResult = 0;
        while (idResult < this.chords.length) {
            if (chord.equals(this.chords[idResult])) {
                return idResult;
            }
            ++idResult;
        }
        return -1;
    }

    public boolean isIdentificationSuccessful() {
        return this.getNbResults() > 0;
    }

    public Chord getChord() {
        return this.isIdentificationSuccessful() ? this.chords[0] : null;
    }

    public double getSimilarityScore() {
        return this.isIdentificationSuccessful() ? this.similarityScores[0] : 0.0;
    }

    public double getConfidenceScore() {
        return this.isIdentificationSuccessful() ? this.confidenceScores[0] : 0.0;
    }

    public String toString() {
        String str = "[ChordIdentificationResult:\n";
        int idChord = 0;
        while (idChord < this.chords.length) {
            str = String.valueOf(str) + Util.format("\t%s: score=%.2f confidence=%.2f\n", this.chords[idChord].getName(), this.similarityScores[idChord], this.confidenceScores[idChord]);
            ++idChord;
        }
        str = String.valueOf(str.substring(0, str.length() - 1)) + "]";
        return str;
    }
}

