/*
 * Decompiled with CFR 0.152.
 */
package audio;

import audio.Microphone;
import fft.AudioChunk;
import fft.Complex;
import fft.FftResult;
import utils.Chord;

public class AudioManager {
    public static final int FFT_ZERO_PADDING_COEF = 8;
    private Microphone microphone = new Microphone();

    public AudioManager() {
        this.microphone.init();
        this.microphone.start();
    }

    public FftResult computeFftFromMicrophone() {
        AudioChunk audioChunk = this.microphone.readAudio();
        if (audioChunk != null) {
            return AudioManager.computeFft(audioChunk);
        }
        return null;
    }

    public static FftResult computeFft(AudioChunk audioChunk) {
        int j;
        int n = audioChunk.getLength();
        if (Integer.highestOneBit(n) != n) {
            throw new IllegalArgumentException("n is not a power of 2");
        }
        double[] originalAudio = audioChunk.getAudio();
        int N = n * 8;
        Complex[] x = new Complex[N];
        int i = 0;
        while (i < n) {
            double hannedAudio = (0.5 - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)n)) * originalAudio[i];
            x[i] = new Complex(hannedAudio, 0.0);
            ++i;
        }
        i = n;
        while (i < N) {
            x[i] = new Complex(0.0, 0.0);
            ++i;
        }
        int shift = 1 + Integer.numberOfLeadingZeros(N);
        int k = 0;
        while (k < N) {
            j = Integer.reverse(k) >>> shift;
            if (j > k) {
                Complex temp = x[j];
                x[j] = x[k];
                x[k] = temp;
            }
            ++k;
        }
        int L = 2;
        while (L <= N) {
            j = 0;
            while (j < L / 2) {
                double jth = Math.PI * 2 * (double)j / (double)L;
                Complex w = new Complex(Math.cos(jth), -Math.sin(jth));
                int k2 = 0;
                while (k2 < N / L) {
                    Complex tao = w.times(x[k2 * L + j + L / 2]);
                    x[k2 * L + j + L / 2] = x[k2 * L + j].minus(tao);
                    x[k2 * L + j] = x[k2 * L + j].plus(tao);
                    ++k2;
                }
                ++j;
            }
            L += L;
        }
        double[] magnitudes = new double[x.length / 2];
        int i2 = 0;
        while (i2 < magnitudes.length) {
            magnitudes[i2] = x[i2].abs();
            ++i2;
        }
        return new FftResult(audioChunk, magnitudes);
    }

    public static FftResult computeTheoreticalFft(Chord chord) {
        int nbPoints = 16384;
        double[] magnitudes = new double[nbPoints];
        double frequencyStep = 48000.0 / (double)nbPoints / 2.0;
        double[] dArray = chord.getNotesFrequencies();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double freq = dArray[n2];
            magnitudes[(int)Math.round((double)(freq / frequencyStep))] = 0.01;
            ++n2;
        }
        return new FftResult(null, magnitudes);
    }
}

