/*
 * Decompiled with CFR 0.152.
 */
package app;

import audio.AudioManager;
import audio.ChordIdentifier;
import audio.TablatureDatabase;
import fft.FftResult;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import modes.AbstractMode;
import modes.LiveAnalysisMode;
import modes.TablatureEditorMode;
import modes.TablaturePlayingMode;
import utils.Instrument;
import utils.Note;
import utils.Style;
import utils.Util;

public class App
implements KeyListener,
MouseListener {
    private static long REDRAW_EVERY_X_MS = 33L;
    private static final LiveAnalysisMode liveAnalysisMode = new LiveAnalysisMode();
    private static final TablaturePlayingMode tablaturePlayingMode = new TablaturePlayingMode();
    private static final TablatureEditorMode tablatureEditorMode = new TablatureEditorMode();
    private static App singleton;
    private JFrame window;
    private JPanel screen;
    private AudioManager audioManager;
    private Instrument instrument = Instrument.UkuleleGcea;
    private AbstractMode currentMode;
    private long lastUpdateTimestamp;
    private long lastRedrawTimestamp;

    public App() {
        this.audioManager = new AudioManager();
        this.initWindow();
    }

    private void init() {
        Note.init();
        ChordIdentifier.init();
        TablatureDatabase.init();
        this.changeMode(liveAnalysisMode);
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    App.this.updateApp();
                    long timestamp = System.currentTimeMillis();
                    if (timestamp - App.this.lastRedrawTimestamp <= REDRAW_EVERY_X_MS) continue;
                    App.this.screen.repaint();
                    App.this.lastRedrawTimestamp = timestamp;
                }
            }
        }.start();
    }

    private void updateApp() {
        FftResult fftResult = this.audioManager.computeFftFromMicrophone();
        if (fftResult != null) {
            long timestamp = System.currentTimeMillis();
            this.currentMode.update(fftResult);
            this.lastUpdateTimestamp = timestamp;
        }
    }

    private void redrawApp(Graphics G) {
        Graphics2D g = (Graphics2D)G;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int W = this.screen.getWidth();
        int H = this.screen.getHeight();
        GradientPaint backgroundPaint = new GradientPaint(0.0f, 0.0f, Style.MIDNIGHTBLUE, 0.0f, H, Style.NAVY);
        g.setPaint(backgroundPaint);
        g.fillRect(0, 0, W, H);
        g.setFont(Util.getDefaultFont(18));
        FontMetrics fm = g.getFontMetrics();
        int Hmode = H - fm.getHeight() * 2;
        g.setColor(Style.POWDERBLUE);
        String instruction = "press (1) for live analysis mode, press (2) for tablature playing mode";
        g.drawString(instruction, (W - fm.stringWidth(instruction)) / 2, H - fm.getAscent());
        if (this.currentMode != null) {
            this.currentMode.draw(g, W, Hmode);
        }
    }

    private void initWindow() {
        this.screen = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                App.this.redrawApp(g);
            }
        };
        this.window = new JFrame();
        this.window.setTitle("Ukulele Learning App");
        this.window.setSize(1024, 768);
        this.window.setLocationRelativeTo(null);
        this.window.setDefaultCloseOperation(3);
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.window.setContentPane(this.screen);
        this.window.addKeyListener(this);
        this.screen.addMouseListener(this);
        this.window.setVisible(true);
    }

    private void changeMode(AbstractMode mode) {
        if (this.currentMode != null) {
            this.currentMode.exitMode();
        }
        mode.enterMode();
        this.currentMode = mode;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '1') {
            this.changeMode(liveAnalysisMode);
        } else if (e.getKeyChar() == '2') {
            this.changeMode(tablaturePlayingMode);
        } else if (e.getKeyChar() == '3') {
            this.changeMode(tablatureEditorMode);
        }
        this.currentMode.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public static App getSingleton() {
        return singleton;
    }

    public static void main(String[] args) {
        singleton = new App();
        singleton.init();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.currentMode.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

