/*
 * Decompiled with CFR 0.152.
 */
package streaming.session;

import com.fazecast.jSerialComm.SerialPort;
import common.engine.Ink;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import streaming.engine.Instruction;
import streaming.engine.Job;
import streaming.engine.Tool;
import streaming.enums.InstructionType;
import streaming.enums.JobPauseStatus;
import streaming.enums.PlotterSetting;
import streaming.enums.PlotterStatus;
import streaming.generators.GcodeGenerator;
import streaming.listeners.PlotterDataListener;
import streaming.listeners.StreamingProgressionListener;
import streaming.session.PlotterConfiguration;

public class StreamingManager
extends Thread {
    private static final int PLOTTER_SERIAL_BAUDRATE = 115200;
    private static final int PLOTTER_RX_BUFFER_SIZE = 128;
    private static final int REQUEST_STATUS_EVERY_X_MS = 100;
    private static final int PAUSE_SAFE_HEIGHT = 30;
    public static final StreamingManager Instance = new StreamingManager();
    private SerialPort serialPort;
    private boolean isConnectedToVirtualPlotter = false;
    private Job streamingJob = null;
    private Vector<Job> completedJobs = new Vector();
    private PlotterStatus plotterStatus = PlotterStatus.DISCONNECTED;
    private Tool loadedTool = Tool.UNDEFINED;
    private LinkedList<Instruction> priorityInstructionsBuffer = new LinkedList();
    private JobPauseStatus streamingJobPauseStatus = JobPauseStatus.ONGOING;
    private Vector<PlotterDataListener> plotterDataListeners = new Vector();
    private Vector<StreamingProgressionListener> streamingProgressionListeners = new Vector();
    private double[] workCoordinateOffset = new double[3];

    private StreamingManager() {
        this.start();
    }

    @Override
    public void run() {
        String rxBuffer = "";
        LinkedList<Instruction> sentButNotAcknowledgedInstructions = new LinkedList<Instruction>();
        int dataInPlotterRxBuffer = 0;
        long lastStatusRequestSentAt = 0L;
        while (true) {
            if (this.serialPort != null || this.isConnectedToVirtualPlotter) {
                long T;
                int nlPos;
                int nbBytesAvailable;
                int n = nbBytesAvailable = !this.isConnectedToVirtualPlotter ? this.serialPort.bytesAvailable() : 0;
                if (nbBytesAvailable > 0) {
                    byte[] dataRead = new byte[nbBytesAvailable];
                    if (this.serialPort.readBytes(dataRead, nbBytesAvailable) != nbBytesAvailable) {
                        System.out.println("Failed to read all available data");
                    }
                    rxBuffer = String.valueOf(rxBuffer) + new String(dataRead);
                }
                if (rxBuffer.length() > 0 && (nlPos = rxBuffer.indexOf("\r\n")) > -1) {
                    String line = rxBuffer.substring(0, nlPos);
                    rxBuffer = rxBuffer.substring(nlPos + "\r\n".length());
                    if (line.equals("ok")) {
                        Instruction acknowledgedInstr = (Instruction)sentButNotAcknowledgedInstructions.poll();
                        if (acknowledgedInstr != null) {
                            acknowledgedInstr.setEndTimestamp(System.currentTimeMillis());
                            dataInPlotterRxBuffer -= (String.valueOf(acknowledgedInstr.getInstructionToStream()) + "\n").length();
                            if (acknowledgedInstr.getRawInstruction().startsWith("G4P0;TOOL:")) {
                                int idTool = Integer.parseInt(acknowledgedInstr.getRawInstruction().substring("G4P0;TOOL:".length()).trim());
                                this.loadedTool = idTool == -1 ? Tool.NONE : PlotterConfiguration.Instance.getToolByInk(Ink.getAvailableInkByColor(idTool));
                                this.fireLoadedToolChanged(this.loadedTool);
                            } else {
                                acknowledgedInstr.getRawInstruction().endsWith(";safe pause\n");
                            }
                        }
                        if (this.streamingJob != null) {
                            if (dataInPlotterRxBuffer == 0 && this.streamingJob.isDone()) {
                                this.completedJobs.add(this.streamingJob);
                                this.streamingJob.exportExpectedVsRealDurations();
                                this.fireJobCompleted();
                                this.streamingJob = null;
                            } else if (this.streamingJob.isDone()) {
                                System.out.println("job done but data remaining in rxBuffer: " + rxBuffer);
                            }
                        }
                    } else if (line.equals("[MSG:'$H'|'$X' to unlock]")) {
                        this.readConfiguration();
                    } else if (line.length() > 0) {
                        Instruction instructionSent = (Instruction)sentButNotAcknowledgedInstructions.peek();
                        this.parseRxResponse(line, instructionSent != null ? instructionSent.getInstructionToStream() : "");
                    }
                }
                if (this.streamingJob != null && !this.streamingJob.isDone() || !this.priorityInstructionsBuffer.isEmpty()) {
                    Instruction instruction;
                    boolean instructionFromPriorityBuffer = false;
                    if (!this.priorityInstructionsBuffer.isEmpty()) {
                        instruction = this.priorityInstructionsBuffer.peek();
                        instructionFromPriorityBuffer = true;
                    } else {
                        instruction = this.streamingJob.getCurrentInstruction();
                    }
                    int instrLength = instruction.getInstructionToStream().length() + 1;
                    if (dataInPlotterRxBuffer + instrLength <= 128) {
                        if (instructionFromPriorityBuffer) {
                            this.priorityInstructionsBuffer.poll();
                        } else {
                            this.streamingJob.nextInstruction();
                        }
                        if (instruction.getType() == InstructionType.TOOL_CHANGE) {
                            this.addToolChangeInstructionsToBuffer(instruction.getToolToLoad());
                        } else {
                            sentButNotAcknowledgedInstructions.add(instruction);
                            dataInPlotterRxBuffer += instrLength;
                            instruction.setStartTimestamp(System.currentTimeMillis());
                            if (!this.isConnectedToVirtualPlotter) {
                                byte[] binaryInstruction = (String.valueOf(instruction.getInstructionToStream()) + "\n").getBytes();
                                if (binaryInstruction.length != instrLength) {
                                    System.err.println("error: binaryInstruction.length!=instrLength");
                                }
                                if (instructionFromPriorityBuffer) {
                                    System.out.println("priority: " + instruction.getInstructionToStream());
                                }
                                this.serialPort.writeBytes(binaryInstruction, instrLength);
                            } else {
                                rxBuffer = String.valueOf(rxBuffer) + "ok\r\n";
                            }
                            this.fireStreamingProgressionListeners(this.streamingJob);
                        }
                    }
                }
                if ((T = System.currentTimeMillis()) - lastStatusRequestSentAt >= 100L) {
                    if (!this.isConnectedToVirtualPlotter) {
                        byte[] statusRequest = "?".getBytes();
                        this.serialPort.writeBytes(statusRequest, statusRequest.length);
                        lastStatusRequestSentAt = T;
                    } else if (this.streamingJob != null && !this.streamingJob.isDone()) {
                        double[] workPosition = (double[])this.streamingJob.getCurrentInstruction().getEndPosition().clone();
                        workPosition[0] = workPosition[0] + this.streamingJob.getTranslation()[0];
                        workPosition[1] = workPosition[1] + this.streamingJob.getTranslation()[1];
                        this.firePlotterDataChanged(workPosition, new double[]{0.0, 0.0, 0.0}, 0.0, new boolean[3]);
                    }
                }
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void parseRxResponse(String response, String instructionSent) {
        block69: {
            block66: {
                if (response.charAt(0) != '<') break block66;
                response = response.substring(1, response.length() - 1);
                String[] fields = response.split("\\|");
                PlotterStatus plotterStatus = PlotterStatus.DISCONNECTED;
                double[] workCoordinateOffset = null;
                double[] machinePosition = null;
                double[] workPosition = null;
                double currentFeedrate = 0.0;
                boolean[] endstopsTriggered = new boolean[3];
                String machineState = fields[0];
                if (machineState.contains(":")) {
                    machineState = machineState.substring(0, machineState.indexOf(":"));
                }
                switch (machineState) {
                    case "Idle": {
                        plotterStatus = PlotterStatus.IDLE;
                        break;
                    }
                    case "Run": {
                        plotterStatus = PlotterStatus.RUN;
                        break;
                    }
                    case "Hold": {
                        plotterStatus = PlotterStatus.HOLD;
                        break;
                    }
                    case "Jog": {
                        plotterStatus = PlotterStatus.JOG;
                        break;
                    }
                    case "Alarm": {
                        plotterStatus = PlotterStatus.ALARM;
                        break;
                    }
                    case "Door": {
                        plotterStatus = PlotterStatus.DOOR;
                        break;
                    }
                    case "Check": {
                        plotterStatus = PlotterStatus.CHECK;
                        break;
                    }
                    case "Home": {
                        plotterStatus = PlotterStatus.HOME;
                        break;
                    }
                    case "Sleep": {
                        plotterStatus = PlotterStatus.SLEEP;
                    }
                }
                int idField = 1;
                while (idField < fields.length) {
                    String[] keyValue = fields[idField].split(":");
                    String[] values = keyValue[1].split(",");
                    switch (keyValue[0]) {
                        case "MPos": {
                            machinePosition = new double[]{Double.parseDouble(values[0]), Double.parseDouble(values[1]), Double.parseDouble(values[2])};
                            break;
                        }
                        case "WPos": {
                            workPosition = new double[]{Double.parseDouble(values[0]), Double.parseDouble(values[1]), Double.parseDouble(values[2])};
                            break;
                        }
                        case "WCO": {
                            workCoordinateOffset = new double[]{Double.parseDouble(values[0]), Double.parseDouble(values[1]), Double.parseDouble(values[2])};
                            break;
                        }
                        case "F": 
                        case "FS": {
                            currentFeedrate = Double.parseDouble(values[0]);
                            break;
                        }
                        case "Pn": {
                            int axis = 0;
                            while (axis < 3) {
                                endstopsTriggered[axis] = keyValue[1].contains(String.valueOf((char)(88 + axis)));
                                axis = (char)(axis + 1);
                            }
                            break;
                        }
                    }
                    ++idField;
                }
                if (workCoordinateOffset != null) {
                    this.workCoordinateOffset = workCoordinateOffset;
                }
                if (workPosition == null) {
                    workPosition = new double[]{machinePosition[0] - this.workCoordinateOffset[0], machinePosition[1] - this.workCoordinateOffset[1], machinePosition[2] - this.workCoordinateOffset[2]};
                } else if (machinePosition == null) {
                    machinePosition = new double[]{workPosition[0] + this.workCoordinateOffset[0], workPosition[1] + this.workCoordinateOffset[1], workPosition[2] + this.workCoordinateOffset[2]};
                }
                if (this.plotterStatus != plotterStatus) {
                    this.firePlotterStatusChanged(plotterStatus);
                }
                this.firePlotterDataChanged(workPosition, machinePosition, currentFeedrate, endstopsTriggered);
                break block69;
            }
            if (instructionSent.equals("$$")) {
                Matcher m = Pattern.compile("\\$(\\d+)\\s*=(\\d*.?\\d+)").matcher(response);
                if (m.find()) {
                    int settingId = Integer.parseInt(m.group(1));
                    double settingValue = Double.parseDouble(m.group(2));
                    PlotterSetting setting = GcodeGenerator.getPlotterSettingByGrblId(settingId);
                    if (setting != null) {
                        if (setting == PlotterSetting.FLYING_XY_MAX_SPEED || setting == PlotterSetting.Z_MAX_SPEED) {
                            settingValue /= 60.0;
                        }
                        PlotterConfiguration.Instance.overrideDoubleSettingValue(setting, settingValue);
                    }
                }
            } else if (response.startsWith("error")) {
                System.out.println(String.format(Locale.US, "Error for instruction %s: %s", instructionSent, response));
            }
        }
    }

    private void addToolChangeInstructionsToBuffer(Tool tool) {
        if (tool == Tool.UNDEFINED) {
            System.out.println("Undefined tool");
        } else if (tool != this.loadedTool) {
            String gcode = "";
            if (this.loadedTool.isAnActualTool()) {
                gcode = String.valueOf(gcode) + this.loadedTool.getUnloadingInstructions();
            }
            if (tool.isAnActualTool()) {
                gcode = String.valueOf(gcode) + tool.getLoadingInstructions();
            }
            String[] instructions = gcode.split("\n");
            int idInstr = 0;
            while (idInstr < instructions.length) {
                this.priorityInstructionsBuffer.add(new Instruction(new Job("", this.loadedTool, false), instructions[idInstr], new double[]{Double.NaN, Double.NaN, Double.NaN}));
                ++idInstr;
            }
        }
    }

    public PlotterStatus getPlotterStatus() {
        return this.plotterStatus;
    }

    private void firePlotterStatusChanged(PlotterStatus status) {
        this.plotterStatus = status;
        for (PlotterDataListener listener : this.plotterDataListeners) {
            listener.plotterStatusChanged(status);
        }
    }

    private void fireLoadedToolChanged(Tool newlyLoadedTool) {
        for (PlotterDataListener listener : this.plotterDataListeners) {
            listener.loadedToolChanged(newlyLoadedTool);
        }
    }

    private void firePlotterDataChanged(double[] workPosition, double[] machinePosition, double currentFeedrate, boolean[] endstopsTriggered) {
        for (PlotterDataListener listener : this.plotterDataListeners) {
            listener.plotterDataChanged(workPosition, machinePosition, currentFeedrate, endstopsTriggered);
        }
    }

    private void fireStartedNewJob(Job job) {
        for (StreamingProgressionListener listener : this.streamingProgressionListeners) {
            listener.startedNewJob(job);
        }
    }

    private void fireStreamingProgressionListeners(Job job) {
        for (StreamingProgressionListener listener : this.streamingProgressionListeners) {
            listener.streamingProgressionChanged(job.getElapsedDurationSinceJobStart(), job.getNbExecutedInstructionsPerInk(), job.getDrawedDistancesPerInk(), job.getEstimatedRemainingDurationPerInk());
        }
    }

    private void fireJobCompleted() {
        for (StreamingProgressionListener listener : this.streamingProgressionListeners) {
            listener.jobCompleted();
        }
    }

    public String[] getAvailableStreamingPorts() {
        SerialPort[] serialPorts = SerialPort.getCommPorts();
        String[] portNames = new String[serialPorts.length];
        int idPort = 0;
        while (idPort < serialPorts.length) {
            portNames[idPort] = serialPorts[idPort].getSystemPortName();
            ++idPort;
        }
        return portNames;
    }

    public boolean connectTo(String port) {
        if (this.serialPort == null && !this.isConnectedToVirtualPlotter) {
            SerialPort serialPort = SerialPort.getCommPort((String)port);
            serialPort.setBaudRate(115200);
            if (serialPort.openPort()) {
                System.out.println("Connected to " + port + " successfully");
                this.serialPort = serialPort;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean connectToVirtualPlotter() {
        if (this.serialPort != null) {
            return false;
        }
        System.out.println("Connected to Virtual Plotter successfully");
        this.isConnectedToVirtualPlotter = true;
        this.firePlotterStatusChanged(PlotterStatus.SIMULATING);
        return true;
    }

    public boolean disconnect() {
        if (this.serialPort != null) {
            if (this.serialPort.closePort()) {
                this.serialPort = null;
                return true;
            }
            return false;
        }
        this.isConnectedToVirtualPlotter = false;
        this.firePlotterStatusChanged(PlotterStatus.DISCONNECTED);
        return true;
    }

    public void setInitiallyLoadedTool(Tool tool) {
        if (this.loadedTool != Tool.UNDEFINED) {
            System.out.println("The loaded tool is known (%s), you must start a tool change job");
        } else {
            this.loadedTool = tool;
            this.fireLoadedToolChanged(tool);
        }
    }

    public void startChangeToolJob(Tool tool) {
        if (this.loadedTool != Tool.UNDEFINED) {
            if (tool != this.loadedTool) {
                String instructions = "";
                if (this.loadedTool.isAnActualTool()) {
                    instructions = String.valueOf(instructions) + this.loadedTool.getUnloadingInstructions();
                }
                if (tool.isAnActualTool()) {
                    instructions = String.valueOf(instructions) + tool.getLoadingInstructions();
                }
                System.out.println("job tool change:");
                System.out.println(instructions);
                this.startJob(new Job(instructions, this.loadedTool, false));
            }
        } else {
            System.out.println("Cannot change tool until initially loaded tool has been defined");
        }
    }

    public void startJob(Job job) {
        if (job.isCompatibleWithPlotter()) {
            if (this.loadedTool != Tool.UNDEFINED || job.canRunWithUnknownLoadedTool()) {
                if (this.streamingJob == null) {
                    if (this.serialPort != null || this.isConnectedToVirtualPlotter) {
                        this.fireStartedNewJob(job);
                        this.streamingJob = job;
                    }
                } else {
                    System.out.println("Cannot start multiple jobs at the same time");
                }
            } else {
                System.out.println("Cannot start this kind of job until the currently loaded tool has been defined");
            }
        } else {
            System.out.println("Job incompatible with plotter");
        }
    }

    public void jog(double dx, double dy, double dz, double feedrate) {
        this.startJob(new Job(GcodeGenerator.jogMotion(dx, dy, dz, feedrate), this.loadedTool, true));
    }

    public void readConfiguration() {
        this.startJob(new Job("$$", this.loadedTool, true));
    }

    public void home() {
        this.startJob(new Job("$H\n", this.loadedTool, true));
    }

    public void unlock() {
        this.startJob(new Job("$X\n", this.loadedTool, true));
    }

    public void reset() {
        this.startJob(new Job(GcodeGenerator.RESET_INSTRUCTION, this.loadedTool, true));
    }

    public void park() {
        this.startJob(new Job(GcodeGenerator.fastLinearMovement(PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.PARKING_X), PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.PARKING_Y), PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.PARKING_Z)), this.loadedTool, true));
    }

    public void pauseJob() {
        if (this.streamingJobPauseStatus == JobPauseStatus.ONGOING) {
            System.out.println("not implemented yet");
        }
    }

    public void emergencyPause() {
        if (this.streamingJobPauseStatus == JobPauseStatus.ONGOING) {
            this.priorityInstructionsBuffer.add(new Instruction("!"));
            this.streamingJobPauseStatus = JobPauseStatus.EMERGENCY_PAUSED;
        }
    }

    public void resumeJob() {
        if (this.streamingJobPauseStatus != JobPauseStatus.CLEANLY_PAUSED && this.streamingJobPauseStatus == JobPauseStatus.EMERGENCY_PAUSED) {
            this.priorityInstructionsBuffer.add(new Instruction("~"));
        }
        this.streamingJobPauseStatus = JobPauseStatus.ONGOING;
    }

    public void stopJob() {
        this.streamingJobPauseStatus = JobPauseStatus.ONGOING;
        this.streamingJob.cancelJob();
        this.priorityInstructionsBuffer.add(new Instruction(GcodeGenerator.relativeFastLinearMovement(0.0, 0.0, 30.0)));
    }

    public Job getStreamingJob() {
        return this.streamingJob;
    }

    public Vector<Job> getCompletedJobs() {
        return this.completedJobs;
    }

    public void clearCompletedJobs() {
        this.completedJobs.clear();
    }

    public Tool getLoadedTool() {
        return this.loadedTool;
    }

    public void addPlotterDataListener(PlotterDataListener listener) {
        this.plotterDataListeners.add(listener);
    }

    public void addStreamingProgressionListener(StreamingProgressionListener listener) {
        this.streamingProgressionListeners.add(listener);
    }
}

