/*
 * Decompiled with CFR 0.152.
 */
package streaming.session;

import common.engine.Ink;
import common.engine.Utils;
import java.io.File;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;
import streaming.engine.Tool;
import streaming.enums.PlotterSetting;

public class PlotterConfiguration {
    public static PlotterConfiguration Instance;
    private static final String PLOTTER_CONFIGURATION_FILE = "plotter-configuration.json";
    private Tool[] tools;
    private JSONObject settings;

    private PlotterConfiguration() {
        try {
            this.settings = new JSONObject(Utils.readFile(new File(PLOTTER_CONFIGURATION_FILE)));
        }
        catch (IOException e) {
            System.err.println("Failed to read Plotter configuration file");
            System.exit(-1);
        }
        JSONArray inksJsonArray = this.settings.getJSONArray("inks");
        int idInk = 0;
        while (idInk < inksJsonArray.length()) {
            Ink ink = (Ink)Ink.fromJsonObject(inksJsonArray.getJSONObject(idInk));
            if (!Ink.registerNewAvailableInk(ink)) {
                System.err.println(String.format("Failed to register ink %s, there is already an ink with the same color registered", ink.getName()));
            }
            ++idInk;
        }
        JSONArray toolsJsonArray = this.settings.getJSONArray("tools");
        this.tools = new Tool[toolsJsonArray.length()];
        int idTool = 0;
        while (idTool < this.tools.length) {
            this.tools[idTool] = (Tool)Tool.fromJsonObject(toolsJsonArray.getJSONObject(idTool));
            ++idTool;
        }
    }

    public boolean getBooleanSettingValue(PlotterSetting setting) {
        return this.settings.has(setting.getName()) ? this.settings.getBoolean(setting.getName()) : false;
    }

    public double getDoubleSettingValue(PlotterSetting setting) {
        return this.settings.has(setting.getName()) ? this.settings.getDouble(setting.getName()) : 0.0;
    }

    public String getStringSettingValue(PlotterSetting setting) {
        return this.settings.has(setting.getName()) ? this.settings.getString(setting.getName()) : "";
    }

    public void overrideDoubleSettingValue(PlotterSetting setting, double value) {
        if (!this.settings.has(setting.getName()) || this.settings.getDouble(setting.getName()) != value) {
            System.out.println(String.format("Overriding %s, set at %f instead of %f", setting.getName(), value, this.settings.getDouble(setting.getName())));
            this.settings.put(setting.getName(), value);
        }
    }

    public Tool[] getTools() {
        return this.tools;
    }

    public Tool getToolByInk(Ink ink) {
        Tool[] toolArray = this.tools;
        int n = this.tools.length;
        int n2 = 0;
        while (n2 < n) {
            Tool tool = toolArray[n2];
            if (tool.getInk().equals(ink)) {
                return tool;
            }
            ++n2;
        }
        return Tool.UNDEFINED;
    }

    public static void initSingleton() {
        if (Instance == null) {
            Instance = new PlotterConfiguration();
        }
    }
}

