/*
 * Decompiled with CFR 0.152.
 */
package streaming.gui;

import common.engine.Ink;
import common.engine.Utils;
import common.enums.LabelType;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import streaming.engine.Job;
import streaming.engine.Tool;
import streaming.enums.PlotterStatus;
import streaming.gui.ColoredProgressBar;
import streaming.listeners.PlotterDataListener;
import streaming.listeners.StreamingProgressionListener;
import streaming.session.StreamingManager;

public class StreamingStatusBar
extends JPanel
implements PlotterDataListener,
StreamingProgressionListener {
    private JLabel plotterStatusLabel;
    private JLabel xPositionLabel;
    private JLabel yPositionLabel;
    private JLabel zPositionLabel;
    private JLabel feedrateLabel;
    private JLabel endstopsLabel;
    private ColoredProgressBar progressBar;
    private JLabel elapsedDurationLabel;
    private JLabel remainingDurationLabel;
    private JLabel instructionsProgressionLabel;
    private JLabel drawingProgressionLabel;
    private HashMap<Ink, Integer> nbInstructionsPerInk;
    private HashMap<Ink, Integer> estimatedDurationsPerInk;
    private HashMap<Ink, Double> drawingDistancesPerInk;
    private boolean showWorkPosition = true;

    public StreamingStatusBar() {
        StreamingManager.Instance.addPlotterDataListener(this);
        StreamingManager.Instance.addStreamingProgressionListener(this);
        this.setLayout(new BoxLayout(this, 0));
        Font boldFont = new JLabel().getFont().deriveFont(1);
        this.add(new JLabel("Status:"));
        this.plotterStatusLabel = new JLabel("Disconnected");
        this.plotterStatusLabel.setFont(boldFont);
        this.plotterStatusLabel.setForeground(Color.RED);
        this.add(this.plotterStatusLabel);
        this.add(new JLabel(" X:"));
        this.xPositionLabel = new JLabel("?");
        this.xPositionLabel.setFont(boldFont);
        this.add(this.xPositionLabel);
        this.add(new JLabel(" Y:"));
        this.yPositionLabel = new JLabel("?");
        this.yPositionLabel.setFont(boldFont);
        this.add(this.yPositionLabel);
        this.add(new JLabel(" Z:"));
        this.zPositionLabel = new JLabel("?");
        this.zPositionLabel.setFont(boldFont);
        this.add(this.zPositionLabel);
        this.add(new JLabel(" Feedrate:"));
        this.feedrateLabel = new JLabel("?");
        this.feedrateLabel.setFont(boldFont);
        this.add(this.feedrateLabel);
        this.add(new JLabel(" Endstops:"));
        this.endstopsLabel = new JLabel("?");
        this.endstopsLabel.setFont(boldFont);
        this.add(this.endstopsLabel);
        this.progressBar = new ColoredProgressBar();
        this.add(this.progressBar);
        this.add(new JLabel(" Elapsed time:"));
        this.elapsedDurationLabel = new JLabel("0:00:00");
        this.elapsedDurationLabel.setFont(boldFont);
        this.add(this.elapsedDurationLabel);
        this.add(new JLabel(" Remaining time:"));
        this.remainingDurationLabel = new JLabel("0:00:00");
        this.remainingDurationLabel.setFont(boldFont);
        this.add(this.remainingDurationLabel);
        this.add(new JLabel(" Instructions:"));
        this.instructionsProgressionLabel = new JLabel("0/0");
        this.instructionsProgressionLabel.setFont(boldFont);
        this.add(this.instructionsProgressionLabel);
        this.add(new JLabel(" Drawing:"));
        this.drawingProgressionLabel = new JLabel("0m/0m");
        this.drawingProgressionLabel.setFont(boldFont);
        this.add(this.drawingProgressionLabel);
    }

    @Override
    public void plotterStatusChanged(PlotterStatus status) {
        String label = String.valueOf(String.valueOf(status.name().charAt(0)).toUpperCase()) + status.name().substring(1);
        Color foreground = Color.black;
        Color background = null;
        switch (status) {
            case DISCONNECTED: {
                foreground = Color.RED;
                break;
            }
            case IDLE: {
                foreground = Color.GREEN;
                break;
            }
            case RUN: {
                background = Color.BLUE;
                break;
            }
            case HOLD: {
                background = Color.YELLOW;
                break;
            }
            case JOG: {
                background = Color.BLUE;
                break;
            }
            case ALARM: {
                background = Color.RED;
                break;
            }
            case DOOR: {
                background = Color.ORANGE;
                break;
            }
            case CHECK: {
                background = Color.YELLOW;
                break;
            }
            case HOME: {
                background = Color.YELLOW;
                break;
            }
            case SLEEP: {
                foreground = Color.YELLOW;
                break;
            }
            case SIMULATING: {
                background = Color.BLUE;
            }
        }
        this.plotterStatusLabel.setText(label);
        if (background != null) {
            this.plotterStatusLabel.setForeground(Color.WHITE);
            this.plotterStatusLabel.setBackground(background);
            this.plotterStatusLabel.setOpaque(true);
        } else {
            this.plotterStatusLabel.setForeground(foreground);
            this.plotterStatusLabel.setOpaque(false);
        }
    }

    @Override
    public void loadedToolChanged(Tool newlyLoadedTool) {
    }

    @Override
    public void plotterDataChanged(double[] workPosition, double[] machinePosition, double currentFeedrate, boolean[] endstopsTriggered) {
        double x;
        double d = x = this.showWorkPosition ? workPosition[0] : machinePosition[0];
        if (x != Double.NaN) {
            this.xPositionLabel.setText(String.format(Locale.US, "%6s", String.format(Locale.US, "%.2f", x)));
            this.xPositionLabel.setToolTipText(String.format(Locale.US, "<html>Work position: <b>%.2f</b><br/>Machine position: <b>%.2f</b>", workPosition[0], machinePosition[0]));
            double y = this.showWorkPosition ? workPosition[1] : machinePosition[1];
            this.yPositionLabel.setText(String.format(Locale.US, "%6s", String.format(Locale.US, "%.2f", y)));
            this.yPositionLabel.setToolTipText(String.format(Locale.US, "<html>Work position: <b>%.2f</b><br/>Machine position: <b>%.2f</b>", workPosition[0], machinePosition[0]));
            double z = this.showWorkPosition ? workPosition[2] : machinePosition[2];
            this.zPositionLabel.setText(String.format(Locale.US, "%5s", String.format(Locale.US, "%.2f", z)));
            this.zPositionLabel.setToolTipText(String.format(Locale.US, "<html>Work position: <b>%.2f</b><br/>Machine position: <b>%.2f</b>", workPosition[0], machinePosition[0]));
            this.feedrateLabel.setText(String.format(Locale.US, "%4s", String.format(Locale.US, "%.0f", currentFeedrate)));
        } else {
            this.xPositionLabel.setText("     ?");
            this.xPositionLabel.setToolTipText(null);
            this.yPositionLabel.setText("     ?");
            this.yPositionLabel.setToolTipText(null);
            this.zPositionLabel.setText("    ?");
            this.zPositionLabel.setToolTipText(null);
        }
        String endstops = "";
        int axis = 0;
        while (axis < 3) {
            if (endstopsTriggered[axis]) {
                endstops = String.valueOf(endstops) + (char)(88 + axis) + " ";
            }
            ++axis;
        }
        if (endstops.length() == 0) {
            endstops = "OK";
            this.endstopsLabel.setForeground(Color.BLACK);
        } else {
            this.endstopsLabel.setForeground(Color.RED);
        }
        this.endstopsLabel.setText(endstops);
    }

    @Override
    public void startedNewJob(Job job) {
        this.nbInstructionsPerInk = job.getNbInstructionsPerInk();
        this.drawingDistancesPerInk = job.getDrawingDistancesPerInk();
        this.estimatedDurationsPerInk = job.getEstimatedDurationPerInk();
        this.progressBar.setColorOrder(job.getOrderedInks());
    }

    @Override
    public void streamingProgressionChanged(double elapsedDurationSinceJobStart, HashMap<Ink, Integer> nbInstructionsExecutedPerInk, HashMap<Ink, Double> drawedDistancesPerInk, HashMap<Ink, Integer> estimatedRemainingDurationPerInk) {
        int nbInstructions = 0;
        double drawingDistance = 0.0;
        int estimatedDuration = 0;
        int nbInstructionsExecuted = 0;
        double drawedDistance = 0.0;
        int estimatedRemainingDuration = 0;
        for (Ink ink : Ink.getAvailableInks()) {
            nbInstructions += this.nbInstructionsPerInk.getOrDefault(ink, 0).intValue();
            drawingDistance += this.drawingDistancesPerInk.getOrDefault(ink, 0.0).doubleValue();
            estimatedDuration += this.estimatedDurationsPerInk.getOrDefault(ink, 0).intValue();
            nbInstructionsExecuted += nbInstructionsExecutedPerInk.getOrDefault(ink, 0).intValue();
            drawedDistance += drawedDistancesPerInk.getOrDefault(ink, 0.0).doubleValue();
            estimatedRemainingDuration += estimatedRemainingDurationPerInk.getOrDefault(ink, 0).intValue();
        }
        this.elapsedDurationLabel.setText(Utils.beautifyDurationAsClock(elapsedDurationSinceJobStart));
        this.remainingDurationLabel.setText(Utils.beautifyDurationAsClock(estimatedRemainingDuration));
        this.remainingDurationLabel.setToolTipText(Utils.generateIntValuePerInkTooltip(estimatedRemainingDurationPerInk, LabelType.DURATION));
        this.instructionsProgressionLabel.setText(Utils.beautifyProgression(nbInstructionsExecuted, nbInstructions, LabelType.DEFAULT));
        this.instructionsProgressionLabel.setToolTipText(Utils.generateIntProgressionPerInkTooltip(nbInstructionsExecutedPerInk, this.nbInstructionsPerInk, LabelType.DEFAULT));
        this.drawingProgressionLabel.setText(Utils.beautifyProgression(drawedDistance, drawingDistance, LabelType.DISTANCE));
        this.drawingProgressionLabel.setToolTipText(Utils.generateDoubleProgressionPerInkTooltip(drawedDistancesPerInk, this.drawingDistancesPerInk, LabelType.DISTANCE));
        this.progressBar.setProgress(drawedDistancesPerInk, this.drawingDistancesPerInk);
    }

    @Override
    public void jobCompleted() {
    }
}

