/*
 * Decompiled with CFR 0.152.
 */
package streaming.gui;

import common.engine.Ink;
import common.engine.Utils;
import common.gui.View;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import streaming.engine.Instruction;
import streaming.engine.Job;
import streaming.engine.Tool;
import streaming.enums.PlotterSetting;
import streaming.enums.PlotterStatus;
import streaming.listeners.PlotterDataListener;
import streaming.listeners.StreamingProgressionListener;
import streaming.session.PlotterConfiguration;
import streaming.session.StreamingManager;

public class PlotterView
extends View
implements PlotterDataListener,
StreamingProgressionListener,
MouseListener,
ActionListener {
    private static final boolean SHOW_FLYING_MOTIONS = true;
    private static final int PX_PER_MM = 100;
    private static final double DRAWING_AREA_WIDTH = PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.DRAWING_AREA_WIDTH);
    private static final double DRAWING_AREA_HEIGHT = PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.DRAWING_AREA_HEIGHT);
    private static final double DRAWING_AREA_X = PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.DRAWING_AREA_X);
    private static final double DRAWING_AREA_Y = PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.DRAWING_AREA_Y);
    private static final double TOOL_WIDTH_IN_MM = 12.0;
    private static final double PEN_TIP_WIDTH_IN_MM = 0.25;
    private static final double SAFE_Z_HEIGHT = 4.0;
    private static final Color FLYING_MOTIONS_COLOR = new Color(255, 255, 0, 128);
    private static final Stroke PEN_STROKE = Utils.getPenStrokeInPx(25.0);
    private static final Stroke FLYING_STROKE = Utils.getPenStrokeInPx(10.0);
    private Job previewingJob = null;
    private Tool loadedTool = Tool.UNDEFINED;
    private double[] workPosition;
    private boolean translatingPreviewingJob = false;
    private HashMap<Ink, Integer> nbInstructionsExecutedPerInkForStreamingJob;
    private final JPopupMenu popupMenu;
    private JMenuItem moveHereMenuItem;
    private JMenuItem clearDrawingAreaMenuItem;
    private JMenuItem bottomLeftDrawingAreaOriginMenuItem;
    private JMenuItem topLeftDrawingAreaOriginMenuItem;
    private JMenuItem bottomRightDrawingAreaOriginMenuItem;
    private JMenuItem topRightDrawingAreaOriginMenuItem;
    private JMenuItem parkingPositionMenuItem;
    private JMenuItem tool0ParkingPositionMenuItem;

    public PlotterView() {
        super("Plotter view");
        this.viewPanel.addMouseListener(this);
        StreamingManager.Instance.addPlotterDataListener(this);
        StreamingManager.Instance.addStreamingProgressionListener(this);
        this.popupMenu = this.initPopupMenu();
    }

    private JPopupMenu initPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        this.moveHereMenuItem = new JMenuItem("Move here");
        this.moveHereMenuItem.addActionListener(this);
        popupMenu.add(this.moveHereMenuItem);
        this.clearDrawingAreaMenuItem = new JMenuItem("Clear drawing area");
        this.clearDrawingAreaMenuItem.addActionListener(this);
        popupMenu.add(this.clearDrawingAreaMenuItem);
        popupMenu.addSeparator();
        JMenu drawingAreaOriginMenu = new JMenu("Set drawing area origin");
        this.bottomLeftDrawingAreaOriginMenuItem = new JMenuItem("Place bottom-left corner here");
        this.bottomLeftDrawingAreaOriginMenuItem.addActionListener(this);
        drawingAreaOriginMenu.add(this.bottomLeftDrawingAreaOriginMenuItem);
        this.topLeftDrawingAreaOriginMenuItem = new JMenuItem("Place top-left corner here");
        this.topLeftDrawingAreaOriginMenuItem.addActionListener(this);
        drawingAreaOriginMenu.add(this.topLeftDrawingAreaOriginMenuItem);
        this.bottomRightDrawingAreaOriginMenuItem = new JMenuItem("Place bottom-right corner here");
        this.bottomRightDrawingAreaOriginMenuItem.addActionListener(this);
        drawingAreaOriginMenu.add(this.bottomRightDrawingAreaOriginMenuItem);
        this.topRightDrawingAreaOriginMenuItem = new JMenuItem("Place top-right corner here");
        this.topRightDrawingAreaOriginMenuItem.addActionListener(this);
        drawingAreaOriginMenu.add(this.topRightDrawingAreaOriginMenuItem);
        popupMenu.add(drawingAreaOriginMenu);
        this.parkingPositionMenuItem = new JMenuItem("Set parking position at head position");
        this.parkingPositionMenuItem.addActionListener(this);
        popupMenu.add(this.parkingPositionMenuItem);
        this.tool0ParkingPositionMenuItem = new JMenuItem("Set tool 0 parking position at head position");
        this.tool0ParkingPositionMenuItem.addActionListener(this);
        popupMenu.add(this.tool0ParkingPositionMenuItem);
        return popupMenu;
    }

    @Override
    protected void paint(Graphics2D g, int W, int H) {
        double reachableAreaW = PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.REACHABLE_AREA_WIDTH);
        double reachableAreaH = PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.REACHABLE_AREA_HEIGHT);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(g.getFont().deriveFont(500.0f));
        if (!this.zoom.hasBeenInitialized()) {
            double xRatio = (double)W * 0.95 / (reachableAreaW * 100.0);
            double yRatio = (double)H * 0.95 / (reachableAreaH * 100.0);
            double zoomLevel = Math.min(xRatio, yRatio);
            double trX = ((double)W - reachableAreaW * 100.0) / 2.0;
            double trY = ((double)H - reachableAreaH * 100.0) / 2.0;
            this.zoom.setZoolLevelAndTranslation(zoomLevel, trX, trY);
            this.repaint();
            return;
        }
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, W, H);
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, (int)(reachableAreaW * 100.0), (int)(reachableAreaH * 100.0));
        g.setColor(Color.MAGENTA);
        g.drawRect(0, 0, (int)(reachableAreaW * 100.0), (int)(reachableAreaH * 100.0));
        g.drawString("Reachable area", 0, g.getFontMetrics().getAscent());
        g.setColor(Color.WHITE);
        g.fillRect((int)(DRAWING_AREA_X * 100.0), (int)(DRAWING_AREA_Y * 100.0), (int)(DRAWING_AREA_WIDTH * 100.0), (int)(DRAWING_AREA_HEIGHT * 100.0));
        g.setColor(Color.MAGENTA);
        g.drawRect((int)(DRAWING_AREA_X * 100.0), (int)(DRAWING_AREA_Y * 100.0), (int)(DRAWING_AREA_WIDTH * 100.0), (int)(DRAWING_AREA_HEIGHT * 100.0));
        g.drawString("Drawing area", (int)(DRAWING_AREA_X * 100.0), (int)(DRAWING_AREA_Y * 100.0 + (double)g.getFontMetrics().getAscent()));
        this.paintCompletedJobs(g);
        this.paintStreamingJob(g);
        this.paintPreviewingJob(g);
        this.paintParkedTools(g);
        this.paintToolHead(g);
    }

    private void paintCompletedJobs(Graphics2D g) {
        Vector<Job> completedJobs = StreamingManager.Instance.getCompletedJobs();
        for (Job job : completedJobs) {
            HashMap<Ink, Instruction[]> instructionsPerInk = job.getInstructionsPerInk();
            for (Map.Entry<Ink, Instruction[]> entry : instructionsPerInk.entrySet()) {
                Color inkColor = entry.getKey().getColor();
                Instruction previousInstruction = null;
                Instruction[] instructionArray = entry.getValue();
                int n = instructionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Instruction instruction = instructionArray[n2];
                    if (instruction.isDrawingMotion()) {
                        this.paintInstruction(g, job, previousInstruction, instruction, PEN_STROKE, inkColor);
                    }
                    previousInstruction = instruction;
                    ++n2;
                }
            }
        }
    }

    private void paintStreamingJob(Graphics2D g) {
        Job streamingJob = StreamingManager.Instance.getStreamingJob();
        if (streamingJob != null) {
            HashMap<Ink, Instruction[]> instructionsPerInk = streamingJob.getInstructionsPerInk();
            HashMap<Ink, Integer> nbExecutedInstructionsPerInk = streamingJob.getNbExecutedInstructionsPerInk();
            for (Map.Entry<Ink, Instruction[]> entry : instructionsPerInk.entrySet()) {
                Instruction instruction;
                Instruction[] instructions = entry.getValue();
                int nbExecutedInstructions = nbExecutedInstructionsPerInk.get(entry.getKey());
                Color inkColor = entry.getKey().getColor();
                Instruction previousInstruction = null;
                int idInstr = 0;
                while (idInstr < nbExecutedInstructions) {
                    instruction = instructions[idInstr];
                    if (instruction.isDrawingMotion()) {
                        this.paintInstruction(g, streamingJob, previousInstruction, instruction, PEN_STROKE, inkColor);
                    }
                    previousInstruction = instruction;
                    ++idInstr;
                }
                idInstr = nbExecutedInstructions + 1;
                while (idInstr < instructions.length) {
                    instruction = instructions[idInstr];
                    if (instruction.isDrawingMotion()) {
                        this.paintInstruction(g, streamingJob, previousInstruction, instruction, PEN_STROKE, Utils.getLighterColor(inkColor));
                    } else {
                        this.paintInstruction(g, streamingJob, previousInstruction, instruction, FLYING_STROKE, FLYING_MOTIONS_COLOR);
                    }
                    previousInstruction = instruction;
                    ++idInstr;
                }
            }
        }
    }

    private void paintPreviewingJob(Graphics2D g) {
        if (this.previewingJob != null) {
            HashMap<Ink, Instruction[]> instructionsPerInk = this.previewingJob.getInstructionsPerInk();
            for (Map.Entry<Ink, Instruction[]> entry : instructionsPerInk.entrySet()) {
                Color inkColor = entry.getKey().getColor();
                Instruction previousInstruction = null;
                Instruction[] instructionArray = entry.getValue();
                int n = instructionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Instruction instruction = instructionArray[n2];
                    if (instruction.isDrawingMotion()) {
                        this.paintInstruction(g, this.previewingJob, previousInstruction, instruction, PEN_STROKE, inkColor);
                    } else {
                        this.paintInstruction(g, this.previewingJob, previousInstruction, instruction, FLYING_STROKE, FLYING_MOTIONS_COLOR);
                    }
                    previousInstruction = instruction;
                    ++n2;
                }
            }
            g.setColor(Color.MAGENTA);
            double[] translatedOrigin = this.previewingJob.getTranslatedOrigin();
            double reachableAreaH = PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.REACHABLE_AREA_HEIGHT);
            double jobWidth = this.previewingJob.getWidth();
            double jobHeight = this.previewingJob.getHeight();
            g.drawRect((int)(translatedOrigin[0] * 100.0), (int)((reachableAreaH - (translatedOrigin[1] + jobHeight)) * 100.0), (int)(jobWidth * 100.0), (int)(jobHeight * 100.0));
            g.fillRect((int)(translatedOrigin[0] * 100.0) - 200, (int)((reachableAreaH - (translatedOrigin[1] + jobHeight)) * 100.0) - 200, 400, 400);
        }
    }

    private void paintInstruction(Graphics2D g, Job job, Instruction previousInstruction, Instruction instruction, Stroke stroke, Color color) {
        double reachableAreaH = PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.REACHABLE_AREA_HEIGHT);
        double[] jobOffset = job.getTranslation();
        if (!instruction.isZAxisOnlyMotion() && instruction.isLinearMotion()) {
            double[] startPosition = instruction.getStartPosition();
            double[] endPosition = instruction.getEndPosition();
            g.setStroke(stroke);
            g.setColor(color);
            g.drawLine((int)Math.round((startPosition[0] + jobOffset[0]) * 100.0), (int)Math.round((reachableAreaH - (startPosition[1] + jobOffset[1])) * 100.0), (int)Math.round((endPosition[0] + jobOffset[0]) * 100.0), (int)Math.round((reachableAreaH - (endPosition[1] + jobOffset[1])) * 100.0));
        }
    }

    private void paintToolHead(Graphics2D g) {
        if (this.workPosition != null) {
            double toolRadius = 5.0;
            if (this.loadedTool.isAnActualTool()) {
                this.drawToolAt(g, this.loadedTool, this.workPosition[0], this.workPosition[1], this.workPosition[2]);
            } else {
                double reachableAreaH = PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.REACHABLE_AREA_HEIGHT);
                g.setColor(Color.black);
                g.drawOval((int)Math.round((this.workPosition[0] - toolRadius) * 100.0), (int)Math.round((reachableAreaH - this.workPosition[1] - toolRadius) * 100.0), (int)(toolRadius * 2.0 * 100.0), (int)(toolRadius * 2.0 * 100.0));
            }
        }
    }

    private void paintParkedTools(Graphics2D g) {
        Tool[] tools;
        Tool[] toolArray = tools = PlotterConfiguration.Instance.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            Tool tool = toolArray[n2];
            if (!tool.equals(this.loadedTool)) {
                this.drawToolAt(g, tool, tool.getParkingX(), tool.getParkingY(), Double.MAX_VALUE);
            }
            ++n2;
        }
    }

    private void drawToolAt(Graphics2D g, Tool tool, double x, double y, double z) {
        double reachableAreaH = PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.REACHABLE_AREA_HEIGHT);
        Stroke defaultStroke = g.getStroke();
        g.setColor(tool.getInk().getColor());
        g.setStroke(Utils.getPenStrokeInMm(12.0));
        g.drawOval((int)((x - 4.5) * 100.0), (int)((reachableAreaH - y - 4.5) * 100.0), 900, 900);
        g.setStroke(defaultStroke);
        double tipWidth = 3.0 * Math.max(0.0, (4.0 - z) / 4.0);
        g.fillOval((int)((x - tipWidth / 2.0) * 100.0), (int)((reachableAreaH - y - tipWidth / 2.0) * 100.0), (int)(tipWidth * 100.0), (int)(tipWidth * 100.0));
    }

    public void setPreviewingJob(Job previewingJob) {
        if (previewingJob == null || previewingJob.isCompatibleWithPlotter()) {
            if (previewingJob != null) {
                double reachableAreaH = PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.REACHABLE_AREA_HEIGHT);
                double[] minPosition = previewingJob.getMinPosition();
                previewingJob.setTranslation(new double[]{DRAWING_AREA_X - minPosition[0] + (DRAWING_AREA_WIDTH - previewingJob.getWidth()) / 2.0, reachableAreaH - DRAWING_AREA_Y - minPosition[1] - (DRAWING_AREA_HEIGHT + previewingJob.getHeight()) / 2.0});
            }
            this.previewingJob = previewingJob;
            this.repaint();
        } else {
            System.out.println("Job incompatible with plotter");
        }
    }

    public Job getPreviewingJob() {
        return this.previewingJob;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.previewingJob != null) {
                double reachableAreaH = PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.REACHABLE_AREA_HEIGHT);
                double[] translatedOrigin = this.previewingJob.getTranslatedOrigin();
                double jobTopLeftCornerX = translatedOrigin[0];
                double jobTopLeftCornerY = reachableAreaH - (translatedOrigin[1] + this.previewingJob.getHeight());
                double mouseXInMm = this.getZoomedMouseX(e) / 100.0;
                double mouseYInMm = this.getZoomedMouseY(e) / 100.0;
                if (Math.abs(jobTopLeftCornerX - mouseXInMm) < 2.0 && Math.abs(jobTopLeftCornerY - mouseYInMm) < 2.0) {
                    this.translatingPreviewingJob = true;
                }
            }
        } else {
            SwingUtilities.isRightMouseButton(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.translatingPreviewingJob = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        if (this.translatingPreviewingJob) {
            double reachableAreaH = PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.REACHABLE_AREA_HEIGHT);
            double[] tr = this.previewingJob.getTranslation();
            double[] minPosition = this.previewingJob.getMinPosition();
            double trX = tr[0] + ((double)e.getX() - this.previousMouseX) / this.zoom.getZoomLevel() / 100.0;
            double trY = tr[1] - ((double)e.getY() - this.previousMouseY) / this.zoom.getZoomLevel() / 100.0;
            trX = Math.max(DRAWING_AREA_X - minPosition[0], Math.min(DRAWING_AREA_X - minPosition[0] + DRAWING_AREA_WIDTH - this.previewingJob.getWidth(), trX));
            trY = Math.max(reachableAreaH - DRAWING_AREA_HEIGHT - DRAWING_AREA_Y - minPosition[1], Math.min(reachableAreaH - DRAWING_AREA_Y - minPosition[1] - this.previewingJob.getHeight(), trY));
            this.previewingJob.setTranslation(new double[]{trX, trY});
            this.previousMouseX = e.getX();
            this.previousMouseY = e.getY();
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (s.equals(this.moveHereMenuItem)) {
            System.out.println("TODO-019: move here");
        }
        if (s.equals(this.clearDrawingAreaMenuItem)) {
            System.out.println("TODO-019: clear drawing area");
        }
        if (s.equals(this.bottomLeftDrawingAreaOriginMenuItem)) {
            System.out.println("TODO-019: drawing origin");
        }
        if (s.equals(this.topLeftDrawingAreaOriginMenuItem)) {
            System.out.println("TODO-019: drawing origin");
        }
        if (s.equals(this.bottomRightDrawingAreaOriginMenuItem)) {
            System.out.println("TODO-019: drawing origin");
        }
        if (s.equals(this.topRightDrawingAreaOriginMenuItem)) {
            System.out.println("TODO-019: drawing origin");
        }
        if (s.equals(this.parkingPositionMenuItem)) {
            System.out.println("TODO-019: parking position");
        }
        if (s.equals(this.tool0ParkingPositionMenuItem)) {
            System.out.println("TODO-019: tool0 parking position");
        }
    }

    @Override
    public void plotterStatusChanged(PlotterStatus status) {
    }

    @Override
    public void loadedToolChanged(Tool newlyLoadedTool) {
        this.loadedTool = newlyLoadedTool;
    }

    @Override
    public void plotterDataChanged(double[] workPosition, double[] machinePosition, double currentFeedrate, boolean[] endstopsTriggered) {
        this.workPosition = workPosition;
        this.repaint();
    }

    @Override
    public void startedNewJob(Job job) {
    }

    @Override
    public void streamingProgressionChanged(double elapsedDurationSinceJobStart, HashMap<Ink, Integer> nbInstructionsExecutedPerInk, HashMap<Ink, Double> drawedDistancesPerInk, HashMap<Ink, Integer> estimatedRemainingDurationPerInk) {
        this.nbInstructionsExecutedPerInkForStreamingJob = nbInstructionsExecutedPerInk;
        this.repaint();
    }

    @Override
    public void jobCompleted() {
    }
}

