/*
 * Decompiled with CFR 0.152.
 */
package streaming.gui;

import common.engine.Ink;
import common.engine.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import streaming.engine.Job;
import streaming.engine.Tool;
import streaming.enums.PlotterSetting;
import streaming.enums.PlotterStatus;
import streaming.listeners.PlotterDataListener;
import streaming.listeners.StreamingProgressionListener;
import streaming.session.PlotterConfiguration;
import streaming.session.StreamingManager;

public class ManualControlPanel
extends JPanel
implements ActionListener,
StreamingProgressionListener,
PlotterDataListener {
    private JButton upButton;
    private JButton downButton;
    private JButton rightButton;
    private JButton leftButton;
    private JButton upZButton;
    private JButton downZButton;
    private JButton upLeftButton;
    private JButton upRightButton;
    private JButton downLeftButton;
    private JButton downRightButton;
    JSpinner xyDistanceSpinner;
    JSpinner zDistanceSpinner;
    private JButton macroHomeButton;
    private JButton macroUnlockButton;
    private JButton macroResetButton;
    private JButton macroParkButton;
    private JButton macroSetZeroButton;
    private JToggleButton noPenButton;
    private HashMap<JToggleButton, Ink> penSelectionButtons = new HashMap();
    private JLabel penSelectionWarningLabel;

    public ManualControlPanel() {
        StreamingManager.Instance.addStreamingProgressionListener(this);
        StreamingManager.Instance.addPlotterDataListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Manual control"));
        JPanel basicMotions = new JPanel(new GridLayout(3, 4));
        basicMotions.setBorder(BorderFactory.createTitledBorder("Basic motions"));
        this.xyDistanceSpinner = new JSpinner(new SpinnerNumberModel(10.0, 1.0, 500.0, 1.0));
        this.zDistanceSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.1, 500.0, 0.1));
        this.upButton = new JButton(new ImageIcon("data/icons/up.png"));
        this.upButton.addActionListener(this);
        this.downButton = new JButton(new ImageIcon("data/icons/down.png"));
        this.downButton.addActionListener(this);
        this.rightButton = new JButton(new ImageIcon("data/icons/right.png"));
        this.rightButton.addActionListener(this);
        this.leftButton = new JButton(new ImageIcon("data/icons/left.png"));
        this.leftButton.addActionListener(this);
        this.upZButton = new JButton(new ImageIcon("data/icons/up.png"));
        this.upZButton.addActionListener(this);
        this.downZButton = new JButton(new ImageIcon("data/icons/down.png"));
        this.downZButton.addActionListener(this);
        this.upLeftButton = new JButton("");
        this.upLeftButton.addActionListener(this);
        this.upRightButton = new JButton("");
        this.upRightButton.addActionListener(this);
        this.downLeftButton = new JButton("");
        this.downLeftButton.addActionListener(this);
        this.downRightButton = new JButton("");
        this.downRightButton.addActionListener(this);
        basicMotions.add(this.upLeftButton);
        basicMotions.add(this.upButton);
        basicMotions.add(this.upRightButton);
        basicMotions.add(this.upZButton);
        basicMotions.add(this.leftButton);
        basicMotions.add(this.xyDistanceSpinner);
        basicMotions.add(this.rightButton);
        basicMotions.add(this.zDistanceSpinner);
        basicMotions.add(this.downLeftButton);
        basicMotions.add(this.downButton);
        basicMotions.add(this.downRightButton);
        basicMotions.add(this.downZButton);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        topPanel.add(basicMotions);
        JPanel macros = new JPanel(new GridLayout(2, 2));
        macros.setBorder(BorderFactory.createTitledBorder("Macros"));
        this.macroHomeButton = new JButton("Home");
        this.macroHomeButton.setIcon(new ImageIcon("data/icons/home.png"));
        this.macroHomeButton.addActionListener(this);
        this.macroHomeButton.setEnabled(false);
        macros.add(this.macroHomeButton);
        this.macroUnlockButton = new JButton("Unlock");
        this.macroUnlockButton.setIcon(new ImageIcon("data/icons/unlock.png"));
        this.macroUnlockButton.addActionListener(this);
        this.macroUnlockButton.setEnabled(false);
        macros.add(this.macroUnlockButton);
        this.macroResetButton = new JButton("Reset");
        this.macroResetButton.setIcon(new ImageIcon("data/icons/reset.png"));
        this.macroResetButton.addActionListener(this);
        this.macroResetButton.setEnabled(false);
        macros.add(this.macroResetButton);
        this.macroParkButton = new JButton("Park");
        this.macroParkButton.setIcon(new ImageIcon("data/icons/park.png"));
        this.macroParkButton.addActionListener(this);
        macros.add(this.macroParkButton);
        this.macroSetZeroButton = new JButton("Set Zero");
        this.macroSetZeroButton.setIcon(new ImageIcon("data/icons/zero.png"));
        this.macroSetZeroButton.addActionListener(this);
        macros.add(this.macroSetZeroButton);
        topPanel.add(macros);
        this.add((Component)topPanel, "North");
        JPanel penSelectionPanel = new JPanel(new BorderLayout());
        penSelectionPanel.setBorder(BorderFactory.createTitledBorder("Pen selection"));
        JPanel penSelectionButtonsPanel = new JPanel(new GridLayout(2, 4));
        ButtonGroup penButtonGroup = new ButtonGroup();
        this.noPenButton = new JToggleButton(new ImageIcon("data/icons/none.png"));
        this.penSelectionButtons.put(this.noPenButton, null);
        this.noPenButton.addActionListener(this);
        penButtonGroup.add(this.noPenButton);
        penSelectionButtonsPanel.add(this.noPenButton);
        for (Ink ink : Ink.getAvailableInks()) {
            JToggleButton penButton = new JToggleButton(Utils.getColorIcon(ink.getColor()));
            this.penSelectionButtons.put(penButton, ink);
            penButton.addActionListener(this);
            penButtonGroup.add(penButton);
            penSelectionButtonsPanel.add(penButton);
        }
        penSelectionPanel.add((Component)penSelectionButtonsPanel, "Center");
        this.penSelectionWarningLabel = new JLabel("Please select the currently mounted tool");
        this.penSelectionWarningLabel.setForeground(Color.RED);
        this.penSelectionWarningLabel.setFont(this.getFont().deriveFont(1));
        penSelectionPanel.add((Component)this.penSelectionWarningLabel, "South");
        this.add((Component)penSelectionPanel, "South");
        this.plotterStatusChanged(PlotterStatus.DISCONNECTED);
    }

    private void setManualControlsEnabled(boolean enableManualControls) {
        this.upButton.setEnabled(enableManualControls);
        this.downButton.setEnabled(enableManualControls);
        this.rightButton.setEnabled(enableManualControls);
        this.leftButton.setEnabled(enableManualControls);
        this.upZButton.setEnabled(enableManualControls);
        this.downZButton.setEnabled(enableManualControls);
        this.upLeftButton.setEnabled(enableManualControls);
        this.upRightButton.setEnabled(enableManualControls);
        this.downLeftButton.setEnabled(enableManualControls);
        this.downRightButton.setEnabled(enableManualControls);
        this.macroHomeButton.setEnabled(enableManualControls);
        this.macroParkButton.setEnabled(enableManualControls);
        this.macroUnlockButton.setEnabled(enableManualControls);
        this.macroSetZeroButton.setEnabled(enableManualControls);
        this.macroResetButton.setEnabled(enableManualControls);
        this.noPenButton.setEnabled(enableManualControls);
        for (JToggleButton penButton : this.penSelectionButtons.keySet()) {
            penButton.setEnabled(enableManualControls);
        }
    }

    @Override
    public void startedNewJob(Job job) {
        this.setManualControlsEnabled(false);
    }

    @Override
    public void streamingProgressionChanged(double elapsedDurationSinceJobStart, HashMap<Ink, Integer> nbInstructionsExecutedPerInk, HashMap<Ink, Double> drawedDistancesPerInk, HashMap<Ink, Integer> estimatedRemainingDurationPerInk) {
    }

    @Override
    public void jobCompleted() {
        this.setManualControlsEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        double xyDist = (Double)this.xyDistanceSpinner.getValue();
        double zDist = (Double)this.zDistanceSpinner.getValue();
        if (s.equals(this.upButton) || s.equals(this.upLeftButton) || s.equals(this.upRightButton)) {
            dy = xyDist;
        } else if (s.equals(this.downButton) || s.equals(this.downLeftButton) || s.equals(this.downRightButton)) {
            dy = -xyDist;
        }
        if (s.equals(this.rightButton) || s.equals(this.upRightButton) || s.equals(this.downRightButton)) {
            dx = xyDist;
        } else if (s.equals(this.leftButton) || s.equals(this.upLeftButton) || s.equals(this.downLeftButton)) {
            dx = -xyDist;
        }
        if (s.equals(this.upZButton)) {
            dz = zDist;
        } else if (s.equals(this.downZButton)) {
            dz = -zDist;
        }
        if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
            StreamingManager.Instance.jog(dx, dy, dz, Utils.speedToFeedrate(PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.JOG_SPEED), PlotterConfiguration.Instance.getBooleanSettingValue(PlotterSetting.IS_CORE_XY)));
        }
        if (s.equals(this.macroHomeButton)) {
            StreamingManager.Instance.home();
        } else if (s.equals(this.macroUnlockButton)) {
            StreamingManager.Instance.unlock();
        } else if (s.equals(this.macroResetButton)) {
            StreamingManager.Instance.reset();
        } else if (s.equals(this.macroParkButton)) {
            StreamingManager.Instance.park();
        } else if (s.equals(this.macroSetZeroButton)) {
            System.out.println("TODO-013: set zero g-code");
        }
        if (s.equals(this.noPenButton)) {
            if (StreamingManager.Instance.getLoadedTool() == Tool.UNDEFINED) {
                StreamingManager.Instance.setInitiallyLoadedTool(Tool.NONE);
            } else {
                StreamingManager.Instance.startChangeToolJob(Tool.NONE);
            }
        } else {
            for (Map.Entry<JToggleButton, Ink> entry : this.penSelectionButtons.entrySet()) {
                if (!s.equals(entry.getKey())) continue;
                Tool tool = PlotterConfiguration.Instance.getToolByInk(entry.getValue());
                if (StreamingManager.Instance.getLoadedTool() == Tool.UNDEFINED) {
                    StreamingManager.Instance.setInitiallyLoadedTool(tool);
                    break;
                }
                StreamingManager.Instance.startChangeToolJob(tool);
                break;
            }
        }
    }

    @Override
    public void plotterStatusChanged(PlotterStatus status) {
        boolean manualMotionsEnabled = status == PlotterStatus.IDLE || status == PlotterStatus.JOG;
        this.upButton.setEnabled(manualMotionsEnabled);
        this.downButton.setEnabled(manualMotionsEnabled);
        this.rightButton.setEnabled(manualMotionsEnabled);
        this.leftButton.setEnabled(manualMotionsEnabled);
        this.upZButton.setEnabled(manualMotionsEnabled);
        this.downZButton.setEnabled(manualMotionsEnabled);
        this.upLeftButton.setEnabled(manualMotionsEnabled);
        this.upRightButton.setEnabled(manualMotionsEnabled);
        this.downLeftButton.setEnabled(manualMotionsEnabled);
        this.downRightButton.setEnabled(manualMotionsEnabled);
        boolean macrosEnabled = status == PlotterStatus.IDLE;
        this.macroParkButton.setEnabled(macrosEnabled);
        this.macroSetZeroButton.setEnabled(macrosEnabled);
        boolean homeUnlockResetMacrosEnabled = status != PlotterStatus.DISCONNECTED;
        this.macroHomeButton.setEnabled(homeUnlockResetMacrosEnabled);
        this.macroUnlockButton.setEnabled(homeUnlockResetMacrosEnabled);
        this.macroResetButton.setEnabled(homeUnlockResetMacrosEnabled);
    }

    @Override
    public void loadedToolChanged(Tool newlyLoadedTool) {
        if (newlyLoadedTool != Tool.UNDEFINED) {
            this.penSelectionWarningLabel.setVisible(false);
            this.macroHomeButton.setEnabled(true);
            this.macroUnlockButton.setEnabled(true);
            this.macroResetButton.setEnabled(true);
        }
    }

    @Override
    public void plotterDataChanged(double[] workPosition, double[] machinePosition, double currentFeedrate, boolean[] endstopsTriggered) {
    }
}

