/*
 * Decompiled with CFR 0.152.
 */
package streaming.gui;

import common.engine.Ink;
import common.engine.Utils;
import common.gui.Window;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import streaming.engine.Job;
import streaming.engine.Tool;
import streaming.enums.PlotterStatus;
import streaming.listeners.PlotterDataListener;
import streaming.listeners.StreamingProgressionListener;
import streaming.session.PlotterConfiguration;
import streaming.session.StreamingManager;

public class ControlBar
extends JPanel
implements ActionListener,
PlotterDataListener,
StreamingProgressionListener {
    private static final String VIRTUAL_PLOTTER_SERIAL_PORT = "Virtual Plotter";
    private final JComboBox<String> serialPortCombo;
    private final JLabel filenameLabel;
    private final JButton connectButton;
    private final JButton disconnectButton;
    private final JButton browseButton;
    private final JButton runButton;
    private final JButton cleanPauseButton;
    private final JButton stopButton;
    private final JButton emergencyPauseButton;
    private final JFileChooser fileChooser;

    public ControlBar() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Plotter"));
        StreamingManager.Instance.addPlotterDataListener(this);
        StreamingManager.Instance.addStreamingProgressionListener(this);
        JPanel serialSettingsPanel = new JPanel();
        serialSettingsPanel.setLayout(new BoxLayout(serialSettingsPanel, 0));
        serialSettingsPanel.setBorder(BorderFactory.createTitledBorder("Serial settings"));
        this.serialPortCombo = new JComboBox<String>(new String[]{VIRTUAL_PLOTTER_SERIAL_PORT});
        this.serialPortCombo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ControlBar.this.serialPortCombo.removeAllItems();
                String[] stringArray = StreamingManager.Instance.getAvailableStreamingPorts();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String port = stringArray[n2];
                    ControlBar.this.serialPortCombo.addItem(port);
                    ++n2;
                }
                ControlBar.this.serialPortCombo.addItem(ControlBar.VIRTUAL_PLOTTER_SERIAL_PORT);
                ControlBar.this.serialPortCombo.repaint();
            }
        });
        this.connectButton = new JButton("Connect");
        this.connectButton.setIcon(new ImageIcon("data/icons/connect.png"));
        this.connectButton.addActionListener(this);
        this.disconnectButton = new JButton("Disconnect");
        this.disconnectButton.setIcon(new ImageIcon("data/icons/disconnect.png"));
        this.disconnectButton.setEnabled(false);
        this.disconnectButton.addActionListener(this);
        serialSettingsPanel.add(new JLabel("Port:"));
        serialSettingsPanel.add(this.serialPortCombo);
        serialSettingsPanel.add(this.connectButton);
        serialSettingsPanel.add(this.disconnectButton);
        this.add((Component)serialSettingsPanel, "West");
        JPanel fileSelectionPanel = new JPanel();
        fileSelectionPanel.setLayout(new BoxLayout(fileSelectionPanel, 0));
        fileSelectionPanel.setBorder(BorderFactory.createTitledBorder("File selection"));
        this.filenameLabel = new JLabel("no file selected");
        this.browseButton = new JButton("Browse");
        this.browseButton.setIcon(new ImageIcon("data/icons/browse.png"));
        this.fileChooser = new JFileChooser(".");
        this.browseButton.addActionListener(this);
        this.runButton = new JButton("Run");
        this.runButton.setIcon(new ImageIcon("data/icons/run.png"));
        this.runButton.setEnabled(false);
        this.runButton.addActionListener(this);
        this.cleanPauseButton = new JButton("Pause");
        this.cleanPauseButton.setIcon(new ImageIcon("data/icons/pause.png"));
        this.cleanPauseButton.setEnabled(false);
        this.cleanPauseButton.addActionListener(this);
        this.emergencyPauseButton = new JButton("Emergency pause");
        this.emergencyPauseButton.setIcon(new ImageIcon("data/icons/emergency-pause.png"));
        this.emergencyPauseButton.addActionListener(this);
        this.stopButton = new JButton("Stop");
        this.stopButton.setIcon(new ImageIcon("data/icons/stop.png"));
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(this);
        fileSelectionPanel.add(this.filenameLabel);
        fileSelectionPanel.add(this.browseButton);
        fileSelectionPanel.add(this.runButton);
        fileSelectionPanel.add(this.emergencyPauseButton);
        fileSelectionPanel.add(this.stopButton);
        this.add((Component)fileSelectionPanel, "East");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (s.equals(this.connectButton)) {
            String serialPort = (String)this.serialPortCombo.getSelectedItem();
            if (serialPort.equals(VIRTUAL_PLOTTER_SERIAL_PORT)) {
                StreamingManager.Instance.connectToVirtualPlotter();
            } else {
                StreamingManager.Instance.connectTo(serialPort);
            }
        }
        if (s.equals(this.disconnectButton)) {
            StreamingManager.Instance.disconnect();
        }
        if (s.equals(this.browseButton) && this.fileChooser.showOpenDialog(null) == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            this.filenameLabel.setText(selectedFile.getPath());
            Tool tool = StreamingManager.Instance.getLoadedTool();
            if (!tool.isAnActualTool()) {
                tool = PlotterConfiguration.Instance.getToolByInk(Ink.getBlackestAvailableInk());
            }
            try {
                String gcode = Utils.readFile(selectedFile);
                Window.Instance.getPlotterView().setPreviewingJob(new Job(gcode, tool, false));
                this.updateRunButtonEnabledStatus();
            }
            catch (IOException e1) {
                System.err.println("Failed to open file");
                e1.printStackTrace();
            }
        }
        if (s.equals(this.runButton)) {
            if (StreamingManager.Instance.getStreamingJob() != null) {
                System.out.println("resume job");
                StreamingManager.Instance.resumeJob();
            } else {
                Job previewingJob = Window.Instance.getPlotterView().getPreviewingJob();
                if (previewingJob != null) {
                    Window.Instance.getPlotterView().setPreviewingJob(null);
                    StreamingManager.Instance.startJob(previewingJob);
                }
            }
        }
        if (s.equals(this.cleanPauseButton)) {
            StreamingManager.Instance.pauseJob();
        }
        if (s.equals(this.emergencyPauseButton)) {
            StreamingManager.Instance.emergencyPause();
        }
        if (s.equals(this.stopButton)) {
            StreamingManager.Instance.stopJob();
        }
    }

    private void updateRunButtonEnabledStatus() {
        boolean isPlotterConnected = StreamingManager.Instance.getPlotterStatus() != PlotterStatus.DISCONNECTED;
        boolean isCurrentToolKnown = StreamingManager.Instance.getLoadedTool() != Tool.UNDEFINED;
        Job streamingJob = StreamingManager.Instance.getStreamingJob();
        boolean isJobAlreadyStreaming = streamingJob != null && !streamingJob.isDone();
        Job previewingJob = Window.Instance.getPlotterView().getPreviewingJob();
        boolean isPreviewingJobSet = previewingJob != null;
        boolean isPaused = StreamingManager.Instance.getPlotterStatus() == PlotterStatus.HOLD;
        boolean canStartNewJob = !isJobAlreadyStreaming && isPreviewingJobSet;
        this.runButton.setEnabled(isPlotterConnected && isCurrentToolKnown && (canStartNewJob || isPaused));
    }

    @Override
    public void plotterStatusChanged(PlotterStatus status) {
        this.connectButton.setEnabled(status == PlotterStatus.DISCONNECTED);
        this.disconnectButton.setEnabled(status != PlotterStatus.DISCONNECTED);
        this.cleanPauseButton.setEnabled(status == PlotterStatus.RUN);
        this.emergencyPauseButton.setEnabled(status == PlotterStatus.RUN);
        this.stopButton.setEnabled(status == PlotterStatus.RUN || status == PlotterStatus.HOLD);
        this.updateRunButtonEnabledStatus();
    }

    @Override
    public void loadedToolChanged(Tool newlyLoadedTool) {
        this.updateRunButtonEnabledStatus();
    }

    @Override
    public void plotterDataChanged(double[] workPosition, double[] machinePosition, double currentFeedrate, boolean[] endstopsTriggered) {
    }

    @Override
    public void startedNewJob(Job job) {
        this.updateRunButtonEnabledStatus();
    }

    @Override
    public void streamingProgressionChanged(double elapsedDurationSinceJobStart, HashMap<Ink, Integer> nbInstructionsExecutedPerInk, HashMap<Ink, Double> drawedDistancesPerInk, HashMap<Ink, Integer> estimatedRemainingDurationsPerInk) {
    }

    @Override
    public void jobCompleted() {
        this.updateRunButtonEnabledStatus();
    }
}

