/*
 * Decompiled with CFR 0.152.
 */
package streaming.gui;

import common.engine.Ink;
import common.engine.Utils;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JPanel;

public class ColoredProgressBar
extends JPanel {
    private Set<Ink> orderedColors;
    private HashMap<Ink, Double> progressionValuesPerColor = new HashMap();
    private HashMap<Ink, Double> progressionMaxPerColor = new HashMap();
    private double progressionMaxForAllColors = 0.0;

    public void setColorOrder(Set<Ink> orderedColors) {
        this.orderedColors = orderedColors;
    }

    public void setProgress(HashMap<Ink, Double> progressionValuesPerColor, HashMap<Ink, Double> progressionMaxPerColor) {
        this.progressionValuesPerColor = progressionValuesPerColor;
        this.progressionMaxPerColor = progressionMaxPerColor;
        this.progressionMaxForAllColors = 0.0;
        for (Double max : progressionMaxPerColor.values()) {
            this.progressionMaxForAllColors += max.doubleValue();
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        int W = this.getWidth();
        int H = this.getHeight();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, W, H);
        if (this.orderedColors != null) {
            double x = 0.0;
            for (Ink ink : this.orderedColors) {
                g.setColor(Utils.getLighterColor(ink.getColor()));
                double wMax = this.progressionMaxPerColor.get(ink) / this.progressionMaxForAllColors * (double)W;
                g.fillRect((int)Math.floor(x), 0, (int)Math.ceil(wMax), H);
                g.setColor(ink.getColor());
                double w = this.progressionValuesPerColor.get(ink) / this.progressionMaxForAllColors * (double)W;
                g.fillRect((int)Math.floor(x), 0, (int)Math.ceil(w), H);
                x += wMax;
            }
        }
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, W, H);
    }
}

