/*
 * Decompiled with CFR 0.152.
 */
package streaming.generators;

import common.engine.Ink;
import common.engine.Utils;
import java.util.Locale;
import streaming.engine.Tool;
import streaming.enums.PlotterSetting;
import streaming.session.PlotterConfiguration;

public abstract class GcodeGenerator {
    public static final String ACK_RESPONSE = "ok";
    public static final String STATUS_QUERY = "?";
    public static final String READ_CONFIGURATION_REQUEST = "$$";
    public static final String HOME_INSTRUCTION = "$H\n";
    public static final String RESET_INSTRUCTION = new String(new byte[]{24});
    public static final String UNLOCK_INSTRUCTION = "$X\n";
    public static final String FEED_HOLD_INSTRUCTION = "!";
    public static final String FEED_RESUME_INSTRUCTION = "~";
    public static final String PLOTTER_READY_TO_RECEIVE_INSTRUCTIONS_NOTIFICATION = "[MSG:'$H'|'$X' to unlock]";

    public static String fastLinearMovement(double x, double y, double z) {
        String gcode = String.format(Locale.US, "G0 F%.0f ", Utils.speedToFeedrate(PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.FLYING_XY_MAX_SPEED), PlotterConfiguration.Instance.getBooleanSettingValue(PlotterSetting.IS_CORE_XY)));
        if (!Double.isNaN(x)) {
            gcode = String.valueOf(gcode) + String.format(Locale.US, "X%.4f ", x);
        }
        if (!Double.isNaN(y)) {
            gcode = String.valueOf(gcode) + String.format(Locale.US, "Y%.4f ", y);
        }
        if (!Double.isNaN(z)) {
            gcode = String.valueOf(gcode) + String.format(Locale.US, "Z%.4f ", z);
        }
        return gcode.trim();
    }

    public static String loadedLinearMovement(double x, double y, double z) {
        String gcode = String.format(Locale.US, "G1 F%.0f ", Utils.speedToFeedrate(PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.DRAWING_XY_MAX_SPEED), PlotterConfiguration.Instance.getBooleanSettingValue(PlotterSetting.IS_CORE_XY)));
        if (!Double.isNaN(x)) {
            gcode = String.valueOf(gcode) + String.format(Locale.US, "X%.4f ", x);
        }
        if (!Double.isNaN(y)) {
            gcode = String.valueOf(gcode) + String.format(Locale.US, "Y%.4f ", y);
        }
        if (!Double.isNaN(z)) {
            gcode = String.valueOf(gcode) + String.format(Locale.US, "Z%.4f ", z);
        }
        return gcode.trim();
    }

    public static String relativeFastLinearMovement(double dx, double dy, double dz) {
        double feedrate = Utils.speedToFeedrate(PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.FLYING_XY_MAX_SPEED), PlotterConfiguration.Instance.getBooleanSettingValue(PlotterSetting.IS_CORE_XY));
        return String.format(Locale.US, "G91\nX%.4f Y%.4f Z%.4f F%.0f\nG90\n", dx, dy, dz, feedrate);
    }

    public static String jogMotion(double dx, double dy, double dz, double feedrate) {
        return String.format(Locale.US, "$J=G21 G91 X%.4f Y%.4f Z%.4f F%.0f\n", dx, dy, dz, feedrate);
    }

    public static String replaceToolChangeInstructions(String originalInstructions, Tool initialLoadedTool) {
        String parsedInstructions = "";
        Tool currentTool = initialLoadedTool;
        String[] stringArray = originalInstructions.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String instruction = stringArray[n2];
            if (instruction.startsWith("T")) {
                instruction = instruction.indexOf(32) != -1 ? instruction.substring(1, instruction.indexOf(32)) : instruction.substring(1);
                int color = Integer.parseInt(instruction);
                Ink ink = Ink.getAvailableInkByColor(color);
                Tool tool = PlotterConfiguration.Instance.getToolByInk(ink);
                if (color >= 0 && (ink == null || tool == Tool.UNDEFINED)) {
                    System.out.println(String.format(Locale.US, "Unavailable color: 0x%s (tool id %d)", Integer.toHexString(color), color));
                } else {
                    if (currentTool.isAnActualTool()) {
                        parsedInstructions = String.valueOf(parsedInstructions) + ";!nonTranslatable - tool unloading start\n";
                        parsedInstructions = String.valueOf(parsedInstructions) + currentTool.getUnloadingInstructions();
                        parsedInstructions = String.valueOf(parsedInstructions) + ";!translatable - tool unloading end\n";
                    }
                    if (tool.isAnActualTool()) {
                        parsedInstructions = String.valueOf(parsedInstructions) + ";!nonTranslatable - tool loading start\n";
                        parsedInstructions = String.valueOf(parsedInstructions) + tool.getLoadingInstructions();
                        parsedInstructions = String.valueOf(parsedInstructions) + ";!translatable - tool unloading end\n";
                    }
                    currentTool = tool;
                }
            } else {
                parsedInstructions = String.valueOf(parsedInstructions) + instruction + "\n";
            }
            ++n2;
        }
        System.out.println(parsedInstructions);
        return parsedInstructions;
    }

    public static PlotterSetting getPlotterSettingByGrblId(int grblSettingId) {
        switch (grblSettingId) {
            case 110: 
            case 111: {
                return PlotterSetting.FLYING_XY_MAX_SPEED;
            }
            case 112: {
                return PlotterSetting.Z_MAX_SPEED;
            }
            case 120: 
            case 121: {
                return PlotterSetting.XY_ACCELERATION;
            }
            case 122: {
                return PlotterSetting.Z_ACCELERATION;
            }
            case 130: {
                return PlotterSetting.REACHABLE_AREA_WIDTH;
            }
            case 131: {
                return PlotterSetting.REACHABLE_AREA_HEIGHT;
            }
        }
        return null;
    }
}

