/*
 * Decompiled with CFR 0.152.
 */
package streaming.engine;

import common.engine.Ink;
import common.engine.Jsonizable;
import java.util.Locale;
import org.json.JSONObject;

public class Tool
implements Jsonizable {
    public static final Tool UNDEFINED = new Tool(true, false);
    public static final Tool NONE = new Tool(false, true);
    private final Ink ink;
    private final double parkingX;
    private final double parkingY;
    private final String loadingInstructions;
    private final String unloadingInstructions;
    private final boolean isUndefinedTool;
    private final boolean isNoneTool;

    public Tool(Ink ink, double parkingX, double parkingY, String loadingInstructions, String unloadingInstructions) {
        this.ink = ink;
        this.parkingX = parkingX;
        this.parkingY = parkingY;
        this.loadingInstructions = loadingInstructions;
        this.unloadingInstructions = unloadingInstructions;
        this.isUndefinedTool = false;
        this.isNoneTool = false;
    }

    private Tool(boolean isUndefinedTool, boolean isNoneTool) {
        if (isUndefinedTool && isNoneTool) {
            System.err.println("A Tool should not represent a the same time an Undefined Tool and a No Tool");
        }
        this.isUndefinedTool = isUndefinedTool;
        this.isNoneTool = isNoneTool;
        this.ink = null;
        this.parkingX = 0.0;
        this.parkingY = 0.0;
        this.loadingInstructions = "";
        this.unloadingInstructions = "";
    }

    public Ink getInk() {
        return this.ink;
    }

    public double getParkingX() {
        return this.parkingX;
    }

    public double getParkingY() {
        return this.parkingY;
    }

    public String getLoadingInstructions() {
        return this.loadingInstructions;
    }

    public String getUnloadingInstructions() {
        return this.unloadingInstructions;
    }

    public boolean isAnActualTool() {
        return !this.isUndefinedTool && !this.isNoneTool;
    }

    public String toString() {
        if (this.isUndefinedTool) {
            return "[Tool: Undefined]";
        }
        if (this.isNoneTool) {
            return "[Tool: None]";
        }
        return String.format(Locale.US, "[Tool: ink:%s at (%.0f,%.0f)]", this.ink.getName(), this.parkingX, this.parkingY);
    }

    public boolean equals(Object o) {
        if (o instanceof Tool) {
            Tool other = (Tool)o;
            if (this.isUndefinedTool) {
                return other.isUndefinedTool;
            }
            if (this.isNoneTool) {
                return other.isNoneTool;
            }
            return other.ink == this.ink;
        }
        return false;
    }

    @Override
    public JSONObject toJSonObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ink", (Object)this.ink.getName());
        jsonObject.put("parking_x", this.parkingX);
        jsonObject.put("parking_y", this.parkingY);
        jsonObject.put("loading_instructions", (Object)this.loadingInstructions);
        jsonObject.put("unloading_instructions", (Object)this.unloadingInstructions);
        return jsonObject;
    }

    public static Jsonizable fromJsonObject(JSONObject jsonObject) {
        return new Tool(Ink.getAvailableInkByName(jsonObject.getString("ink")), jsonObject.getDouble("parking_x"), jsonObject.getDouble("parking_y"), jsonObject.getString("loading_instructions"), jsonObject.getString("unloading_instructions"));
    }
}

