/*
 * Decompiled with CFR 0.152.
 */
package streaming.engine;

import common.engine.Ink;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import streaming.engine.Instruction;
import streaming.engine.Tool;
import streaming.enums.InstructionType;

public class Job {
    private int currentInstructionId = 0;
    private final Instruction[] instructions;
    private final boolean canRunWithUnknownLoadedTool;
    private boolean isInAbsoluteCoordinates = true;
    private boolean isInInchesUnits = false;
    private double[] drawedLenghAtInstruction;
    private double[] estimatedDurationAtInstruction;
    private double[] realDurationAtInstruction;
    private long timestampAtJobStart;
    private double[] minPosition = new double[]{0.0, 0.0};
    private double[] maxPosition = new double[]{0.0, 0.0};
    private double[] translation = new double[]{0.0, 0.0};
    private LinkedHashMap<Ink, int[]> firstAndLastInstructionsIdsPerInk = new LinkedHashMap();

    public Job(String gcode, Tool initialTool, boolean canRunWithUnknownLoadedTool) {
        String[] rawInstructions = gcode.split("\n");
        int nbInstructions = rawInstructions.length;
        this.instructions = new Instruction[nbInstructions];
        this.canRunWithUnknownLoadedTool = canRunWithUnknownLoadedTool;
        this.drawedLenghAtInstruction = new double[nbInstructions + 1];
        this.drawedLenghAtInstruction[0] = 0.0;
        this.estimatedDurationAtInstruction = new double[nbInstructions + 1];
        this.estimatedDurationAtInstruction[0] = 0.0;
        this.realDurationAtInstruction = new double[nbInstructions + 1];
        this.realDurationAtInstruction[0] = 0.0;
        Tool currentTool = initialTool;
        if (initialTool.isAnActualTool()) {
            int[] nArray = new int[2];
            nArray[1] = nbInstructions;
            this.firstAndLastInstructionsIdsPerInk.put(initialTool.getInk(), nArray);
        }
        double[] position = new double[]{0.0, 0.0, 0.0};
        boolean startingPositionFound = false;
        double drawedDistance = 0.0;
        double estimatedDuration = 0.0;
        int idInstr = 0;
        while (idInstr < nbInstructions) {
            Instruction instruction = new Instruction(this, rawInstructions[idInstr], position);
            if (instruction.isMotion() && !instruction.isZAxisOnlyMotion() && !startingPositionFound) {
                this.minPosition = (double[])instruction.getEndPosition().clone();
                this.maxPosition = (double[])instruction.getEndPosition().clone();
                startingPositionFound = true;
                instruction = new Instruction(this, rawInstructions[idInstr], instruction.getEndPosition());
            }
            if ((position = instruction.getEndPosition())[0] < this.minPosition[0]) {
                this.minPosition[0] = position[0];
            } else if (position[0] > this.maxPosition[0]) {
                this.maxPosition[0] = position[0];
            }
            if (position[1] < this.minPosition[1]) {
                this.minPosition[1] = position[1];
            } else if (position[1] > this.maxPosition[1]) {
                this.maxPosition[1] = position[1];
            }
            this.instructions[idInstr] = instruction;
            this.drawedLenghAtInstruction[idInstr + 1] = drawedDistance += instruction.isDrawingMotion() ? instruction.getMotionLength() : 0.0;
            this.estimatedDurationAtInstruction[idInstr + 1] = estimatedDuration += instruction.getEstimatedDuration();
            InstructionType type = instruction.getType();
            if (type == InstructionType.TOOL_CHANGE) {
                if (currentTool.isAnActualTool()) {
                    this.firstAndLastInstructionsIdsPerInk.get((Object)currentTool.getInk())[1] = idInstr - 1;
                }
                if ((currentTool = instruction.getToolToLoad()).isAnActualTool()) {
                    Ink ink = instruction.getToolToLoad().getInk();
                    this.firstAndLastInstructionsIdsPerInk.put(ink, new int[]{idInstr, nbInstructions});
                }
            }
            ++idInstr;
        }
    }

    public boolean isCompatibleWithPlotter() {
        boolean alreadyReachedMotionInstructions = false;
        boolean coordinatesSystemAlreadySet = false;
        boolean unitsSystemAlreadySet = false;
        Instruction[] instructionArray = this.instructions;
        int n = this.instructions.length;
        int n2 = 0;
        while (n2 < n) {
            Instruction instr = instructionArray[n2];
            switch (instr.getType()) {
                case FAST_LINEAR_MOVEMENT: 
                case LOADED_LINEAR_MOVEMENT: {
                    alreadyReachedMotionInstructions = true;
                    break;
                }
                case USE_INCHES_UNITS: {
                    this.isInInchesUnits = true;
                    System.out.println("Incompatible job: use inches");
                    return false;
                }
                case USE_MM_UNITS: {
                    if (unitsSystemAlreadySet && this.isInInchesUnits) {
                        System.out.println("Incompatible job: contains multiple units system changes");
                        return false;
                    }
                    unitsSystemAlreadySet = true;
                    break;
                }
                case USE_RELATIVE_COORDINATES: {
                    this.isInAbsoluteCoordinates = false;
                    System.out.println("Incompatible job: use relatives coordinates");
                    return false;
                }
                case USE_ABSOLUTE_COORDINATES: {
                    if (coordinatesSystemAlreadySet && !this.isInAbsoluteCoordinates) {
                        System.out.println("Incompatible job: contains multiple coordinates system changes");
                        return false;
                    }
                    coordinatesSystemAlreadySet = true;
                    break;
                }
                case UNKNOWN: {
                    System.out.println("Incompatible job: contains unknown instruction type: " + instr.getRawInstruction());
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public boolean isDone() {
        return this.currentInstructionId >= this.instructions.length;
    }

    public HashMap<Ink, Instruction[]> getInstructionsPerInk() {
        HashMap<Ink, Instruction[]> instructionsPerInk = new HashMap<Ink, Instruction[]>();
        for (Map.Entry<Ink, int[]> entry : this.firstAndLastInstructionsIdsPerInk.entrySet()) {
            instructionsPerInk.put(entry.getKey(), Arrays.copyOfRange(this.instructions, entry.getValue()[0], entry.getValue()[1]));
        }
        return instructionsPerInk;
    }

    public Instruction getCurrentInstruction() {
        if (this.currentInstructionId == 0) {
            this.timestampAtJobStart = System.currentTimeMillis();
        }
        return this.instructions[this.currentInstructionId];
    }

    public void nextInstruction() {
        ++this.currentInstructionId;
    }

    public void cancelJob() {
        this.currentInstructionId = this.instructions.length;
    }

    public boolean canRunWithUnknownLoadedTool() {
        return this.canRunWithUnknownLoadedTool;
    }

    public double[] getMinPosition() {
        return this.minPosition;
    }

    public double[] getMaxPosition() {
        return this.maxPosition;
    }

    public double getWidth() {
        return this.maxPosition[0] - this.minPosition[0];
    }

    public double getHeight() {
        return this.maxPosition[1] - this.minPosition[1];
    }

    public void setTranslation(double[] translation) {
        this.translation = translation;
    }

    public double[] getTranslation() {
        return this.translation;
    }

    public double[] getTranslatedOrigin() {
        return new double[]{this.minPosition[0] + this.translation[0], this.minPosition[1] + this.translation[1]};
    }

    public double getDrawedDistance() {
        return this.drawedLenghAtInstruction[this.currentInstructionId];
    }

    public double getEstimatedRemainingDuration() {
        return this.estimatedDurationAtInstruction[this.instructions.length] - this.estimatedDurationAtInstruction[this.currentInstructionId];
    }

    public long getElapsedDurationSinceJobStart() {
        return (System.currentTimeMillis() - this.timestampAtJobStart) / 1000L;
    }

    public HashMap<Ink, Integer> getNbInstructionsPerInk() {
        return this.getNbExecutedInstructionsPerInkAt(this.instructions.length);
    }

    public HashMap<Ink, Double> getDrawingDistancesPerInk() {
        return this.getDrawedDistancesPerInkAt(this.instructions.length);
    }

    public HashMap<Ink, Integer> getEstimatedDurationPerInk() {
        return this.getEstimatedRemainingDurationPerInkAt(0);
    }

    public HashMap<Ink, Integer> getNbExecutedInstructionsPerInk() {
        return this.getNbExecutedInstructionsPerInkAt(this.currentInstructionId);
    }

    public HashMap<Ink, Double> getDrawedDistancesPerInk() {
        return this.getDrawedDistancesPerInkAt(this.currentInstructionId);
    }

    public HashMap<Ink, Integer> getEstimatedRemainingDurationPerInk() {
        return this.getEstimatedRemainingDurationPerInkAt(this.currentInstructionId);
    }

    public Set<Ink> getOrderedInks() {
        return this.firstAndLastInstructionsIdsPerInk.keySet();
    }

    public void exportExpectedVsRealDurations() {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter("expectedVsRealDurations.csv"));
            bw.write(String.format(Locale.US, "id,instructionType,instruction,estimatedDuration,measuredDuration,measuredOverEstimatedDurationRatio,xDistance,yDistance,zDistance,totalDistance\n", new Object[0]));
            int idInstr = 0;
            while (idInstr < this.instructions.length) {
                Instruction instr = this.instructions[idInstr];
                double estimatedDuration = instr.getEstimatedDuration();
                int measuredDuration = instr.getRealDuration();
                double measuredOverEstimatedDurationRatio = (double)measuredDuration / estimatedDuration;
                double[] motionCoordinates = instr.getMotionCoordinates();
                bw.write(String.format(Locale.US, "%d,%s,%s,%f,%d,%f,%f,%f,%f,%f\n", idInstr, instr.getType().name(), instr.getInstructionToStream(), estimatedDuration, measuredDuration, measuredOverEstimatedDurationRatio, motionCoordinates[0], motionCoordinates[1], motionCoordinates[2], instr.getMotionLength()));
                ++idInstr;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private HashMap<Ink, Integer> getNbExecutedInstructionsPerInkAt(int idInstruction) {
        HashMap<Ink, Integer> nbExecutedInstructionsPerInk = new HashMap<Ink, Integer>();
        for (Ink ink : this.firstAndLastInstructionsIdsPerInk.keySet()) {
            int[] firstAndLastInstructionsIds = this.firstAndLastInstructionsIdsPerInk.get(ink);
            int nbExecutedInstructions = 0;
            if (idInstruction >= firstAndLastInstructionsIds[0]) {
                nbExecutedInstructions = idInstruction < firstAndLastInstructionsIds[1] ? idInstruction - firstAndLastInstructionsIds[0] : firstAndLastInstructionsIds[1] - firstAndLastInstructionsIds[0];
            }
            nbExecutedInstructionsPerInk.put(ink, nbExecutedInstructions);
        }
        return nbExecutedInstructionsPerInk;
    }

    private HashMap<Ink, Double> getDrawedDistancesPerInkAt(int idInstruction) {
        HashMap<Ink, Double> drawedDistancesPerInk = new HashMap<Ink, Double>();
        for (Ink ink : this.firstAndLastInstructionsIdsPerInk.keySet()) {
            int[] firstAndLastInstructionsIds = this.firstAndLastInstructionsIdsPerInk.get(ink);
            double drawedDistance = 0.0;
            if (idInstruction >= firstAndLastInstructionsIds[0]) {
                drawedDistance = idInstruction < firstAndLastInstructionsIds[1] ? this.drawedLenghAtInstruction[idInstruction] - this.drawedLenghAtInstruction[firstAndLastInstructionsIds[0]] : this.drawedLenghAtInstruction[firstAndLastInstructionsIds[1]] - this.drawedLenghAtInstruction[firstAndLastInstructionsIds[0]];
            }
            drawedDistancesPerInk.put(ink, drawedDistance);
        }
        return drawedDistancesPerInk;
    }

    private HashMap<Ink, Integer> getEstimatedRemainingDurationPerInkAt(int idInstruction) {
        HashMap<Ink, Integer> estimatedRemainingDurationPerInk = new HashMap<Ink, Integer>();
        for (Ink ink : this.firstAndLastInstructionsIdsPerInk.keySet()) {
            int[] firstAndLastInstructionsIds = this.firstAndLastInstructionsIdsPerInk.get(ink);
            int estimatedRemainingDuration = (int)(this.estimatedDurationAtInstruction[firstAndLastInstructionsIds[1]] - this.estimatedDurationAtInstruction[firstAndLastInstructionsIds[0]]);
            if (idInstruction >= firstAndLastInstructionsIds[0]) {
                estimatedRemainingDuration = idInstruction < firstAndLastInstructionsIds[1] ? (int)(this.estimatedDurationAtInstruction[firstAndLastInstructionsIds[1]] - this.estimatedDurationAtInstruction[idInstruction]) : 0;
            }
            estimatedRemainingDurationPerInk.put(ink, estimatedRemainingDuration);
        }
        return estimatedRemainingDurationPerInk;
    }
}

