/*
 * Decompiled with CFR 0.152.
 */
package streaming.engine;

import common.engine.Ink;
import common.engine.Utils;
import java.util.Locale;
import streaming.engine.Job;
import streaming.engine.Tool;
import streaming.enums.InstructionType;
import streaming.enums.PlotterSetting;
import streaming.generators.GcodeGenerator;
import streaming.session.PlotterConfiguration;

public class Instruction {
    private final Job job;
    private final String rawInstruction;
    private InstructionType type;
    private Tool toolToLoad = Tool.UNDEFINED;
    private double[] startPosition;
    private double[] endPosition;
    private double motionLength = 0.0;
    private double estimatedDuration = 0.0;
    private long startTimestamp;
    private long endTimestamp;

    public Instruction(Job job, String rawInstruction, double[] startPosition) {
        this.job = job;
        this.rawInstruction = rawInstruction;
        this.startPosition = startPosition;
        this.endPosition = (double[])startPosition.clone();
        this.parseRawInstruction();
    }

    public Instruction(String rawInstruction) {
        this.job = null;
        this.rawInstruction = rawInstruction;
        this.startPosition = null;
        this.endPosition = null;
        this.parseRawInstruction();
    }

    private void parseRawInstruction() {
        String[] params = this.rawInstruction.split(" ");
        this.type = this.parseInstructionType(params[0]);
        if (this.isMotion()) {
            this.endPosition = new double[]{this.startPosition[0], this.startPosition[1], this.startPosition[2]};
            int idParam = 0;
            while (idParam < params.length) {
                String param;
                params[idParam] = param = params[idParam].toUpperCase();
                int idAxis = 0;
                while (idAxis < 3) {
                    if (param.startsWith(String.valueOf((char)(88 + idAxis)))) {
                        this.endPosition[idAxis] = Double.parseDouble(param.substring(1));
                        break;
                    }
                    ++idAxis;
                }
                ++idParam;
            }
            if (this.isLinearMotion()) {
                this.motionLength = Math.sqrt(Math.pow(this.endPosition[0] - this.startPosition[0], 2.0) + Math.pow(this.endPosition[1] - this.startPosition[1], 2.0) + Math.pow(this.endPosition[2] - this.startPosition[2], 2.0));
                double speedMaxXY = this.isFastMotion() ? PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.FLYING_XY_MAX_SPEED) : PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.DRAWING_XY_MAX_SPEED);
                this.estimatedDuration = Utils.computeXYZTravelDuration(this.startPosition[0], this.startPosition[1], this.startPosition[2], this.endPosition[0], this.endPosition[1], this.endPosition[2], PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.XY_ACCELERATION), speedMaxXY, PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.Z_ACCELERATION), PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.Z_MAX_SPEED), PlotterConfiguration.Instance.getBooleanSettingValue(PlotterSetting.IS_CORE_XY));
            }
        }
    }

    private InstructionType parseInstructionType(String gcodeCommand) {
        if (gcodeCommand.equals("G0") || gcodeCommand.equals("G00")) {
            return InstructionType.FAST_LINEAR_MOVEMENT;
        }
        if (gcodeCommand.equals("G1") || gcodeCommand.equals("G01")) {
            return InstructionType.LOADED_LINEAR_MOVEMENT;
        }
        if (gcodeCommand.startsWith("F")) {
            return InstructionType.SET_FEED_RATE;
        }
        if (gcodeCommand.equals("G20")) {
            return InstructionType.USE_INCHES_UNITS;
        }
        if (gcodeCommand.equals("G21")) {
            return InstructionType.USE_MM_UNITS;
        }
        if (gcodeCommand.equals("G90")) {
            return InstructionType.USE_ABSOLUTE_COORDINATES;
        }
        if (gcodeCommand.equals("G91")) {
            return InstructionType.USE_RELATIVE_COORDINATES;
        }
        if (gcodeCommand.startsWith("$J=")) {
            return InstructionType.JOG;
        }
        if (gcodeCommand.equals("$H")) {
            return InstructionType.HOME;
        }
        if (gcodeCommand.equals("$X")) {
            return InstructionType.UNLOCK;
        }
        if (gcodeCommand.equals(new String(new byte[]{24}))) {
            return InstructionType.RESET;
        }
        if (gcodeCommand.equals("!")) {
            return InstructionType.FEED_HOLD;
        }
        if (gcodeCommand.equals("~")) {
            return InstructionType.FEED_RESUME;
        }
        if (gcodeCommand.equals("$$")) {
            return InstructionType.READ_CONFIGURATION;
        }
        if (gcodeCommand.startsWith(";")) {
            return InstructionType.COMMENT;
        }
        if (gcodeCommand.startsWith("T")) {
            int idTool = Integer.parseInt(gcodeCommand.substring("T".length()));
            if (idTool >= 0) {
                Ink ink = Ink.getAvailableInkByColor(idTool);
                if (ink != null) {
                    this.toolToLoad = PlotterConfiguration.Instance.getToolByInk(ink);
                } else {
                    System.out.println(String.format(Locale.US, "Unavailable color: 0x%x (tool id: %d)", idTool, idTool));
                }
            } else {
                this.toolToLoad = Tool.NONE;
            }
            return InstructionType.TOOL_CHANGE;
        }
        if (gcodeCommand.startsWith("G4P0;TOOL:")) {
            int idTool = Integer.parseInt(gcodeCommand.substring("G4P0;TOOL:".length()));
            if (idTool >= 0) {
                Ink ink = Ink.getAvailableInkByColor(idTool);
                if (ink != null) {
                    this.toolToLoad = PlotterConfiguration.Instance.getToolByInk(ink);
                } else {
                    System.out.println(String.format(Locale.US, "Unavailable color: 0x%x (tool id: %d)", idTool, idTool));
                }
            } else {
                this.toolToLoad = Tool.NONE;
            }
            return InstructionType.TOOL_CHANGE_NOTIFICATION;
        }
        return InstructionType.UNKNOWN;
    }

    public boolean isMotion() {
        return this.isLinearMotion();
    }

    public boolean isDrawingMotion() {
        if (this.isMotion() && !this.isZAxisOnlyMotion() && this.startPosition[2] == 0.0 && this.endPosition[2] == 0.0) {
            return this.type == InstructionType.LOADED_LINEAR_MOVEMENT;
        }
        if (this.type == InstructionType.LOADED_LINEAR_MOVEMENT) {
            System.out.println("Warning: loaded movement higher than floor level");
        }
        return false;
    }

    public boolean isLinearMotion() {
        return this.type == InstructionType.FAST_LINEAR_MOVEMENT || this.type == InstructionType.LOADED_LINEAR_MOVEMENT;
    }

    public boolean isFastMotion() {
        return this.type == InstructionType.FAST_LINEAR_MOVEMENT;
    }

    public boolean isZAxisOnlyMotion() {
        return this.isMotion() && this.startPosition[0] == this.endPosition[0] && this.startPosition[1] == this.endPosition[1] && this.startPosition[2] != this.endPosition[2];
    }

    public String getRawInstruction() {
        return this.rawInstruction;
    }

    public String getInstructionToStream() {
        if (this.type == InstructionType.FAST_LINEAR_MOVEMENT || this.type == InstructionType.LOADED_LINEAR_MOVEMENT) {
            double[] coordinates = new double[]{Double.NaN, Double.NaN, Double.NaN};
            double[] jobOffset = this.job.getTranslation();
            int axis = 0;
            while (axis < 3) {
                coordinates[axis] = this.endPosition[axis] + (axis != 2 ? jobOffset[axis] : 0.0);
                ++axis;
            }
            return this.type == InstructionType.FAST_LINEAR_MOVEMENT ? GcodeGenerator.fastLinearMovement(coordinates[0], coordinates[1], coordinates[2]) : GcodeGenerator.loadedLinearMovement(coordinates[0], coordinates[1], coordinates[2]);
        }
        return this.rawInstruction;
    }

    public InstructionType getType() {
        return this.type;
    }

    public Tool getToolToLoad() {
        return this.toolToLoad;
    }

    public void setStartPosition(double[] startPosition) {
        if (this.startPosition == null) {
            this.startPosition = startPosition;
        } else {
            System.out.println("Cannot redefine instruction start position");
        }
    }

    public double[] getStartPosition() {
        return this.startPosition;
    }

    public double[] getEndPosition() {
        return this.endPosition;
    }

    public double[] getMotionCoordinates() {
        return new double[]{this.endPosition[0] - this.startPosition[0], this.endPosition[1] - this.startPosition[1], this.endPosition[2] - this.startPosition[2]};
    }

    public double getMotionLength() {
        return this.motionLength;
    }

    public double getEstimatedDuration() {
        return this.estimatedDuration;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public void setEndTimestamp(long endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public int getRealDuration() {
        return (int)(this.endTimestamp - this.startTimestamp);
    }
}

