/*
 * Decompiled with CFR 0.152.
 */
package image_processing.transformations;

import common.engine.SettingsSet;
import image_processing.engine.Image;
import image_processing.enums.Setting;
import image_processing.transformations.AbstractTransformation;
import image_processing.transformations.TransformationStep;
import java.awt.image.BufferedImage;

public class ThinningTransformation
extends AbstractTransformation {
    public ThinningTransformation() {
        super(TransformationStep.THINNING, new Setting[0], false);
    }

    private int getNbBlackNeighbours(boolean[][] pixelsMap, int x, int y) {
        int nbBlackNeighbours = 0;
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                if (i != 0 || j != 0 && pixelsMap[x + i][y + j]) {
                    ++nbBlackNeighbours;
                }
                ++j;
            }
            ++i;
        }
        return nbBlackNeighbours;
    }

    private int getNbColorTransitions(boolean[][] pixels, int x, int y) {
        int lastColor = -1;
        int nbColorTransitions = 0;
        int[] nArray = new int[8];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[7] = -1;
        int[] dx = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = -1;
        nArray2[2] = -1;
        nArray2[3] = -1;
        nArray2[5] = 1;
        nArray2[6] = 1;
        nArray2[7] = 1;
        int[] dy = nArray2;
        int i = 0;
        while (i < 9) {
            int color;
            int id = i & 7;
            int n = color = pixels[x + dx[id]][y + dy[id]] ? 1 : 0;
            if (lastColor == -1) {
                lastColor = color;
            } else if (color != lastColor) {
                ++nbColorTransitions;
                lastColor = color;
            }
            ++i;
        }
        return nbColorTransitions;
    }

    @Override
    protected Image executeTransformation(AbstractTransformation previousTransformation, SettingsSet settings) {
        int y;
        int x;
        Image sourceImg = previousTransformation.getOutputImage();
        int W = sourceImg.getWidth();
        int H = sourceImg.getHeight();
        boolean[][] pixels = new boolean[W][H];
        int x2 = 0;
        while (x2 < W) {
            int y2 = 0;
            while (y2 < H) {
                pixels[x2][y2] = sourceImg.getPixel(x2, y2) != 0xFFFFFF;
                ++y2;
            }
            ++x2;
        }
        int nbPixelsRemoved = 1;
        while (nbPixelsRemoved > 0) {
            nbPixelsRemoved = 0;
            int idPass = 0;
            while (idPass < 2) {
                x = 1;
                while (x < W - 1) {
                    y = 1;
                    while (y < H - 1) {
                        int nbBlackNeighbours;
                        if (pixels[x][y] && (nbBlackNeighbours = this.getNbBlackNeighbours(pixels, x, y)) >= 2 && nbBlackNeighbours <= 6 && this.getNbColorTransitions(pixels, x, y) == 1) {
                            if (idPass == 1) {
                                if (!(pixels[x][y - 1] && pixels[x - 1][y] && pixels[x][y + 1] || pixels[x + 1][y] && pixels[x][y + 1] && pixels[x - 1][y])) {
                                    pixels[x][y] = false;
                                    ++nbPixelsRemoved;
                                }
                            } else if (!(pixels[x][y - 1] && pixels[x - 1][y] && pixels[x + 1][y] || pixels[x][y - 1] && pixels[x][y + 1] && pixels[x - 1][y])) {
                                pixels[x][y] = false;
                                ++nbPixelsRemoved;
                            }
                        }
                        ++y;
                    }
                    ++x;
                }
                ++idPass;
            }
        }
        BufferedImage outputImg = new BufferedImage(sourceImg.getWidth(), sourceImg.getHeight(), 1);
        x = 0;
        while (x < W) {
            y = 0;
            while (y < H) {
                outputImg.setRGB(x, y, pixels[x][y] ? -16777216 : -1);
                ++y;
            }
            ++x;
        }
        return new Image(outputImg);
    }
}

