/*
 * Decompiled with CFR 0.152.
 */
package image_processing.transformations;

import common.engine.Ink;
import common.engine.SettingsSet;
import image_processing.engine.Brush;
import image_processing.engine.BrushPalette;
import image_processing.engine.Image;
import image_processing.engine.canny.ImageUtils;
import image_processing.engine.canny.JCanny;
import image_processing.enums.Setting;
import image_processing.session.Project;
import image_processing.transformations.AbstractTransformation;
import image_processing.transformations.ColorQuantizationTransformation;
import image_processing.transformations.TransformationStep;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ThickOutliningTransformation
extends AbstractTransformation {
    public ThickOutliningTransformation() {
        super(TransformationStep.THICK_OUTLINING, new Setting[]{Setting.ENABLE_THICK_OUTLINING, Setting.MULTICOLOR_THICK_OUTLINING, Setting.CANNY_HIGH_THRESHOLD, Setting.CANNY_LOW_THRESHOLD}, false);
    }

    @Override
    protected Image executeTransformation(AbstractTransformation previousTransformation, SettingsSet settings) {
        ColorQuantizationTransformation cqt = (ColorQuantizationTransformation)Project.Instance.getTransformation(TransformationStep.COLOR_QUANTIZATION);
        if (settings.getBoolSetting(Setting.ENABLE_THICK_OUTLINING)) {
            BrushPalette brushPalette = settings.getSelectedBrushPalette();
            boolean multicolor = settings.getBoolSetting(Setting.MULTICOLOR_THICK_OUTLINING);
            HashMap<Integer, BufferedImage> monochromesImagesPerColor = cqt.getMonochromesImagesPerColor();
            Vector<BufferedImage> outlinesImages = new Vector<BufferedImage>();
            for (Map.Entry<Integer, BufferedImage> entry : monochromesImagesPerColor.entrySet()) {
                Brush brush = brushPalette.getBrushByInputColor(entry.getKey());
                if (brush == null || !brush.isThickOutliningEnabled() || brush.getInk() == null) continue;
                int outlineColor = multicolor ? brush.getInk().getColorAsRgb() : Ink.getBlackestAvailableInk().getColorAsRgb();
                outlinesImages.add(JCanny.CannyEdges(entry.getValue(), settings.getIntSetting(Setting.CANNY_HIGH_THRESHOLD), settings.getDoubleSetting(Setting.CANNY_LOW_THRESHOLD), outlineColor));
            }
            return new Image(ImageUtils.mergeImages(outlinesImages.toArray(new BufferedImage[0]), 0xFFFFFF));
        }
        BufferedImage img = new BufferedImage(cqt.getOutputImage().getWidth(), cqt.getOutputImage().getHeight(), 2);
        Graphics g = img.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        return new Image(img);
    }
}

