/*
 * Decompiled with CFR 0.152.
 */
package image_processing.transformations;

import common.engine.Ink;
import common.engine.Line;
import common.engine.Path;
import common.engine.SettingsSet;
import common.engine.Utils;
import image_processing.engine.Image;
import image_processing.enums.OutputMirroring;
import image_processing.enums.OutputPosition;
import image_processing.enums.Setting;
import image_processing.session.Configuration;
import image_processing.session.Project;
import image_processing.transformations.AbstractTransformation;
import image_processing.transformations.PathsGenerationTransformation;
import image_processing.transformations.TransformationStep;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import streaming.enums.PlotterSetting;
import streaming.session.PlotterConfiguration;

public class PathsOptimizationTransformation
extends AbstractTransformation {
    private static final boolean DISABLE_PATH_OPTIMIZATION = true;
    private HashMap<Ink, Path> originalPathsPerInk;
    private HashMap<Ink, Path> optimizedPathsPerInk = new HashMap();

    public PathsOptimizationTransformation() {
        super(TransformationStep.PATHS_OPTIMIZATION, new Setting[0], true);
    }

    public HashMap<Ink, Path> getOriginalPathsPerInk() {
        return this.originalPathsPerInk;
    }

    public HashMap<Ink, Path> getOptimizedPathsPerInk() {
        return this.optimizedPathsPerInk;
    }

    public void exportGCode() {
        String projectName = this.settingsValues.getFileSetting(Setting.IMAGE_FILE).getName();
        File exportDir = new File(projectName = projectName.substring(0, projectName.lastIndexOf(".")));
        if (exportDir.exists()) {
            exportDir.delete();
        }
        exportDir.mkdir();
        Configuration.Instance.save(String.valueOf(projectName) + "/" + projectName);
        int imageDpi = this.settingsValues.getIntSetting(Setting.IMAGE_DPI);
        int rotationAngle = this.settingsValues.getOutputRotationSetting(Setting.OUTPUT_ROTATION).getAngle();
        Image originalImage = Project.Instance.getTransformation(TransformationStep.IMAGE_IMPORT).getOutputImage();
        double xMax = Utils.pxToMm(originalImage.getWidth(), imageDpi);
        double yMax = Utils.pxToMm(originalImage.getHeight(), imageDpi);
        OutputPosition position = this.settingsValues.getOutputPositionSetting(Setting.OUTPUT_POSITION);
        OutputMirroring mirroring = this.settingsValues.getOutputMirroringSetting(Setting.OUTPUT_MIRRORING);
        double trX = position.getXPosInA4();
        double trY = position.getYPosInA4();
        if (position.isCentered()) {
            trX -= xMax / 2.0;
            trY -= yMax / 2.0;
        }
        double clearZHeight = this.settingsValues.getDoubleSetting(Setting.CLEAR_Z_HEIGHT);
        int nbLinesToGenerate = 0;
        int nbLinesGenerated = 0;
        for (Path path : this.optimizedPathsPerInk.values()) {
            nbLinesToGenerate += path.getNbLines();
        }
        try {
            String filename = String.valueOf(projectName) + "/" + projectName + ".gcode";
            BufferedWriter allColorsBw = new BufferedWriter(new FileWriter(filename));
            double feedrate = Utils.speedToFeedrate(PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.FLYING_XY_MAX_SPEED), PlotterConfiguration.Instance.getBooleanSettingValue(PlotterSetting.IS_CORE_XY));
            String header = String.format(Locale.US, "G21 (use mm)\nG90 (use absolute coordinates)\nF%.0f\n", feedrate);
            allColorsBw.write(header);
            for (Ink ink : Ink.getAvailableInks()) {
                filename = String.valueOf(projectName) + "/" + projectName + "-" + ink.getName() + ".gcode";
                Path path = this.optimizedPathsPerInk.get(ink);
                if (path.getNbLines() > 0) {
                    allColorsBw.write(String.format(Locale.US, "T%d M6 ;change pen color: %s\n", ink.getColorAsRgb(), ink.getName()));
                    BufferedWriter singleColorBw = new BufferedWriter(new FileWriter(filename));
                    singleColorBw.write(header);
                    double lastX = Double.MAX_VALUE;
                    double lastY = Double.MAX_VALUE;
                    ArrayList<Line> lines = path.getLines();
                    int idLine = 0;
                    while (idLine < lines.size()) {
                        double progression = (double)(nbLinesGenerated + idLine) / (double)nbLinesToGenerate;
                        this.setProgression("Exporting G-Code...", progression, false);
                        Line line = lines.get(idLine);
                        Line transformedLine = Line.createTranslatedLine(Line.createMirroredLine(Line.createRotatedLine(line, rotationAngle, xMax / 2.0, yMax / 2.0), mirroring, xMax, yMax), trX, trY);
                        if (transformedLine.x0 != lastX || transformedLine.y0 != lastY) {
                            this.multipleWrite(singleColorBw, allColorsBw, String.format(Locale.US, "G0 Z%f\n", clearZHeight));
                            this.multipleWrite(singleColorBw, allColorsBw, String.format(Locale.US, "G0 X%f Y%f\n", transformedLine.x0, transformedLine.y0));
                            this.multipleWrite(singleColorBw, allColorsBw, "G0 Z0\n");
                        }
                        this.multipleWrite(singleColorBw, allColorsBw, String.format(Locale.US, "G1 X%f Y%f\n", transformedLine.x1, transformedLine.y1));
                        lastX = transformedLine.x1;
                        lastY = transformedLine.y1;
                        ++idLine;
                    }
                    this.multipleWrite(singleColorBw, allColorsBw, String.format(Locale.US, "G0 Z%f\n", clearZHeight));
                    singleColorBw.write(String.format(Locale.US, "G0 X0 Y0 Z%f\n", clearZHeight));
                    singleColorBw.close();
                } else {
                    new File(filename).delete();
                }
                nbLinesGenerated += path.getNbLines();
            }
            allColorsBw.write("T-1 M6 ;unload pen\n");
            allColorsBw.write(String.format(Locale.US, "G0 X0 Y0 Z%f\n", clearZHeight));
            allColorsBw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setProgression("Done", 1.0, false);
    }

    private void multipleWrite(BufferedWriter bw0, BufferedWriter bw1, String data) throws IOException {
        bw0.write(data);
        bw1.write(data);
    }

    public void optimizePath(Ink ink, int idPathToOptimize, int nbPathsToOptimize) {
        this.setProgression(1.0, true);
    }

    @Override
    public void drawVectorizedImageOutput(Graphics2D g) {
        g.setColor(Color.black);
        Stroke defaultStroke = g.getStroke();
        g.setStroke(Utils.getPenStrokeInMm(this.settingsValues.getDoubleSetting(Setting.PEN_TIP_DIAMETER)));
        for (Map.Entry<Ink, Path> entry : this.optimizedPathsPerInk.entrySet()) {
            g.setColor(Utils.getLighterColor(entry.getKey().getColor()));
            Path path = entry.getValue();
            Line lastLine = null;
            for (Line line : path.getLines()) {
                if (lastLine != null && (line.x0 != lastLine.x1 || line.y0 != lastLine.y1)) {
                    g.draw(new Line2D.Double(Utils.mmToPxDouble(lastLine.x1, this.settingsValues.getIntSetting(Setting.IMAGE_DPI)), Utils.mmToPxDouble(lastLine.y1, this.settingsValues.getIntSetting(Setting.IMAGE_DPI)), Utils.mmToPxDouble(line.x0, this.settingsValues.getIntSetting(Setting.IMAGE_DPI)), Utils.mmToPxDouble(line.y0, this.settingsValues.getIntSetting(Setting.IMAGE_DPI))));
                }
                lastLine = line;
            }
        }
        g.setStroke(defaultStroke);
    }

    @Override
    protected Image executeTransformation(AbstractTransformation previousTransformation, SettingsSet settings) {
        this.originalPathsPerInk = ((PathsGenerationTransformation)previousTransformation).getPathsPerInk();
        this.optimizedPathsPerInk = (HashMap)((PathsGenerationTransformation)previousTransformation).getPathsPerInk().clone();
        int idInk = 0;
        for (Map.Entry<Ink, Path> entry : this.optimizedPathsPerInk.entrySet()) {
            Ink ink = entry.getKey();
            this.optimizePath(ink, idInk, this.optimizedPathsPerInk.size());
            ++idInk;
        }
        return null;
    }
}

