/*
 * Decompiled with CFR 0.152.
 */
package image_processing.transformations;

import common.engine.Ink;
import common.engine.Line;
import common.engine.Path;
import common.engine.SettingsSet;
import common.engine.Utils;
import image_processing.engine.Brush;
import image_processing.engine.BrushPalette;
import image_processing.engine.Image;
import image_processing.enums.Setting;
import image_processing.session.Project;
import image_processing.transformations.AbstractTransformation;
import image_processing.transformations.FineOutliningTransformation;
import image_processing.transformations.TransformationStep;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class PathsGenerationTransformation
extends AbstractTransformation {
    private static final double IMAGE_TO_PATH_PRECISION_IN_MM = 0.25;
    private HashMap<Ink, Path> pathsPerInk = new HashMap();

    public PathsGenerationTransformation() {
        super(TransformationStep.PATHS_GENERATION, new Setting[]{Setting.LPMM_MAX, Setting.BRUSH_PALETTES, Setting.ID_SELECTED_BRUSH_PALETTE, Setting.OUTLINE_LPMM, Setting.CLEAR_Z_HEIGHT, Setting.MIN_SEGMENT_LENGTH}, true);
    }

    public HashMap<Ink, Path> getPathsPerInk() {
        return this.pathsPerInk;
    }

    private Path generateOptimizedPath(Path path) {
        if (path.getNbLines() == 0) {
            return path;
        }
        Path continuousPath = new Path(path.getZClearHeight());
        ArrayList remainingLines = (ArrayList)path.getLines().clone();
        Line lastLine = (Line)remainingLines.remove(0);
        continuousPath.addLine(lastLine);
        while (remainingLines.size() > 0) {
            Line line;
            int idClosestLine = 0;
            double smallestCost = Double.MAX_VALUE;
            int idLine = 0;
            while (idLine < remainingLines.size()) {
                double cost = ((Line)remainingLines.get(idLine)).getCostFrom(lastLine);
                if (cost < smallestCost) {
                    idClosestLine = idLine;
                    smallestCost = cost;
                }
                ++idLine;
            }
            lastLine = line = (Line)remainingLines.remove(idClosestLine);
            continuousPath.addLine(line);
        }
        return continuousPath;
    }

    private HashMap<Ink, Path> removeSegmentsTooShort(HashMap<Ink, Path> pathsPerInk, double minSegmentLengthInMm) {
        if (minSegmentLengthInMm == 0.0) {
            return pathsPerInk;
        }
        double minSquaredLength = minSegmentLengthInMm * minSegmentLengthInMm;
        HashMap<Ink, Path> cleanedPathsPerInk = new HashMap<Ink, Path>();
        for (Map.Entry<Ink, Path> entry : pathsPerInk.entrySet()) {
            Path path = this.generateOptimizedPath(entry.getValue());
            Path cleanedPath = new Path(path.getZClearHeight());
            int idLine = 0;
            while (idLine < path.getNbLines()) {
                Line line = path.getLine(idLine);
                if (line.getSquaredLength() >= minSquaredLength) {
                    cleanedPath.addLine(line);
                } else {
                    Line previousLine = null;
                    double squaredDistToPreviousLine = Double.MAX_VALUE;
                    Line nextLine = null;
                    double squaredDistToNextLine = Double.MAX_VALUE;
                    if (idLine > 0) {
                        previousLine = path.getLine(idLine - 1);
                        squaredDistToPreviousLine = previousLine.getSquaredFlyingDistanceTo(line);
                    }
                    if (idLine < path.getNbLines() - 1) {
                        nextLine = path.getLine(idLine + 1);
                        squaredDistToNextLine = line.getSquaredFlyingDistanceTo(nextLine);
                    }
                    if (squaredDistToPreviousLine <= squaredDistToNextLine && squaredDistToPreviousLine < minSquaredLength) {
                        if (line.isAlignedWith(previousLine)) {
                            cleanedPath.addLine(new Line(previousLine.x1, previousLine.y1, line.x1, line.y1));
                        } else {
                            cleanedPath.addLine(new Line(previousLine.x1, previousLine.y1, line.x0, line.y0));
                            cleanedPath.addLine(new Line(line.x0, line.y0, line.x1, line.y1));
                        }
                    } else if (squaredDistToNextLine <= squaredDistToPreviousLine && squaredDistToNextLine < minSquaredLength) {
                        if (line.isAlignedWith(nextLine)) {
                            cleanedPath.addLine(new Line(line.x0, line.y0, nextLine.x0, nextLine.y0));
                        } else {
                            cleanedPath.addLine(new Line(line.x0, line.y0, line.x1, line.y1));
                            cleanedPath.addLine(new Line(line.x1, line.y1, nextLine.x0, nextLine.y0));
                        }
                    }
                }
                ++idLine;
            }
            cleanedPathsPerInk.put(entry.getKey(), cleanedPath);
        }
        return cleanedPathsPerInk;
    }

    private void generatePaths(Image img, BrushPalette brushPalette, double lpmmMax, int imageDpi, HashMap<Ink, Path> pathsPerInk) {
        double W = Utils.pxToMm(img.getWidth(), imageDpi);
        double H = Utils.pxToMm(img.getHeight(), imageDpi);
        int nbBrushes = brushPalette.getNbBrushes();
        int idBrush = 0;
        while (idBrush < nbBrushes) {
            Brush brush = brushPalette.getBrush(idBrush);
            Path path = pathsPerInk.get(brush.getInk());
            if (path != null) {
                int a = brush.getAngle();
                double angle = (double)a * Math.PI / 180.0;
                double p = 1.0 / (brush.getLevel() * lpmmMax);
                if (p != 0.0) {
                    double yFrom = angle > 0.0 ? 0.0 : W * Math.tan(angle);
                    double yTo = angle > 0.0 ? H + W / Math.tan(angle) : H;
                    double deltaY = p;
                    if (a != 90) {
                        deltaY = p / Math.cos(angle);
                    } else {
                        yFrom = 0.0;
                        yTo = W;
                    }
                    int nbLines = (int)Math.ceil((yTo - yFrom) / deltaY);
                    int idLine = 0;
                    while (idLine < nbLines) {
                        double y;
                        double x;
                        if (this.shouldAbortUpdate) {
                            return;
                        }
                        Vector<Line> segmentsInLine = new Vector<Line>();
                        this.setProgression((double)idBrush / (double)nbBrushes + (double)idLine / (double)nbLines / (double)nbBrushes, false);
                        double xStart = a != 90 ? 0.0 : (double)idLine * p;
                        double yStart = a != 90 ? yFrom + (double)idLine * deltaY : 0.0;
                        double xLineStart = xStart;
                        double yLineStart = yStart;
                        double r = 0.0;
                        boolean isPointOutsideImage = xLineStart < 0.0 || yLineStart < 0.0 || xLineStart >= W || yLineStart >= H;
                        boolean lineColored = !isPointOutsideImage && img.getPixel(Utils.mmToPx(xLineStart, imageDpi), Utils.mmToPx(yLineStart, imageDpi)) == brush.getInputColor();
                        while (true) {
                            boolean isWholeLineOutsideImage;
                            x = xStart + (r += 0.25) * Math.cos(angle);
                            y = yStart - r * (a != 90 ? Math.sin(angle) : -1.0);
                            boolean bl = a != 90 ? x >= W : (isWholeLineOutsideImage = y >= H);
                            if (isWholeLineOutsideImage) break;
                            isPointOutsideImage = x < 0.0 || y < 0.0 || x >= W || y >= H;
                            boolean colored = !isPointOutsideImage && img.getPixel(Utils.mmToPx(x, imageDpi), Utils.mmToPx(y, imageDpi)) == brush.getInputColor();
                            if (colored == lineColored) continue;
                            if (lineColored) {
                                segmentsInLine.add(new Line(xLineStart, yLineStart, x, y, idLine % 2 == 0));
                            } else {
                                xLineStart = x;
                                yLineStart = y;
                            }
                            lineColored = colored;
                        }
                        if (lineColored) {
                            segmentsInLine.add(new Line(xLineStart, yLineStart, x, y, idLine % 2 == 0));
                        }
                        int idSegment = 0;
                        while (idSegment < segmentsInLine.size()) {
                            int idSegmentToAdd = idLine % 2 == 0 ? segmentsInLine.size() - 1 - idSegment : idSegment;
                            path.addLine((Line)segmentsInLine.get(idSegmentToAdd));
                            ++idSegment;
                        }
                        ++idLine;
                    }
                }
            }
            ++idBrush;
        }
    }

    @Override
    public void drawVectorizedImageOutput(Graphics2D g) {
        g.setColor(Color.black);
        Stroke defaultStroke = g.getStroke();
        g.setStroke(Utils.getPenStrokeInMm(this.settingsValues.getDoubleSetting(Setting.PEN_TIP_DIAMETER)));
        int imageDpi = this.settingsValues.getIntSetting(Setting.IMAGE_DPI);
        for (Map.Entry<Ink, Path> entry : this.pathsPerInk.entrySet()) {
            g.setColor(entry.getKey().getColor());
            Path path = entry.getValue();
            for (Line line : path.getLines()) {
                g.draw(new Line2D.Double(Utils.mmToPxDouble(line.x0, imageDpi), Utils.mmToPxDouble(line.y0, imageDpi), Utils.mmToPxDouble(line.x1, imageDpi), Utils.mmToPxDouble(line.y1, imageDpi)));
            }
        }
        g.setStroke(defaultStroke);
    }

    @Override
    protected Image executeTransformation(AbstractTransformation previousTransformation, SettingsSet settings) {
        int imageDpi = settings.getIntSetting(Setting.IMAGE_DPI);
        this.pathsPerInk.clear();
        for (Ink ink : Ink.getAvailableInks()) {
            this.pathsPerInk.put(ink, new Path(settings.getDoubleSetting(Setting.CLEAR_Z_HEIGHT)));
        }
        Image colorQuantizedImage = Project.Instance.getTransformation(TransformationStep.COLOR_QUANTIZATION).getOutputImage();
        this.generatePaths(colorQuantizedImage, settings.getSelectedBrushPalette(), settings.getDoubleSetting(Setting.LPMM_MAX), imageDpi, this.pathsPerInk);
        BrushPalette outlineBrushPalette = new BrushPalette();
        for (Ink ink : Ink.getAvailableInks()) {
            outlineBrushPalette.addBrush(new Brush(ink.getColorAsRgb(), ink, 1.0, 45, false, false));
        }
        this.generatePaths(Project.Instance.getTransformation(TransformationStep.THICK_OUTLINING).getOutputImage(), outlineBrushPalette, settings.getDoubleSetting(Setting.OUTLINE_LPMM), imageDpi, this.pathsPerInk);
        FineOutliningTransformation fineOutliningTr = (FineOutliningTransformation)Project.Instance.getTransformation(TransformationStep.FINE_OUTLINING);
        for (Path pathInPx : fineOutliningTr.getOutlinePaths()) {
            Path pathInMm = pathInPx.convertFromPxToMm(imageDpi);
            for (Line line : pathInMm.getLines()) {
                this.pathsPerInk.get(Ink.getBlackestAvailableInk()).addLine(line);
            }
        }
        this.pathsPerInk = this.removeSegmentsTooShort(this.pathsPerInk, settings.getDoubleSetting(Setting.MIN_SEGMENT_LENGTH));
        return null;
    }
}

