/*
 * Decompiled with CFR 0.152.
 */
package image_processing.transformations;

import common.engine.Ink;
import common.engine.Line;
import common.engine.Path;
import common.engine.SettingsSet;
import common.engine.Utils;
import image_processing.engine.Brush;
import image_processing.engine.BrushPalette;
import image_processing.engine.canny.ImageUtils;
import image_processing.enums.Setting;
import image_processing.generators.ImageFineOutliner;
import image_processing.session.Project;
import image_processing.transformations.AbstractTransformation;
import image_processing.transformations.ColorQuantizationTransformation;
import image_processing.transformations.TransformationStep;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class FineOutliningTransformation
extends AbstractTransformation {
    private Vector<Path> outlinePaths = new Vector();

    public FineOutliningTransformation() {
        super(TransformationStep.FINE_OUTLINING, new Setting[]{Setting.ENABLE_FINE_OUTLINING, Setting.PEN_TIP_DIAMETER}, true);
    }

    public Vector<Path> getOutlinePaths() {
        return this.outlinePaths;
    }

    @Override
    public void drawVectorizedImageOutput(Graphics2D g) {
        g.setColor(Ink.getBlackestAvailableInk().getColor());
        image_processing.engine.Image thickOutlineImg = Project.Instance.getTransformation(TransformationStep.THICK_OUTLINING).getOutputImage();
        if (thickOutlineImg != null) {
            g.drawImage((Image)thickOutlineImg.getBufferedImage(), 0, 0, null);
        }
        Stroke defaultStroke = g.getStroke();
        g.setStroke(Utils.getPenStrokeInMm(this.settingsValues.getDoubleSetting(Setting.PEN_TIP_DIAMETER)));
        for (Path path : this.outlinePaths) {
            for (Line line : path.getLines()) {
                g.draw(new Line2D.Double(line.x0, line.y0, line.x1, line.y1));
            }
        }
        g.setStroke(defaultStroke);
    }

    @Override
    protected image_processing.engine.Image executeTransformation(AbstractTransformation previousTransformation, SettingsSet settings) {
        ColorQuantizationTransformation cqt = (ColorQuantizationTransformation)Project.Instance.getTransformation(TransformationStep.COLOR_QUANTIZATION);
        if (settings.getBoolSetting(Setting.ENABLE_FINE_OUTLINING)) {
            HashMap<Integer, BufferedImage> monochromesImagesPerColor = cqt.getMonochromesImagesPerColor();
            BrushPalette brushPalette = settings.getSelectedBrushPalette();
            Vector<BufferedImage> imagesToOutline = new Vector<BufferedImage>();
            for (Map.Entry<Integer, BufferedImage> entry : monochromesImagesPerColor.entrySet()) {
                int color = entry.getKey();
                Brush brush = brushPalette.getBrushByInputColor(color);
                if (brush == null || !brush.isFineOutliningEnabled()) continue;
                imagesToOutline.add(entry.getValue());
            }
            BufferedImage img = ImageUtils.mergeImages(imagesToOutline.toArray(new BufferedImage[0]), 0);
            this.outlinePaths = ImageFineOutliner.generateImageFineOutlinePaths(img);
            int W = previousTransformation.getOutputImage().getWidth();
            int H = previousTransformation.getOutputImage().getHeight();
            BufferedImage outlineImg = new BufferedImage(W, H, 2);
            this.drawVectorizedImageOutput((Graphics2D)outlineImg.getGraphics());
            BufferedImage mergedThickAndFineOutlinings = ImageUtils.mergeImages(new BufferedImage[]{outlineImg, previousTransformation.getOutputImage().getBufferedImage()}, 0);
            return new image_processing.engine.Image(mergedThickAndFineOutlinings);
        }
        this.outlinePaths.clear();
        return previousTransformation.getOutputImage();
    }
}

