/*
 * Decompiled with CFR 0.152.
 */
package image_processing.transformations;

import common.engine.SettingsSet;
import image_processing.engine.Image;
import image_processing.enums.ColorQuantizationMethod;
import image_processing.enums.ColorSelectionMethod;
import image_processing.enums.Setting;
import image_processing.generators.BrushPaletteGenerator;
import image_processing.generators.ColorPaletteGenerator;
import image_processing.generators.ImageGenerator;
import image_processing.transformations.AbstractTransformation;
import image_processing.transformations.TransformationStep;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class ColorQuantizationTransformation
extends AbstractTransformation {
    private HashMap<Integer, BufferedImage> monochromesImagesPerColor = new HashMap();

    public ColorQuantizationTransformation() {
        super(TransformationStep.COLOR_QUANTIZATION, new Setting[]{Setting.COLOR_SPACE, Setting.NB_QUANTIZATION_COLORS, Setting.BLURRING_RADIUS, Setting.BLURRING_INTENSITY, Setting.COLOR_QUANTIZATION_METHOD, Setting.COLOR_SELECTION_METHOD}, false);
    }

    public HashMap<Integer, BufferedImage> getMonochromesImagesPerColor() {
        return this.monochromesImagesPerColor;
    }

    @Override
    public Image executeTransformation(AbstractTransformation previousTransformation, SettingsSet settings) {
        Image inputImage = previousTransformation.getOutputImage();
        this.outputColorPalette = settings.getColorQuantizationMethodSetting(Setting.COLOR_QUANTIZATION_METHOD) == ColorQuantizationMethod.USE_AVAILABLE_INKS ? BrushPaletteGenerator.generateBrushPaletteFromInks(settings.getIntSetting(Setting.NB_QUANTIZATION_COLORS)).getInputColorPalette() : ColorPaletteGenerator.generateReducedPaletteColorFromImage(inputImage, settings.getIntSetting(Setting.NB_QUANTIZATION_COLORS), ColorQuantizationMethod.values()[settings.getIntSetting(Setting.COLOR_QUANTIZATION_METHOD)], ColorSelectionMethod.values()[settings.getIntSetting(Setting.COLOR_SELECTION_METHOD)]);
        Image blurredImage = ImageGenerator.generateBlurredImage(inputImage, settings.getIntSetting(Setting.BLURRING_RADIUS), settings.getDoubleSetting(Setting.BLURRING_INTENSITY));
        Image recoloredImage = ImageGenerator.generateRecoloredImage(blurredImage, this.outputColorPalette, this.monochromesImagesPerColor, settings.getColorSpaceSetting(Setting.COLOR_SPACE));
        return recoloredImage;
    }
}

