/*
 * Decompiled with CFR 0.152.
 */
package image_processing.transformations;

import common.engine.SettingsSet;
import image_processing.engine.ColorPalette;
import image_processing.engine.Image;
import image_processing.enums.Setting;
import image_processing.listeners.TransformationResultChangeListener;
import image_processing.session.Configuration;
import image_processing.transformations.TransformationStep;
import java.awt.Graphics2D;
import java.util.Set;
import java.util.Vector;

public abstract class AbstractTransformation {
    private final TransformationStep transformationStep;
    private final Setting[] settingsDependingOn;
    protected SettingsSet settingsValues;
    private Image outputImage;
    protected ColorPalette outputColorPalette;
    protected Vector<TransformationResultChangeListener> listeners = new Vector();
    protected boolean shouldAbortUpdate;
    private boolean isTransformationDone;
    private boolean isOutputImageVectorized;

    public AbstractTransformation(TransformationStep transformationStep, Setting[] settingsDependingOn, boolean isOutputImageVectorized) {
        this.transformationStep = transformationStep;
        this.settingsDependingOn = settingsDependingOn;
        this.isOutputImageVectorized = isOutputImageVectorized;
        this.settingsValues = Configuration.Instance.getCurrentSettings();
    }

    public final Setting[] getSettingsDependingOn() {
        return this.settingsDependingOn;
    }

    public final boolean dependsOnSettings(Set<String> settingsNames) {
        Setting[] settingArray = this.settingsDependingOn;
        int n = this.settingsDependingOn.length;
        int n2 = 0;
        while (n2 < n) {
            Setting neededSetting = settingArray[n2];
            for (String settingToCheck : settingsNames) {
                if (!settingToCheck.equals(neededSetting.getName())) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public final void addListener(TransformationResultChangeListener listener) {
        this.listeners.add(listener);
    }

    public final TransformationStep getTransformationStep() {
        return this.transformationStep;
    }

    public final SettingsSet getSettingsValues() {
        return this.settingsValues;
    }

    public final Image getOutputImage() {
        return this.outputImage;
    }

    public final ColorPalette getOutputColorPalette() {
        return this.outputColorPalette;
    }

    protected final void setProgression(String label, double progression, boolean shouldRepaint) {
        for (TransformationResultChangeListener listener : this.listeners) {
            listener.transformationProgressionChanged(this, label, progression, shouldRepaint);
        }
    }

    protected final void setProgression(double progression, boolean shouldRepaint) {
        this.setProgression(null, progression, shouldRepaint);
    }

    public final void updateTransformation(AbstractTransformation previousTransformation, SettingsSet settings) {
        this.isTransformationDone = false;
        this.outputImage = this.executeTransformation(previousTransformation, settings);
        this.settingsValues = settings;
        this.isTransformationDone = true;
        this.shouldAbortUpdate = false;
        for (TransformationResultChangeListener listener : this.listeners) {
            listener.transformationResultChanged(this);
        }
    }

    public final void abortUpdate() {
        this.shouldAbortUpdate = true;
    }

    public final boolean isTransformationDone() {
        return this.isTransformationDone;
    }

    public final boolean isOutputImageVectorized() {
        return this.isOutputImageVectorized;
    }

    protected abstract Image executeTransformation(AbstractTransformation var1, SettingsSet var2);

    public void drawVectorizedImageOutput(Graphics2D g) {
    }
}

