/*
 * Decompiled with CFR 0.152.
 */
package image_processing.session;

import common.engine.SettingsSet;
import image_processing.listeners.ConfigurationChangeListener;
import image_processing.session.ComputationThread;
import image_processing.session.Configuration;
import image_processing.transformations.AbstractTransformation;
import image_processing.transformations.ColorQuantizationTransformation;
import image_processing.transformations.FineOutliningTransformation;
import image_processing.transformations.ImageImportTransformation;
import image_processing.transformations.PathsGenerationTransformation;
import image_processing.transformations.PathsOptimizationTransformation;
import image_processing.transformations.RecolorizationTransformation;
import image_processing.transformations.ThickOutliningTransformation;
import image_processing.transformations.TransformationStep;
import streaming.session.PlotterConfiguration;

public class Project
implements ConfigurationChangeListener {
    public static Project Instance;
    private AbstractTransformation[] transformations;
    private ComputationThread computationThread;

    private Project() {
        Configuration.Instance.addListener(this);
        this.transformations = new AbstractTransformation[]{new ImageImportTransformation(), new ColorQuantizationTransformation(), new RecolorizationTransformation(), new ThickOutliningTransformation(), new FineOutliningTransformation(), new PathsGenerationTransformation(), new PathsOptimizationTransformation()};
        this.computationThread = new ComputationThread(this.transformations);
    }

    @Override
    public void configurationSettingsValuesChanged(SettingsSet settings) {
        this.computationThread.compute(settings);
    }

    public AbstractTransformation getTransformation(TransformationStep transformationStep) {
        if (transformationStep.ordinal() > this.transformations.length) {
            System.err.println("No transformation for step " + transformationStep.name());
            return null;
        }
        return this.transformations[transformationStep.ordinal()];
    }

    public ComputationThread getComputationThread() {
        return this.computationThread;
    }

    public static void initProject() {
        if (Instance == null) {
            PlotterConfiguration.initSingleton();
            Configuration.initSingleton();
            Instance = new Project();
        }
    }
}

