/*
 * Decompiled with CFR 0.152.
 */
package image_processing.session;

import common.engine.SettingsSet;
import common.engine.Utils;
import image_processing.engine.BrushPalette;
import image_processing.enums.ColorAttributionMethod;
import image_processing.enums.ColorQuantizationMethod;
import image_processing.enums.ColorSelectionMethod;
import image_processing.enums.ColorSpace;
import image_processing.enums.OutputMirroring;
import image_processing.enums.OutputPosition;
import image_processing.enums.Setting;
import image_processing.listeners.ConfigurationChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONObject;

public class Configuration {
    public static Configuration Instance;
    public static int NB_BRUSH_PALETTES_AVAILABLE;
    private JSONObject settings = new JSONObject();
    private Vector<ConfigurationChangeListener> listeners = new Vector();

    static {
        NB_BRUSH_PALETTES_AVAILABLE = 8;
    }

    private Configuration() {
        this.loadConfigurationFile(new File(".last-config.json"), false);
    }

    public void loadConfigurationFile(File configurationFile, boolean keepInputImage) {
        String inputImage = this.settings.optString(Setting.IMAGE_FILE.getName(), "");
        this.settings = Configuration.getDefaultSettings();
        String configurationFileContent = null;
        try {
            configurationFileContent = Utils.readFile(configurationFile);
        }
        catch (IOException e) {
            System.out.println("Failed to load last configuration, use default configuration");
        }
        if (configurationFileContent != null) {
            JSONObject userSettings = new JSONObject(configurationFileContent);
            for (String settingName : userSettings.keySet()) {
                this.settings.put(settingName, userSettings.get(settingName));
            }
        }
        if (keepInputImage && !inputImage.equals("")) {
            this.settings.put(Setting.IMAGE_FILE.getName(), (Object)inputImage);
        }
        this.fireConfigurationChanged(this.settings);
    }

    private static JSONObject getDefaultSettings() {
        JSONObject settings = new JSONObject();
        settings.put(Setting.PEN_TIP_DIAMETER.getName(), 0.25);
        settings.put(Setting.IMAGE_FILE.getName(), (Object)"data/images/tulip.png");
        settings.put(Setting.IMAGE_DPI.getName(), 150);
        settings.put(Setting.COLOR_SPACE.getName(), ColorSpace.SRGB.ordinal());
        settings.put(Setting.NB_QUANTIZATION_COLORS.getName(), 8);
        settings.put(Setting.BLURRING_RADIUS.getName(), 0);
        settings.put(Setting.BLURRING_INTENSITY.getName(), 1.0);
        settings.put(Setting.COLOR_QUANTIZATION_METHOD.getName(), ColorQuantizationMethod.USE_AVAILABLE_INKS.ordinal());
        settings.put(Setting.COLOR_SELECTION_METHOD.getName(), ColorSelectionMethod.USE_MEDIAN_COLOR.ordinal());
        settings.put(Setting.LPMM_MAX.getName(), 4.0);
        settings.put(Setting.NB_LEVELS_PER_COLOR.getName(), 3);
        settings.put(Setting.COLOR_ATTRIBUTION_METHOD.getName(), ColorAttributionMethod.ASSIGN_CLOSEST_COLOR.ordinal());
        settings.put(Setting.GREY_SATURATION_THRESHOLD.getName(), 0.25);
        JSONArray brushPalettes = new JSONArray(NB_BRUSH_PALETTES_AVAILABLE);
        int idBrushPalette = 0;
        while (idBrushPalette < NB_BRUSH_PALETTES_AVAILABLE) {
            brushPalettes.put(idBrushPalette, (Object)new BrushPalette().toJSonObject());
            ++idBrushPalette;
        }
        settings.put(Setting.BRUSH_PALETTES.getName(), (Object)brushPalettes);
        settings.put(Setting.ID_SELECTED_BRUSH_PALETTE.getName(), 0);
        settings.put(Setting.ENABLE_FINE_OUTLINING.getName(), false);
        settings.put(Setting.ENABLE_THICK_OUTLINING.getName(), false);
        settings.put(Setting.MULTICOLOR_THICK_OUTLINING.getName(), false);
        settings.put(Setting.OUTLINE_LPMM.getName(), 4.0);
        settings.put(Setting.CANNY_HIGH_THRESHOLD.getName(), 1);
        settings.put(Setting.CANNY_LOW_THRESHOLD.getName(), 0.5);
        settings.put(Setting.MIN_SEGMENT_LENGTH.getName(), 0);
        settings.put(Setting.CLEAR_Z_HEIGHT.getName(), 4.0);
        settings.put(Setting.OUTPUT_POSITION.getName(), OutputPosition.CENTERED_IN_A4.ordinal());
        settings.put(Setting.OUTPUT_ROTATION.getName(), 0);
        settings.put(Setting.OUTPUT_MIRRORING.getName(), OutputMirroring.X_MIRRORING.ordinal());
        return settings;
    }

    public void setSettingValue(Setting setting, Object value) {
        JSONObject settings = new JSONObject();
        settings.put(setting.getName(), value);
        this.setSettingsValues(settings);
    }

    public void setSettingsValues(JSONObject settings) {
        for (String settingName : settings.keySet()) {
            this.settings.put(settingName, settings.get(settingName));
        }
        this.fireConfigurationChanged(settings);
    }

    public void setArraySettingValue(Setting setting, int index, Object value) {
        this.settings.getJSONArray(setting.getName()).put(index, value);
        JSONObject settingJsonObject = new JSONObject();
        settingJsonObject.put(setting.getName(), this.settings.get(setting.getName()));
        this.fireConfigurationChanged(settingJsonObject);
    }

    public SettingsSet getCurrentSettings() {
        return new SettingsSet(this.settings);
    }

    public void addListener(ConfigurationChangeListener listener) {
        this.listeners.add(listener);
    }

    private void fireConfigurationChanged(JSONObject changedSettings) {
        for (ConfigurationChangeListener listener : this.listeners) {
            listener.configurationSettingsValuesChanged(new SettingsSet(changedSettings));
        }
        this.save(".last-config");
    }

    public void save(String filename) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(filename) + ".json"));
            bw.write(this.settings.toString());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HashMap<String, File> getAvailablePresetConfigurations() {
        HashMap<String, File> availablePresetConfigurations = new HashMap<String, File>();
        File[] fileArray = new File("data/presets/").listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(".json")) {
                String presetName = file.getName();
                presetName = presetName.substring(0, presetName.length() - ".json".length()).replaceAll("-", " ");
                presetName = String.valueOf(presetName.substring(0, 1).toUpperCase()) + presetName.substring(1);
                availablePresetConfigurations.put(presetName, file);
            }
            ++n2;
        }
        return availablePresetConfigurations;
    }

    public static void initSingleton() {
        if (Instance == null) {
            Instance = new Configuration();
        }
    }
}

