/*
 * Decompiled with CFR 0.152.
 */
package image_processing.session;

import common.engine.SettingsSet;
import image_processing.listeners.ComputationProgressionListener;
import image_processing.listeners.TransformationResultChangeListener;
import image_processing.session.Configuration;
import image_processing.session.Project;
import image_processing.transformations.AbstractTransformation;
import image_processing.transformations.PathsOptimizationTransformation;
import image_processing.transformations.TransformationStep;
import java.util.Vector;

public class ComputationThread
extends Thread
implements TransformationResultChangeListener {
    private final AbstractTransformation[] transformations;
    private AbstractTransformation transformationBeingComputed;
    private boolean forceRecomputingAllTransformations;
    private boolean shouldExportGcode = false;
    private SettingsSet settings;
    private SettingsSet settingsForNextRecomputation;
    private Vector<ComputationProgressionListener> listeners = new Vector();

    public ComputationThread(AbstractTransformation[] transformations) {
        this.transformations = transformations;
        AbstractTransformation[] abstractTransformationArray = transformations;
        int n = transformations.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTransformation transformation = abstractTransformationArray[n2];
            transformation.addListener(this);
            ++n2;
        }
        this.forceRecomputingAllTransformations = true;
        this.start();
    }

    public void compute(SettingsSet settings) {
        this.settingsForNextRecomputation = settings;
        if (this.transformationBeingComputed != null) {
            this.transformationBeingComputed.abortUpdate();
        }
    }

    public void exportGcode() {
        this.shouldExportGcode = true;
    }

    public void addComputationProgressionListener(ComputationProgressionListener listener) {
        this.listeners.add(listener);
    }

    private void fireCurrentTransformationStepChanged(AbstractTransformation currentTransformation) {
        for (ComputationProgressionListener listener : this.listeners) {
            listener.currentTransformationChanged(currentTransformation);
        }
    }

    @Override
    public void run() {
        while (true) {
            if (this.forceRecomputingAllTransformations || this.settingsForNextRecomputation != null) {
                if (this.settingsForNextRecomputation != null) {
                    this.settings = (SettingsSet)this.settingsForNextRecomputation.clone();
                    this.settingsForNextRecomputation = null;
                }
                AbstractTransformation previousTransformation = null;
                boolean transformationUpdated = false;
                AbstractTransformation[] abstractTransformationArray = this.transformations;
                int n = this.transformations.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractTransformation transformation = abstractTransformationArray[n2];
                    this.fireCurrentTransformationStepChanged(transformation);
                    if (this.forceRecomputingAllTransformations || transformationUpdated || transformation.dependsOnSettings(this.settings.getSettingsNames())) {
                        this.transformationBeingComputed = transformation;
                        transformation.updateTransformation(previousTransformation, Configuration.Instance.getCurrentSettings());
                        transformationUpdated = true;
                    }
                    previousTransformation = transformation;
                    if (!this.forceRecomputingAllTransformations && this.settingsForNextRecomputation != null) break;
                    ++n2;
                }
                this.fireCurrentTransformationStepChanged(null);
                this.transformationBeingComputed = null;
            }
            if (this.shouldExportGcode) {
                this.shouldExportGcode = false;
                ((PathsOptimizationTransformation)Project.Instance.getTransformation(TransformationStep.PATHS_OPTIMIZATION)).exportGCode();
            }
            this.forceRecomputingAllTransformations = false;
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void transformationResultChanged(AbstractTransformation transformation) {
    }

    @Override
    public void transformationProgressionChanged(AbstractTransformation transformation, String progressionLabel, double progression, boolean shouldRepaint) {
        for (ComputationProgressionListener listener : this.listeners) {
            listener.currentTransformationProgressionChanged(transformation, progressionLabel, progression);
        }
    }
}

