/*
 * Decompiled with CFR 0.152.
 */
package image_processing.gui;

import common.engine.Zoom;
import common.gui.View;
import image_processing.listeners.TransformationResultChangeListener;
import image_processing.session.Project;
import image_processing.transformations.AbstractTransformation;
import image_processing.transformations.TransformationStep;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class TransformationResultView
extends View
implements TransformationResultChangeListener {
    private static final Zoom IMAGE_PROCESSING_VIEW_ZOOM = new Zoom();
    private final AbstractTransformation transformation;

    public TransformationResultView(String title, AbstractTransformation transformation) {
        super(title, IMAGE_PROCESSING_VIEW_ZOOM);
        this.transformation = transformation;
        transformation.addListener(this);
    }

    @Override
    protected void paint(Graphics2D g, int W, int H) {
        image_processing.engine.Image originalImage = Project.Instance.getTransformation(TransformationStep.IMAGE_IMPORT).getOutputImage();
        if (originalImage != null) {
            int trX = (W - originalImage.getWidth()) / 2;
            int trY = (H - originalImage.getHeight()) / 2;
            g.translate(trX, trY);
            if (!this.transformation.isOutputImageVectorized()) {
                BufferedImage img;
                if (this.transformation.getOutputImage() != null && (img = this.transformation.getOutputImage().getBufferedImage()) != null) {
                    g.drawImage((Image)img, 0, 0, null);
                }
            } else {
                this.transformation.drawVectorizedImageOutput(g);
            }
            g.translate(-trX, -trY);
        }
    }

    @Override
    public void transformationResultChanged(AbstractTransformation transformation) {
        this.repaint();
    }

    @Override
    public void transformationProgressionChanged(AbstractTransformation transformation, String progressionLabel, double progression, boolean shouldRepaint) {
        if (shouldRepaint) {
            this.repaint();
        }
    }
}

