/*
 * Decompiled with CFR 0.152.
 */
package image_processing.gui;

import common.engine.SettingsSet;
import image_processing.engine.Brush;
import image_processing.engine.BrushPalette;
import image_processing.enums.Setting;
import image_processing.generators.HelpGenerator;
import image_processing.gui.AdvancedSettingsPanel;
import image_processing.gui.BrushPaletteEditor;
import image_processing.listeners.BrushEditorListener;
import image_processing.listeners.ConfigurationChangeListener;
import image_processing.session.Configuration;
import image_processing.session.Project;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.json.JSONArray;
import org.json.JSONObject;

public class Toolbox
extends JPanel
implements ConfigurationChangeListener,
BrushEditorListener {
    private JTabbedPane tabBrushEditorsPanels = new JTabbedPane();

    public Toolbox() {
        this.setBorder(BorderFactory.createTitledBorder("Toolbox"));
        JPanel allToolboxs = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.initGeneralSettingsToolbox());
        this.add(this.initBasicAndAdvancedSettingsToolbox());
        this.add(this.initBrushPaletteToolbox());
        this.add(this.initExportPanel());
    }

    private JPanel initGeneralSettingsToolbox() {
        JPanel toolbox = new JPanel(new GridLayout(0, 2));
        toolbox.setBorder(BorderFactory.createTitledBorder("General Settings"));
        JSpinner penTipDiameterSpinner = new JSpinner(new SpinnerNumberModel(0.5, 0.1, 10.0, 0.1));
        AdvancedSettingsPanel.linkComponentToSetting(penTipDiameterSpinner, Setting.PEN_TIP_DIAMETER, Configuration.Instance.getCurrentSettings());
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.PEN_TIP_DIAMETER));
        toolbox.add(penTipDiameterSpinner);
        JButton importImageButton = new JButton("Import Image");
        importImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser(new File("."));
                if (fileChooser.showOpenDialog(null) == 0) {
                    JSONObject settings = new JSONObject();
                    settings.put(Setting.IMAGE_FILE.getName(), (Object)fileChooser.getSelectedFile().getPath());
                    JSONArray emptyBrushPalettesArray = new JSONArray();
                    int idBrushPalette = 0;
                    while (idBrushPalette < Configuration.NB_BRUSH_PALETTES_AVAILABLE) {
                        emptyBrushPalettesArray.put((Object)new BrushPalette().toJSonObject());
                        ++idBrushPalette;
                    }
                    settings.put(Setting.BRUSH_PALETTES.getName(), (Object)emptyBrushPalettesArray);
                    Configuration.Instance.setSettingsValues(settings);
                }
            }
        });
        toolbox.add(new JLabel());
        toolbox.add(importImageButton);
        JButton importConfigButton = new JButton("Import Configuration");
        importConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser(new File("."));
                fileChooser.showOpenDialog(null);
            }
        });
        return toolbox;
    }

    private JTabbedPane initBasicAndAdvancedSettingsToolbox() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Preset Configurations", this.initPresetConfigurationsToolbox());
        tabbedPane.addTab("Advanced Settings", new AdvancedSettingsPanel());
        return tabbedPane;
    }

    private JPanel initPresetConfigurationsToolbox() {
        JPanel toolbox = new JPanel();
        toolbox.setLayout(new BoxLayout(toolbox, 1));
        ButtonGroup presetGroup = new ButtonGroup();
        for (final Map.Entry<String, File> entry : Configuration.getAvailablePresetConfigurations().entrySet()) {
            JRadioButton presetRadio = new JRadioButton(entry.getKey());
            presetRadio.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Configuration.Instance.loadConfigurationFile((File)entry.getValue(), true);
                }
            });
            presetGroup.add(presetRadio);
            toolbox.add(presetRadio);
        }
        return toolbox;
    }

    private JPanel initBrushPaletteToolbox() {
        JPanel toolbox = new JPanel();
        toolbox.setBorder(BorderFactory.createTitledBorder("Brush Palettes"));
        toolbox.setLayout(new BoxLayout(toolbox, 1));
        this.tabBrushEditorsPanels.setTabPlacement(3);
        Configuration.Instance.addListener(this);
        this.configurationSettingsValuesChanged(Configuration.Instance.getCurrentSettings());
        BrushPalette[] brushPalettes = Configuration.Instance.getCurrentSettings().getBrushPalettesSetting(Setting.BRUSH_PALETTES);
        int idBrushPalette = 0;
        while (idBrushPalette < brushPalettes.length) {
            BrushPaletteEditor brushPaletteEditor = new BrushPaletteEditor(this);
            brushPaletteEditor.setBrushPalette(brushPalettes[idBrushPalette]);
            this.tabBrushEditorsPanels.addTab("Palette " + (idBrushPalette + 1), brushPaletteEditor);
            ++idBrushPalette;
        }
        this.tabBrushEditorsPanels.setSelectedIndex(Configuration.Instance.getCurrentSettings().getIntSetting(Setting.ID_SELECTED_BRUSH_PALETTE));
        toolbox.add(this.tabBrushEditorsPanels);
        this.tabBrushEditorsPanels.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Configuration.Instance.setSettingValue(Setting.ID_SELECTED_BRUSH_PALETTE, Toolbox.this.tabBrushEditorsPanels.getSelectedIndex());
            }
        });
        return toolbox;
    }

    private JPanel initExportPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.setBorder(BorderFactory.createTitledBorder("Export"));
        JButton exportButton = new JButton("Export G-Code");
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project.Instance.getComputationThread().exportGcode();
            }
        });
        panel.add(exportButton);
        return panel;
    }

    @Override
    public void configurationSettingsValuesChanged(SettingsSet settings) {
        BrushPalette[] brushPalettes = settings.getBrushPalettesSetting(Setting.BRUSH_PALETTES);
        BrushPaletteEditor selectedBrushPaletteEditor = (BrushPaletteEditor)this.tabBrushEditorsPanels.getSelectedComponent();
        if (selectedBrushPaletteEditor != null && brushPalettes != null) {
            selectedBrushPaletteEditor.setBrushPalette(brushPalettes[this.tabBrushEditorsPanels.getSelectedIndex()]);
        }
    }

    @Override
    public void brushChanged(Brush brush) {
        BrushPaletteEditor selectedBrushPaletteEditor = (BrushPaletteEditor)this.tabBrushEditorsPanels.getSelectedComponent();
        Configuration configuration = Configuration.Instance;
        configuration.setArraySettingValue(Setting.BRUSH_PALETTES, this.tabBrushEditorsPanels.getSelectedIndex(), selectedBrushPaletteEditor.getBrushPalette().toJSonObject());
    }
}

