/*
 * Decompiled with CFR 0.152.
 */
package image_processing.gui;

import common.engine.Ink;
import common.engine.Path;
import common.engine.Utils;
import common.enums.LabelType;
import image_processing.engine.Image;
import image_processing.enums.Setting;
import image_processing.listeners.ComputationProgressionListener;
import image_processing.session.Project;
import image_processing.transformations.AbstractTransformation;
import image_processing.transformations.PathsGenerationTransformation;
import image_processing.transformations.PathsOptimizationTransformation;
import image_processing.transformations.TransformationStep;
import java.awt.Font;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class StatusBar
extends JPanel
implements ComputationProgressionListener {
    private JLabel imageDimensionsLabel;
    private JLabel currentStepLabel;
    private JLabel drawingDistanceLabel;
    private JLabel flyingDistanceLabel;
    private JLabel upDownDistanceLabel;
    private JLabel estimatedDurationLabel;
    private JLabel timeSavedLabel;
    private JProgressBar currentStepProgression;

    public StatusBar() {
        this.setLayout(new BoxLayout(this, 0));
        Font boldFont = new JLabel().getFont().deriveFont(1);
        this.add(new JLabel("Image dimensions:"));
        this.imageDimensionsLabel = new JLabel();
        this.imageDimensionsLabel.setFont(boldFont);
        this.add(this.imageDimensionsLabel);
        this.add(new JLabel(" Current step:"));
        this.currentStepLabel = new JLabel();
        this.currentStepLabel.setFont(boldFont);
        this.add(this.currentStepLabel);
        this.currentStepProgression = new JProgressBar();
        this.add(this.currentStepProgression);
        this.add(new JLabel(" Drawing distance:"));
        this.drawingDistanceLabel = new JLabel();
        this.drawingDistanceLabel.setFont(boldFont);
        this.add(this.drawingDistanceLabel);
        this.add(new JLabel(" Flying distance:"));
        this.flyingDistanceLabel = new JLabel();
        this.flyingDistanceLabel.setFont(boldFont);
        this.add(this.flyingDistanceLabel);
        this.add(new JLabel(" Up/down distance:"));
        this.upDownDistanceLabel = new JLabel();
        this.upDownDistanceLabel.setFont(boldFont);
        this.add(this.upDownDistanceLabel);
        this.add(new JLabel(" Estimated duration:"));
        this.estimatedDurationLabel = new JLabel();
        this.estimatedDurationLabel.setFont(boldFont);
        this.add(this.estimatedDurationLabel);
        this.timeSavedLabel = new JLabel();
        this.timeSavedLabel.setFont(boldFont);
        Project.Instance.getComputationThread().addComputationProgressionListener(this);
    }

    @Override
    public void currentTransformationChanged(AbstractTransformation currentTransformation) {
        String label;
        Image image = Project.Instance.getTransformation(TransformationStep.IMAGE_IMPORT).getOutputImage();
        if (currentTransformation != null && image != null) {
            int imageDpi = currentTransformation.getSettingsValues().getIntSetting(Setting.IMAGE_DPI);
            double imgW = Utils.pxToMm(image.getWidth(), imageDpi);
            double imgH = Utils.pxToMm(image.getHeight(), imageDpi);
            this.imageDimensionsLabel.setText(String.format(Locale.US, "%.0fmm x %.0fmm", imgW, imgH));
        }
        if (currentTransformation != null) {
            TransformationStep trStep = currentTransformation.getTransformationStep();
            label = String.format(Locale.US, "%s (%d/%d)", trStep.getName(), trStep.getStep(), trStep.getNbSteps());
            this.currentStepProgression.setIndeterminate(true);
        } else {
            label = "Done";
            this.currentStepProgression.setIndeterminate(false);
            this.currentStepProgression.setValue(100);
        }
        this.currentStepLabel.setText(label);
        if (currentTransformation instanceof PathsOptimizationTransformation) {
            PathsGenerationTransformation tr = (PathsGenerationTransformation)Project.Instance.getTransformation(TransformationStep.PATHS_GENERATION);
            HashMap<Ink, Path> pathsPerInk = tr.getPathsPerInk();
            HashMap<Ink, Double> drawingDistances = new HashMap<Ink, Double>();
            double totalDrawingDistance = 0.0;
            for (Map.Entry<Ink, Path> entry : pathsPerInk.entrySet()) {
                Ink ink = entry.getKey();
                Path path = entry.getValue();
                double drawingDist = path.getDrawingDistance();
                drawingDistances.put(ink, drawingDist);
                totalDrawingDistance += drawingDist;
            }
            this.drawingDistanceLabel.setText(Utils.beautifyDistance(totalDrawingDistance));
            this.drawingDistanceLabel.setToolTipText(Utils.generateDoubleValuePerInkTooltip(drawingDistances, LabelType.DISTANCE));
        }
    }

    @Override
    public void currentTransformationProgressionChanged(AbstractTransformation currentTransformation, String progressionLabel, double currentTransformationProgression) {
        if (this.currentStepProgression.isIndeterminate()) {
            this.currentStepProgression.setIndeterminate(false);
        }
        this.currentStepProgression.setValue((int)Math.round(currentTransformationProgression * 100.0));
        if (currentTransformation instanceof PathsOptimizationTransformation) {
            PathsOptimizationTransformation tr = (PathsOptimizationTransformation)currentTransformation;
            HashMap<Ink, Path> optimizedPathsPerInk = tr.getOptimizedPathsPerInk();
            HashMap<Ink, Path> originalPathsPerInk = tr.getOriginalPathsPerInk();
            HashMap<Ink, Double> flyingDistances = new HashMap<Ink, Double>();
            double totalFlyingDistance = 0.0;
            HashMap<Ink, Double> upDownDistances = new HashMap<Ink, Double>();
            double totalUpDownDistance = 0.0;
            HashMap<Ink, Double> estimatedDurations = new HashMap<Ink, Double>();
            double totalEstimatedDurations = 0.0;
            HashMap<Ink, Double> timesSaved = new HashMap<Ink, Double>();
            double totalTimeSaved = 0.0;
            for (Map.Entry<Ink, Path> entry : optimizedPathsPerInk.entrySet()) {
                Ink ink = entry.getKey();
                Path path = entry.getValue();
                double flyingDist = path.getFlyingDistance();
                flyingDistances.put(ink, flyingDist);
                totalFlyingDistance += flyingDist;
                double upDownDist = path.getUpDownDistance();
                upDownDistances.put(ink, upDownDist);
                totalUpDownDistance += upDownDist;
                double duration = path.getTotalDuration();
                estimatedDurations.put(ink, duration);
                totalEstimatedDurations += duration;
                double timeSaved = originalPathsPerInk.get(ink).getTotalDuration() - duration;
                timesSaved.put(ink, timeSaved);
                totalTimeSaved += timeSaved;
            }
            if (progressionLabel != null) {
                this.currentStepLabel.setText(progressionLabel);
            }
            this.flyingDistanceLabel.setText(Utils.beautifyDistance(totalFlyingDistance));
            this.flyingDistanceLabel.setToolTipText(Utils.generateDoubleValuePerInkTooltip(flyingDistances, LabelType.DISTANCE));
            this.upDownDistanceLabel.setText(Utils.beautifyDistance(totalUpDownDistance));
            this.upDownDistanceLabel.setToolTipText(Utils.generateDoubleValuePerInkTooltip(upDownDistances, LabelType.DISTANCE));
            this.estimatedDurationLabel.setText(Utils.beautifyDuration(totalEstimatedDurations));
            this.estimatedDurationLabel.setToolTipText(Utils.generateDoubleValuePerInkTooltip(estimatedDurations, LabelType.DURATION));
            this.timeSavedLabel.setText(Utils.beautifyDuration(totalTimeSaved));
            this.timeSavedLabel.setToolTipText(Utils.generateDoubleValuePerInkTooltip(timesSaved, LabelType.DURATION));
        }
    }
}

