/*
 * Decompiled with CFR 0.152.
 */
package image_processing.gui;

import image_processing.engine.Brush;
import image_processing.engine.BrushPalette;
import image_processing.gui.BrushEditor;
import image_processing.listeners.BrushEditorListener;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;

public class BrushPaletteEditor
extends JPanel {
    private BrushEditorListener brushEditorListener;

    public BrushPaletteEditor(BrushEditorListener brushEditorListener) {
        this.brushEditorListener = brushEditorListener;
        this.setLayout(new GridLayout(0, 1));
    }

    public void setBrushPalette(BrushPalette brushPalette) {
        if (brushPalette != null) {
            this.removeAll();
            for (Brush brush : brushPalette.getBrushesSortedByInputColor()) {
                this.add(new BrushEditor(brush, this.brushEditorListener));
            }
            this.revalidate();
        }
    }

    public BrushPalette getBrushPalette() {
        BrushPalette brushPalette = new BrushPalette();
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof BrushEditor) {
                BrushEditor brushEditor = (BrushEditor)comp;
                brushPalette.addBrush(brushEditor.getBrush());
            }
            ++n2;
        }
        return brushPalette;
    }
}

