/*
 * Decompiled with CFR 0.152.
 */
package image_processing.gui;

import common.engine.Ink;
import common.engine.Utils;
import image_processing.engine.Brush;
import image_processing.enums.Setting;
import image_processing.listeners.BrushEditorListener;
import image_processing.session.Configuration;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class BrushEditor
extends JPanel {
    private static final Insets BUTTON_MARGINS = new Insets(0, 0, 0, 0);
    private BrushEditorListener listener;
    private int inputColor;
    private Ink ink;
    private double level;
    private int angle;
    private boolean fineOutliningEnabled;
    private boolean thickOutliningEnabled;

    public BrushEditor(Brush brush, BrushEditorListener listener) {
        int[] angles;
        this.inputColor = brush.getInputColor();
        this.ink = brush.getInk();
        this.level = brush.getLevel();
        this.angle = brush.getAngle();
        this.fineOutliningEnabled = brush.isFineOutliningEnabled();
        this.thickOutliningEnabled = brush.isThickOutliningEnabled();
        this.listener = listener;
        this.setLayout(new BoxLayout(this, 0));
        JLabel inputColorLabel = new JLabel("                  ");
        inputColorLabel.setOpaque(true);
        inputColorLabel.setBackground(new Color(this.inputColor));
        this.add(inputColorLabel);
        JPanel inkColorPanel = new JPanel(new GridLayout(1, 0));
        ButtonGroup inkColorButtonGroup = new ButtonGroup();
        for (final Ink ink : Ink.getAvailableInks()) {
            JToggleButton button = new JToggleButton(Utils.getColorIcon(ink.getColor()));
            button.setMargin(BUTTON_MARGINS);
            inkColorButtonGroup.add(button);
            button.setSelected(this.ink.equals(ink));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrushEditor.this.ink = !BrushEditor.this.ink.equals(ink) ? ink : null;
                    BrushEditor.this.fireListener();
                }
            });
            inkColorPanel.add(button);
        }
        this.add(inkColorPanel);
        final JSpinner fillingSpinner = new JSpinner(new SpinnerNumberModel(this.level, 0.0, 1.0, 0.05));
        fillingSpinner.setEditor(new JSpinner.NumberEditor(fillingSpinner, "0%"));
        fillingSpinner.setUI(new BasicSpinnerUI(){

            @Override
            protected JComponent createNextButton() {
                JButton buttonUp = (JButton)super.createNextButton();
                buttonUp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        double valueDelta = 1.0 / (double)Configuration.Instance.getCurrentSettings().getIntSetting(Setting.NB_LEVELS_PER_COLOR);
                        double value = ((Double)fillingSpinner.getValue() / valueDelta + 1.0) * valueDelta;
                        fillingSpinner.setValue(Math.min(value, 1.0));
                    }
                });
                return buttonUp;
            }

            @Override
            protected JComponent createPreviousButton() {
                JButton buttonDown = (JButton)super.createPreviousButton();
                buttonDown.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        double valueDelta = 1.0 / (double)Configuration.Instance.getCurrentSettings().getIntSetting(Setting.NB_LEVELS_PER_COLOR);
                        double value = ((Double)fillingSpinner.getValue() / valueDelta - 1.0) * valueDelta;
                        fillingSpinner.setValue(Math.max(value, 0.0));
                    }
                });
                return buttonDown;
            }
        });
        fillingSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BrushEditor.this.level = (Double)fillingSpinner.getValue();
                BrushEditor.this.fireListener();
            }
        });
        this.add(fillingSpinner);
        JPanel patternPanel = new JPanel(new GridLayout(1, 0));
        ButtonGroup patternButtonGroup = new ButtonGroup();
        int[] nArray = new int[4];
        nArray[1] = 90;
        nArray[2] = 45;
        nArray[3] = -45;
        int[] nArray2 = angles = nArray;
        int n = angles.length;
        int n2 = 0;
        while (n2 < n) {
            final int angle = nArray2[n2];
            JToggleButton button = new JToggleButton(new ImageIcon("data/icons/filling-" + angle + "deg.png"));
            button.setMargin(BUTTON_MARGINS);
            patternButtonGroup.add(button);
            button.setSelected(this.angle == angle);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrushEditor.this.angle = angle;
                    BrushEditor.this.fireListener();
                }
            });
            patternPanel.add(button);
            ++n2;
        }
        this.add(patternPanel);
        JPanel outliningPanel = new JPanel(new GridLayout(1, 0));
        final JToggleButton fineOutliningCheckbox = new JToggleButton(new ImageIcon("data/icons/fine-outlining.png"));
        fineOutliningCheckbox.setMargin(BUTTON_MARGINS);
        fineOutliningCheckbox.setSelected(this.fineOutliningEnabled);
        fineOutliningCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrushEditor.this.fineOutliningEnabled = fineOutliningCheckbox.isSelected();
                BrushEditor.this.fireListener();
            }
        });
        outliningPanel.add(fineOutliningCheckbox);
        final JToggleButton thickOutliningCheckbox = new JToggleButton(new ImageIcon("data/icons/thick-outlining.png"));
        thickOutliningCheckbox.setMargin(BUTTON_MARGINS);
        thickOutliningCheckbox.setSelected(this.thickOutliningEnabled);
        thickOutliningCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrushEditor.this.thickOutliningEnabled = thickOutliningCheckbox.isSelected();
                BrushEditor.this.fireListener();
            }
        });
        outliningPanel.add(thickOutliningCheckbox);
        this.add(outliningPanel);
    }

    private void fireListener() {
        this.listener.brushChanged(this.getBrush());
    }

    public Brush getBrush() {
        return new Brush(this.inputColor, this.ink, this.level, this.angle, this.fineOutliningEnabled, this.thickOutliningEnabled);
    }
}

