/*
 * Decompiled with CFR 0.152.
 */
package image_processing.gui;

import common.engine.SettingsSet;
import image_processing.engine.BrushPalette;
import image_processing.enums.OutputMirroring;
import image_processing.enums.OutputPosition;
import image_processing.enums.OutputRotation;
import image_processing.enums.Setting;
import image_processing.generators.HelpGenerator;
import image_processing.gui.JComponentWithHelp;
import image_processing.session.Configuration;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdvancedSettingsPanel
extends JScrollPane {
    public AdvancedSettingsPanel() {
        this.setVerticalScrollBarPolicy(22);
        this.getVerticalScrollBar().setUnitIncrement(16);
        JPanel allToolboxs = new JPanel();
        allToolboxs.setLayout(new BoxLayout(allToolboxs, 1));
        SettingsSet settingsValues = Configuration.Instance.getCurrentSettings();
        allToolboxs.add(this.initImageToolbox(settingsValues));
        allToolboxs.add(this.initColorQuantizationToolbox(settingsValues));
        allToolboxs.add(this.initBrushPaletteGenerationToolbox(settingsValues));
        allToolboxs.add(this.initOutliningToolbox(settingsValues));
        allToolboxs.add(this.initGCodeToolbox(settingsValues));
        this.add(allToolboxs);
        this.setViewportView(allToolboxs);
    }

    private JPanel initImageToolbox(SettingsSet settingsValues) {
        JPanel toolbox = new JPanel(new GridLayout(0, 2));
        toolbox.setBorder(BorderFactory.createTitledBorder("Image"));
        JSpinner imageDpiSpinner = new JSpinner(new SpinnerNumberModel(150, 1, 600, 1));
        AdvancedSettingsPanel.linkComponentToSetting(imageDpiSpinner, Setting.IMAGE_DPI, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.IMAGE_DPI));
        toolbox.add(imageDpiSpinner);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.COLOR_SPACE));
        ButtonGroup colorSpaceGroup = new ButtonGroup();
        JRadioButton rgbRadio = new JRadioButton("RGB");
        colorSpaceGroup.add(rgbRadio);
        toolbox.add(rgbRadio);
        toolbox.add(new JLabel());
        JRadioButton srgbRadio = new JRadioButton("sRGB");
        colorSpaceGroup.add(srgbRadio);
        toolbox.add(srgbRadio);
        toolbox.add(new JLabel());
        JRadioButton humanWeightedRadio = new JRadioButton("Human-Weighted");
        colorSpaceGroup.add(humanWeightedRadio);
        toolbox.add(humanWeightedRadio);
        AdvancedSettingsPanel.linkComponentToSetting(colorSpaceGroup, Setting.COLOR_SPACE, settingsValues);
        return toolbox;
    }

    private JPanel initColorQuantizationToolbox(SettingsSet settingsValues) {
        JPanel toolbox = new JPanel(new GridLayout(0, 2));
        toolbox.setBorder(BorderFactory.createTitledBorder("Color Quantization"));
        JSpinner nbColorsSpinner = new JSpinner();
        AdvancedSettingsPanel.linkComponentToSetting(nbColorsSpinner, Setting.NB_QUANTIZATION_COLORS, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.NB_QUANTIZATION_COLORS));
        toolbox.add(nbColorsSpinner);
        JSpinner blurringRadiusSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 16, 1));
        AdvancedSettingsPanel.linkComponentToSetting(blurringRadiusSpinner, Setting.BLURRING_RADIUS, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.BLURRING_RADIUS));
        toolbox.add(blurringRadiusSpinner);
        JSpinner blurringIntensitySpinner = new JSpinner(new SpinnerNumberModel(0.5, 0.5, 10.0, 0.5));
        AdvancedSettingsPanel.linkComponentToSetting(blurringIntensitySpinner, Setting.BLURRING_INTENSITY, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.BLURRING_INTENSITY));
        toolbox.add(blurringIntensitySpinner);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.COLOR_QUANTIZATION_METHOD));
        ButtonGroup colorQuantizationMethodGroup = new ButtonGroup();
        JRadioButton useAvailableInksRadio = new JRadioButton("Use Available Inks");
        colorQuantizationMethodGroup.add(useAvailableInksRadio);
        toolbox.add(useAvailableInksRadio);
        toolbox.add(new JLabel(""));
        JRadioButton favorContrastsRadio = new JRadioButton("Favor Contrasts");
        colorQuantizationMethodGroup.add(favorContrastsRadio);
        toolbox.add(favorContrastsRadio);
        toolbox.add(new JLabel(""));
        JRadioButton favorColorTrueToOriginalsRadio = new JRadioButton("Favor Colors True to the Originals");
        colorQuantizationMethodGroup.add(favorColorTrueToOriginalsRadio);
        toolbox.add(favorColorTrueToOriginalsRadio);
        AdvancedSettingsPanel.linkComponentToSetting(colorQuantizationMethodGroup, Setting.COLOR_QUANTIZATION_METHOD, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.COLOR_SELECTION_METHOD));
        ButtonGroup colorSelectionMethodGroup = new ButtonGroup();
        JRadioButton useMedianRadio = new JRadioButton("Median");
        colorSelectionMethodGroup.add(useMedianRadio);
        toolbox.add(useMedianRadio);
        toolbox.add(new JLabel(""));
        JRadioButton useAverageRadio = new JRadioButton("Average");
        colorSelectionMethodGroup.add(useAverageRadio);
        toolbox.add(useAverageRadio);
        AdvancedSettingsPanel.linkComponentToSetting(colorSelectionMethodGroup, Setting.COLOR_SELECTION_METHOD, settingsValues);
        return toolbox;
    }

    private JPanel initBrushPaletteGenerationToolbox(final SettingsSet settingsValues) {
        JPanel toolbox = new JPanel();
        toolbox.setBorder(BorderFactory.createTitledBorder("Brush Palette Generation"));
        toolbox.setLayout(new GridLayout(0, 2));
        JSpinner lpmmMaxSpinner = new JSpinner(new SpinnerNumberModel(0.5, 0.5, 16.0, 0.5));
        AdvancedSettingsPanel.linkComponentToSetting(lpmmMaxSpinner, Setting.LPMM_MAX, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.LPMM_MAX));
        toolbox.add(lpmmMaxSpinner);
        final JSpinner nbLevelsPerColorSpinner = new JSpinner();
        AdvancedSettingsPanel.linkComponentToSetting(nbLevelsPerColorSpinner, Setting.NB_LEVELS_PER_COLOR, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.NB_LEVELS_PER_COLOR));
        toolbox.add(nbLevelsPerColorSpinner);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.COLOR_ATTRIBUTION_METHOD));
        ButtonGroup colorAttributionMethodGroup = new ButtonGroup();
        JRadioButton assignClosestColorRadio = new JRadioButton("Assign Closest Color");
        colorAttributionMethodGroup.add(assignClosestColorRadio);
        toolbox.add(assignClosestColorRadio);
        toolbox.add(new JLabel(""));
        JRadioButton favorMoreContrastsRadio = new JRadioButton("Favor More Contrasts");
        colorAttributionMethodGroup.add(favorMoreContrastsRadio);
        toolbox.add(favorMoreContrastsRadio);
        toolbox.add(new JLabel(""));
        JRadioButton assignClosestQuantizedInkRadio = new JRadioButton("Assign Closest Quantized Ink");
        colorAttributionMethodGroup.add(assignClosestQuantizedInkRadio);
        toolbox.add(assignClosestQuantizedInkRadio);
        AdvancedSettingsPanel.linkComponentToSetting(colorAttributionMethodGroup, Setting.COLOR_ATTRIBUTION_METHOD, settingsValues);
        final JSlider graySaturationThresholdSlider = new JSlider(0, 100);
        AdvancedSettingsPanel.linkComponentToSetting(graySaturationThresholdSlider, Setting.GREY_SATURATION_THRESHOLD, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.GREY_SATURATION_THRESHOLD));
        toolbox.add(graySaturationThresholdSlider);
        JButton generateButton = new JButton("Generate Brush Palette");
        generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSONObject settings = new JSONObject();
                settings.put(Setting.NB_LEVELS_PER_COLOR.getName(), nbLevelsPerColorSpinner.getValue());
                settings.put(Setting.GREY_SATURATION_THRESHOLD.getName(), (double)graySaturationThresholdSlider.getValue() / 100.0);
                BrushPalette[] brushPalettes = settingsValues.getBrushPalettesSetting(Setting.BRUSH_PALETTES);
                int idSelectedBrushPalette = settingsValues.getIntSetting(Setting.ID_SELECTED_BRUSH_PALETTE);
                JSONArray brushPalettesJsonArray = new JSONArray(brushPalettes.length);
                int idBrushPalette = 0;
                while (idBrushPalette < brushPalettes.length) {
                    brushPalettesJsonArray.put(idBrushPalette, (Object)(idBrushPalette != idSelectedBrushPalette ? brushPalettes[idBrushPalette].toJSonObject() : new BrushPalette().toJSonObject()));
                    ++idBrushPalette;
                }
                settings.put(Setting.BRUSH_PALETTES.getName(), (Object)brushPalettesJsonArray);
                Configuration.Instance.setSettingsValues(settings);
            }
        });
        toolbox.add(new JLabel(""));
        toolbox.add(generateButton);
        return toolbox;
    }

    private JPanel initOutliningToolbox(SettingsSet settingsValues) {
        JPanel toolbox = new JPanel(new GridLayout(0, 2));
        toolbox.setBorder(BorderFactory.createTitledBorder("Outlining"));
        JComponentWithHelp enableFineOutliningCheckBox = HelpGenerator.getSettingCheckboxWithHelp(Setting.ENABLE_FINE_OUTLINING);
        AdvancedSettingsPanel.linkComponentToSetting(enableFineOutliningCheckBox, Setting.ENABLE_FINE_OUTLINING, settingsValues);
        toolbox.add(enableFineOutliningCheckBox);
        toolbox.add(new JLabel());
        JComponentWithHelp enableThickOutliningCheckBox = HelpGenerator.getSettingCheckboxWithHelp(Setting.ENABLE_THICK_OUTLINING);
        AdvancedSettingsPanel.linkComponentToSetting(enableThickOutliningCheckBox, Setting.ENABLE_THICK_OUTLINING, settingsValues);
        toolbox.add(enableThickOutliningCheckBox);
        JComponentWithHelp multicolorOutliningCheckBox = HelpGenerator.getSettingCheckboxWithHelp(Setting.MULTICOLOR_THICK_OUTLINING);
        AdvancedSettingsPanel.linkComponentToSetting(multicolorOutliningCheckBox, Setting.MULTICOLOR_THICK_OUTLINING, settingsValues);
        toolbox.add(multicolorOutliningCheckBox);
        JSpinner highThresholdSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 3, 1));
        AdvancedSettingsPanel.linkComponentToSetting(highThresholdSpinner, Setting.CANNY_HIGH_THRESHOLD, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.CANNY_HIGH_THRESHOLD));
        toolbox.add(highThresholdSpinner);
        JSpinner lowThresholdSpinner = new JSpinner(new SpinnerNumberModel(0.05, 0.05, 1.0, 0.05));
        AdvancedSettingsPanel.linkComponentToSetting(lowThresholdSpinner, Setting.CANNY_LOW_THRESHOLD, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.CANNY_LOW_THRESHOLD));
        toolbox.add(lowThresholdSpinner);
        JSpinner outlineLppmSpinner = new JSpinner(new SpinnerNumberModel(0.5, 0.5, 12.0, 0.5));
        AdvancedSettingsPanel.linkComponentToSetting(outlineLppmSpinner, Setting.OUTLINE_LPMM, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.OUTLINE_LPMM));
        toolbox.add(outlineLppmSpinner);
        return toolbox;
    }

    private JPanel initGCodeToolbox(SettingsSet settingsValues) {
        JPanel toolbox = new JPanel(new GridLayout(0, 2));
        toolbox.setBorder(BorderFactory.createTitledBorder("G-Code"));
        JSpinner minSegmentLengthSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 10.0, 0.1));
        AdvancedSettingsPanel.linkComponentToSetting(minSegmentLengthSpinner, Setting.MIN_SEGMENT_LENGTH, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.MIN_SEGMENT_LENGTH));
        toolbox.add(minSegmentLengthSpinner);
        JSpinner clearZSpinner = new JSpinner(new SpinnerNumberModel(0.5, 0.5, 10.0, 0.5));
        AdvancedSettingsPanel.linkComponentToSetting(clearZSpinner, Setting.CLEAR_Z_HEIGHT, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.CLEAR_Z_HEIGHT));
        toolbox.add(clearZSpinner);
        JComboBox<OutputPosition> outputPositionCombo = new JComboBox<OutputPosition>(OutputPosition.values());
        AdvancedSettingsPanel.linkComponentToSetting(outputPositionCombo, Setting.OUTPUT_POSITION, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.OUTPUT_POSITION));
        toolbox.add(outputPositionCombo);
        JComboBox<OutputRotation> outputRotationCombo = new JComboBox<OutputRotation>(OutputRotation.values());
        AdvancedSettingsPanel.linkComponentToSetting(outputRotationCombo, Setting.OUTPUT_ROTATION, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.OUTPUT_ROTATION));
        toolbox.add(outputRotationCombo);
        JComboBox<OutputMirroring> outputMirroringCombo = new JComboBox<OutputMirroring>(OutputMirroring.values());
        AdvancedSettingsPanel.linkComponentToSetting(outputMirroringCombo, Setting.OUTPUT_MIRRORING, settingsValues);
        toolbox.add(HelpGenerator.getSettingLabelWithHelp(Setting.OUTPUT_MIRRORING));
        toolbox.add(outputMirroringCombo);
        return toolbox;
    }

    protected static void linkComponentToSetting(JComponent component, final Setting setting, SettingsSet settingsValues) {
        if (component instanceof JSpinner) {
            final JSpinner comp = (JSpinner)component;
            comp.setValue(settingsValues.getDoubleSetting(setting));
            comp.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Configuration.Instance.setSettingValue(setting, comp.getValue());
                }
            });
        } else if (component instanceof JSlider) {
            final JSlider comp = (JSlider)component;
            comp.setValue((int)Math.round(settingsValues.getDoubleSetting(setting) * 100.0));
            comp.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Configuration.Instance.setSettingValue(setting, (double)comp.getValue() / 100.0);
                }
            });
        } else if (component instanceof JCheckBox) {
            final JCheckBox comp = (JCheckBox)component;
            comp.setSelected(settingsValues.getBoolSetting(setting));
            comp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Configuration.Instance.setSettingValue(setting, comp.isSelected());
                }
            });
        } else if (component instanceof JComboBox) {
            final JComboBox comp = (JComboBox)component;
            comp.setSelectedIndex(settingsValues.getIntSetting(setting));
            comp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Configuration.Instance.setSettingValue(setting, comp.getSelectedIndex());
                }
            });
        } else if (component instanceof JComponentWithHelp) {
            final JCheckBox comp = (JCheckBox)((JComponentWithHelp)component).getComponent();
            comp.setSelected(settingsValues.getBoolSetting(setting));
            comp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Configuration.Instance.setSettingValue(setting, comp.isSelected());
                }
            });
        } else {
            System.err.println("Unsupported component type for linkComponentToSetting: " + component.getClass().getSimpleName());
        }
    }

    private static void linkComponentToSetting(ButtonGroup buttonGroup, final Setting setting, SettingsSet settingsValues) {
        Enumeration<AbstractButton> elements = buttonGroup.getElements();
        int id = 0;
        while (elements.hasMoreElements()) {
            AbstractButton element = elements.nextElement();
            element.setSelected(id == settingsValues.getIntSetting(setting));
            final int idElement = id++;
            element.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Configuration.Instance.setSettingValue(setting, idElement);
                }
            });
        }
    }
}

