/*
 * Decompiled with CFR 0.152.
 */
package image_processing.generators;

import image_processing.engine.Brush;
import image_processing.engine.BrushPalette;
import image_processing.engine.ColorPalette;
import image_processing.engine.Image;
import image_processing.enums.ColorSpace;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public abstract class ImageGenerator {
    public static Image generateBlurredImage(Image sourceImg, int radius, double intensity) {
        int W = sourceImg.getWidth();
        int H = sourceImg.getHeight();
        BufferedImage bufferedImg = sourceImg.getBufferedImage();
        BufferedImage blurredImg = new BufferedImage(W, H, 2);
        Graphics g = blurredImg.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, W, H);
        double x2SquaredIntensity = 2.0 * intensity * intensity;
        double invSqrt2PiXIntensity = 1.0 / (Math.sqrt(Math.PI * 2) * intensity);
        double norm = 0.0;
        double[] mask = new double[2 * radius + 1];
        int x = -radius;
        while (x < radius + 1) {
            double exp = Math.exp(-((double)(x * x) / x2SquaredIntensity));
            mask[x + radius] = invSqrt2PiXIntensity * exp;
            norm += mask[x + radius];
            ++x;
        }
        int axis = 0;
        while (axis < 2) {
            boolean convoleHorizontally = axis == 0;
            int r = radius;
            while (r < H - radius) {
                int c = radius;
                while (c < W - radius) {
                    int chan;
                    double[] sum = new double[3];
                    int mr = -radius;
                    while (mr < radius + 1) {
                        chan = 0;
                        while (chan < 3) {
                            int raw = (bufferedImg.getRGB(c + (convoleHorizontally ? mr : 0), r + (convoleHorizontally ? 0 : mr)) & 255 << 8 * chan) >> 8 * chan;
                            int n = chan++;
                            sum[n] = sum[n] + mask[mr + radius] * (double)raw;
                        }
                        ++mr;
                    }
                    int color = -16777216;
                    chan = 0;
                    while (chan < 3) {
                        int n = chan;
                        sum[n] = sum[n] / norm;
                        color |= (int)Math.round(sum[chan]) << 8 * chan;
                        ++chan;
                    }
                    blurredImg.setRGB(c, r, color);
                    ++c;
                }
                ++r;
            }
            ++axis;
        }
        return new Image(blurredImg);
    }

    public static Image generateRecoloredImage(Image sourceImg, ColorPalette colorPalette, HashMap<Integer, BufferedImage> monochromesPicturesPerColor, ColorSpace colorSpace) {
        int W = sourceImg.getWidth();
        int H = sourceImg.getHeight();
        BufferedImage recoloredBuffImg = new BufferedImage(W, H, 2);
        monochromesPicturesPerColor.clear();
        for (int color : colorPalette.getColors()) {
            monochromesPicturesPerColor.put(color, new BufferedImage(W, H, 2));
        }
        int x = 0;
        while (x < W) {
            int y = 0;
            while (y < H) {
                int color = colorPalette.getClosestColor(sourceImg.getPixel(x, y), colorSpace);
                recoloredBuffImg.setRGB(x, y, 0xFF000000 | color);
                BufferedImage monochromePicture = monochromesPicturesPerColor.get(color);
                if (monochromePicture != null) {
                    monochromePicture.setRGB(x, y, 0xFF000000 | color);
                }
                ++y;
            }
            ++x;
        }
        return new Image(recoloredBuffImg);
    }

    public static Image generateImagePaintedWithBrushPalette(Image sourceImg, BrushPalette brushPalette) {
        int W = sourceImg.getWidth();
        int H = sourceImg.getHeight();
        BufferedImage paintedBuffImg = new BufferedImage(W, H, 2);
        Graphics2D g = paintedBuffImg.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, W, H);
        int x = 0;
        while (x < W) {
            int y = 0;
            while (y < H) {
                g.setColor(Color.white);
                for (Brush brush : brushPalette.getBrushes()) {
                    if ((sourceImg.getPixel(x, y) & 0xFFFFFF) != brush.getInputColor()) continue;
                    g.setColor(new Color(brush.getAimedOutputColor()));
                    break;
                }
                g.fillRect(x, y, 1, 1);
                ++y;
            }
            ++x;
        }
        return new Image(paintedBuffImg);
    }
}

