/*
 * Decompiled with CFR 0.152.
 */
package image_processing.generators;

import common.engine.Line;
import common.engine.Path;
import image_processing.enums.Setting;
import image_processing.session.Configuration;
import java.awt.image.BufferedImage;
import java.util.Vector;

public abstract class ImageFineOutliner {
    public static Vector<Path> generateImageFineOutlinePaths(BufferedImage img) {
        int color;
        int lastBorder;
        int lastColor;
        if (img == null) {
            return null;
        }
        int W = img.getWidth();
        int H = img.getHeight();
        OutlinePointType[][] outlinePointsMap = new OutlinePointType[W][H];
        int x = 0;
        while (x < W) {
            lastColor = img.getRGB(x, 0);
            lastBorder = -1;
            int y = 1;
            while (y < H) {
                color = img.getRGB(x, y);
                if (color != lastColor && y - lastBorder > 1) {
                    outlinePointsMap[x][y] = OutlinePointType.OUTLINE_POINT_NOT_YET_IN_A_PATH;
                    lastBorder = y;
                }
                lastColor = color;
                ++y;
            }
            ++x;
        }
        int y = 0;
        while (y < H) {
            lastColor = img.getRGB(0, y);
            lastBorder = -1;
            int x2 = 0;
            while (x2 < W) {
                color = img.getRGB(x2, y);
                if (color != lastColor && x2 - lastBorder > 1) {
                    outlinePointsMap[x2][y] = OutlinePointType.OUTLINE_POINT_NOT_YET_IN_A_PATH;
                    lastBorder = x2;
                }
                lastColor = color;
                ++x2;
            }
            ++y;
        }
        Vector<Path> outlinePaths = new Vector<Path>();
        int x3 = 0;
        while (x3 < W) {
            int y2 = 0;
            while (y2 < H) {
                if (outlinePointsMap[x3][y2] == OutlinePointType.OUTLINE_POINT_NOT_YET_IN_A_PATH) {
                    outlinePaths.add(ImageFineOutliner.generateFineOutlinePath(x3, y2, outlinePointsMap));
                }
                ++y2;
            }
            ++x3;
        }
        return outlinePaths;
    }

    private static Path generateFineOutlinePath(int xStart, int yStart, OutlinePointType[][] outlinePointsMap) {
        Path path = new Path(Configuration.Instance.getCurrentSettings().getDoubleSetting(Setting.CLEAR_Z_HEIGHT));
        int lastX = xStart;
        int lastY = yStart;
        outlinePointsMap[xStart][yStart] = OutlinePointType.OUTLINE_POINT_IN_A_PATH;
        int W = outlinePointsMap.length;
        int H = outlinePointsMap[0].length;
        boolean continuePath = true;
        block0: while (continuePath) {
            continuePath = false;
            int i = -1;
            while (i <= 1) {
                int j = -1;
                while (j <= 1) {
                    int xx = Math.max(0, Math.min(lastX + i, W - 1));
                    int yy = Math.max(0, Math.min(lastY + j, H - 1));
                    if ((xx != lastX || yy != lastY) && outlinePointsMap[xx][yy] == OutlinePointType.OUTLINE_POINT_NOT_YET_IN_A_PATH) {
                        path.addLine(new Line(lastX, lastY, xx, yy));
                        outlinePointsMap[xx][yy] = OutlinePointType.OUTLINE_POINT_IN_A_PATH;
                        lastX = xx;
                        lastY = yy;
                        continuePath = true;
                        break;
                    }
                    ++j;
                }
                if (continuePath) continue block0;
                ++i;
            }
        }
        return path;
    }

    private static enum OutlinePointType {
        NOT_AN_OUTLINE_POINT,
        OUTLINE_POINT_IN_A_PATH,
        OUTLINE_POINT_NOT_YET_IN_A_PATH;

    }
}

