/*
 * Decompiled with CFR 0.152.
 */
package image_processing.generators;

import image_processing.engine.ColorPalette;
import image_processing.engine.Image;
import image_processing.enums.ColorQuantizationMethod;
import image_processing.enums.ColorSelectionMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class ColorPaletteGenerator {
    private static ColorPalette generateReducedColorPalette(ArrayList<Integer> pixelsColors, int nbColors, ColorQuantizationMethod colorQuantizationMethod, ColorSelectionMethod colorSelectionMethod) {
        if (colorQuantizationMethod == ColorQuantizationMethod.FAVOR_COLORS_TRUE_TO_ORIGINALS) {
            int idLastSetBit;
            int idFirstSetBit = Integer.toBinaryString(nbColors).indexOf(49);
            if (idFirstSetBit != (idLastSetBit = Integer.toBinaryString(nbColors).lastIndexOf(49))) {
                nbColors = 1 << Integer.toBinaryString(nbColors).length() - 1 - idFirstSetBit;
                System.err.println("Warning: if recursive cut is used then nbColors should be a power of 2, using instead " + nbColors);
            }
            nbColors /= 2;
        } else if (colorQuantizationMethod == ColorQuantizationMethod.FAVOR_CONTRASTS) {
            --nbColors;
        } else {
            System.err.println("Unsupported color quantization method: " + (Object)((Object)colorQuantizationMethod));
            return null;
        }
        return ColorPaletteGenerator.cutPalette(new ColorPalette(), pixelsColors, nbColors, colorQuantizationMethod, colorSelectionMethod);
    }

    /*
     * Unable to fully structure code
     */
    private static ColorPalette cutPalette(ColorPalette colorPalette, List<Integer> pixels, int nbCuts, ColorQuantizationMethod colorQuantizationMethod, ColorSelectionMethod colorSelectionMethod) {
        if (pixels.size() == 0) {
            System.err.println("error: tried to cut empty palette");
            return colorPalette;
        }
        if (nbCuts <= 0) ** GOTO lbl52
        minR = 0xFF0000;
        minG = 65280;
        minB = 255;
        maxR = 0;
        maxG = 0;
        maxB = 0;
        i = 0;
        while (i < pixels.size()) {
            px = pixels.get(i);
            r = px & 0xFF0000;
            g = px & 65280;
            b = px & 255;
            if (r < minR) {
                minR = r;
            }
            if (r > maxR) {
                maxR = r;
            }
            if (g < minG) {
                minG = g;
            }
            if (g > maxG) {
                maxG = g;
            }
            if (b < minB) {
                minB = b;
            }
            if (b > maxB) {
                maxB = b;
            }
            ++i;
        }
        deltaR = maxR - minR >> 16;
        deltaG = maxG - minG >> 8;
        deltaB = maxB - minB;
        filter = 0;
        filter = deltaR >= deltaG && deltaR >= deltaB ? 0xFF0000 : (deltaG >= deltaR && deltaG >= deltaB ? 65280 : 255);
        filterFinal = filter;
        Collections.sort(pixels, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return (o1 & filterFinal) - (o2 & filterFinal);
            }
        });
        if (colorQuantizationMethod == ColorQuantizationMethod.FAVOR_COLORS_TRUE_TO_ORIGINALS) {
            ColorPaletteGenerator.cutPalette(colorPalette, new ArrayList<Integer>(pixels.subList(0, pixels.size() / 2)), nbCuts / 2, colorQuantizationMethod, colorSelectionMethod);
            ColorPaletteGenerator.cutPalette(colorPalette, new ArrayList<Integer>(pixels.subList(pixels.size() / 2, pixels.size())), nbCuts / 2, colorQuantizationMethod, colorSelectionMethod);
        } else if (colorQuantizationMethod == ColorQuantizationMethod.FAVOR_CONTRASTS) {
            ColorPaletteGenerator.cutPalette(colorPalette, new ArrayList<Integer>(pixels.subList(pixels.size() / 2, pixels.size())), 0, colorQuantizationMethod, colorSelectionMethod);
            ColorPaletteGenerator.cutPalette(colorPalette, new ArrayList<Integer>(pixels.subList(0, pixels.size() / 2)), nbCuts - 1, colorQuantizationMethod, colorSelectionMethod);
        } else {
            System.err.println("Unsupported color quantization method: " + (Object)colorQuantizationMethod);
            return null;
lbl52:
            // 1 sources

            color = 0;
            if (colorSelectionMethod == ColorSelectionMethod.USE_MEDIAN_COLOR) {
                comp = 0;
                while (comp < 3) {
                    filter = 255 << comp * 8;
                    Collections.sort(pixels, new Comparator<Integer>(){

                        @Override
                        public int compare(Integer o1, Integer o2) {
                            return (o1 & filter) - (o2 & filter);
                        }
                    });
                    color |= pixels.get(pixels.size() / 2) & filter;
                    ++comp;
                }
            } else {
                r = 0L;
                g = 0L;
                b = 0L;
                i = 0;
                while (i < pixels.size()) {
                    px = pixels.get(i);
                    r += (long)((px & 0xFF0000) >> 16);
                    g += (long)((px & 65280) >> 8);
                    b += (long)(px & 255);
                    ++i;
                }
                color = (int)((r /= (long)pixels.size()) << 16 | (g /= (long)pixels.size()) << 8 | (b /= (long)pixels.size()));
            }
            colorPalette.addColor(color);
        }
        return colorPalette;
    }

    public static ColorPalette generateReducedPaletteColorFromImage(Image sourceImg, int nbColors, ColorQuantizationMethod colorQuantizationMethod, ColorSelectionMethod colorSelectionMethod) {
        ArrayList<Integer> pixelsList = new ArrayList<Integer>();
        int x = 0;
        while (x < sourceImg.getWidth()) {
            int y = 0;
            while (y < sourceImg.getHeight()) {
                pixelsList.add(sourceImg.getPixel(x, y));
                ++y;
            }
            ++x;
        }
        return ColorPaletteGenerator.generateReducedColorPalette(pixelsList, nbColors, colorQuantizationMethod, colorSelectionMethod);
    }
}

