/*
 * Decompiled with CFR 0.152.
 */
package image_processing.generators;

import common.engine.Ink;
import common.engine.Utils;
import image_processing.engine.Brush;
import image_processing.engine.BrushPalette;
import image_processing.engine.ColorPalette;
import image_processing.enums.ColorAttributionMethod;
import image_processing.enums.ColorSpace;
import image_processing.enums.Setting;
import image_processing.session.Configuration;
import image_processing.session.Project;
import image_processing.transformations.ColorQuantizationTransformation;
import image_processing.transformations.TransformationStep;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public abstract class BrushPaletteGenerator {
    public static BrushPalette generateBrushPaletteFromInks(int nbColors) {
        int nbAvailableInks = Ink.getNbAvailableInks();
        if (nbColors % nbAvailableInks != 0) {
            nbColors -= nbColors % nbAvailableInks;
            System.out.println(String.format("The number of colors should be a multiple of the number of inks available (%d), using %d colors", nbAvailableInks, nbColors));
        }
        int nbColorsPerInk = nbColors / nbAvailableInks;
        BrushPalette brushPalette = new BrushPalette();
        brushPalette.addBrush(new Brush(0xFFFFFF, Ink.getBlackestAvailableInk(), 0.0, 45, true, true));
        for (Ink ink : Ink.getAvailableInks()) {
            int idColor = 0;
            while (idColor < nbColorsPerInk) {
                double level = (double)idColor / (double)nbColorsPerInk;
                int r = (int)Math.round((double)ink.getR() + (double)(255 - ink.getR()) * level);
                int g = (int)Math.round((double)ink.getG() + (double)(255 - ink.getG()) * level);
                int b = (int)Math.round((double)ink.getB() + (double)(255 - ink.getB()) * level);
                brushPalette.addBrush(new Brush(r << 16 | g << 8 | b, ink, 1.0 - level, 45, true, true));
                ++idColor;
            }
        }
        return brushPalette;
    }

    public static BrushPalette generateBrushPalette(ColorPalette inputColorPalette, double lpmmMax, int nbLevelsPerColor, double graySaturationThreshold, ColorSpace colorSpace, ColorAttributionMethod colorAttributionMethod) {
        if (colorAttributionMethod == ColorAttributionMethod.ASSIGN_CLOSEST_QUANTIZED_INK) {
            ColorQuantizationTransformation trans = (ColorQuantizationTransformation)Project.Instance.getTransformation(TransformationStep.COLOR_QUANTIZATION);
            return BrushPaletteGenerator.generateBrushPaletteFromInks(Configuration.Instance.getCurrentSettings().getIntSetting(Setting.NB_QUANTIZATION_COLORS));
        }
        HashMap ishColors = new HashMap();
        for (Ink inkColor : Ink.getAvailableInks()) {
            ishColors.put(inkColor, new Vector());
        }
        Iterator<Object> iterator = inputColorPalette.getColors().iterator();
        while (iterator.hasNext()) {
            int color = (Integer)iterator.next();
            Ink closestInkColor = Utils.getClosestInk(color, colorSpace, graySaturationThreshold);
            ((Vector)ishColors.get(closestInkColor)).add(color);
        }
        BrushPalette brushPalette = new BrushPalette();
        for (Ink ink : ishColors.keySet()) {
            Vector inputColors = (Vector)ishColors.get(ink);
            for (Integer inputColor : inputColors) {
                double level = 0.0;
                int r = inputColor >> 16 & 0xFF;
                int g = inputColor >> 8 & 0xFF;
                int b = inputColor & 0xFF;
                level = 255.0 * (1.0 - (double)Utils.distanceBetweenColors(inputColor, ink.getColorAsRgb(), colorSpace) / (double)Utils.distanceBetweenColors(0xFFFFFF, ink.getColorAsRgb(), colorSpace));
                if (colorAttributionMethod == ColorAttributionMethod.ASSIGN_CLOSEST_COLOR) {
                    level = ink.isBlackestAvailableInk() ? (double)Math.round(level / 255.0 * (double)nbLevelsPerColor) / (double)nbLevelsPerColor : (1.0 + Math.floor((255.0 - level) / 255.0 * (double)nbLevelsPerColor)) / (double)nbLevelsPerColor;
                } else if (colorAttributionMethod == ColorAttributionMethod.FAVOR_MORE_CONTRASTS) {
                    level = ink.isBlackestAvailableInk() ? (level /= 255.0) : (255.0 - level) / 255.0;
                } else {
                    level = 1.0;
                    System.err.println("unsupported ColorAttributionMethod:" + (Object)((Object)colorAttributionMethod));
                }
                int angle = 45;
                brushPalette.addBrush(new Brush(inputColor, ink, level, angle, true, true));
            }
        }
        if (colorAttributionMethod == ColorAttributionMethod.FAVOR_MORE_CONTRASTS) {
            BrushPalette distributedBrushPalette = new BrushPalette();
            for (Ink ink : Ink.getAvailableInks()) {
                Vector<Brush> brushsOfInkColor = brushPalette.getBrushesOfInkColor(ink);
                brushsOfInkColor.sort(new Comparator<Brush>(){

                    @Override
                    public int compare(Brush o1, Brush o2) {
                        return (int)((o1.getLevel() - o2.getLevel()) * 1000.0);
                    }
                });
                int nbBrushsOfInkColor = brushsOfInkColor.size();
                int idBrushOfInkColor = 0;
                while (idBrushOfInkColor < nbBrushsOfInkColor) {
                    Brush brush = brushsOfInkColor.get(idBrushOfInkColor);
                    double level = (double)idBrushOfInkColor / (double)nbBrushsOfInkColor;
                    level = ink.isBlackestAvailableInk() ? (double)Math.round(level * (double)nbLevelsPerColor) / (double)nbLevelsPerColor : (1.0 + Math.floor(level * (double)nbLevelsPerColor)) / (double)nbLevelsPerColor;
                    Brush distributedBrush = new Brush(brush.getInputColor(), brush.getInk(), level, brush.getAngle(), brush.isFineOutliningEnabled(), brush.isThickOutliningEnabled());
                    distributedBrushPalette.addBrush(distributedBrush);
                    ++idBrushOfInkColor;
                }
            }
            brushPalette = distributedBrushPalette;
        }
        return brushPalette;
    }
}

