/*
 * Decompiled with CFR 0.152.
 */
package image_processing.enums;

public enum OutputPosition {
    TOP_LEFT_CORNER(0.0, 0.0, "Top-left corner"),
    CENTERED_IN_A4(0.5, 0.5, "Centered in A4 sheet"),
    CENTERED_IN_UPPER_HALF_A4(0.5, 0.75, "Centered in A4 sheet upper half"),
    CENTERED_IN_LOWER_HALF_A4(0.5, 0.25, "Centered in A4 sheet lower half"),
    CENTERED_IN_UPPER_LEFT_A4(0.25, 0.75, "Centered in A4 sheet upper left quarter"),
    CENTERED_IN_UPPER_RIGHT_A4(0.75, 0.75, "Centered in A4 sheet upper right quarter"),
    CENTERED_IN_LOWER_LEFT_A4(0.25, 0.25, "Centered in A4 sheet lower left quarter"),
    CENTERED_IN_LOWER_RIGHT_A4(0.75, 0.25, "Centered in A4 sheet lower right quarter");

    private static final int A4_WIDTH = 210;
    private static final int A4_HEIGHT = 297;
    private double xPosInA4;
    private double yPosInA4;
    private String label;

    private OutputPosition(double xRelativePos, double yRelativePos, String label) {
        this.xPosInA4 *= 210.0;
        this.yPosInA4 *= 297.0;
        this.label = label;
    }

    public double getXPosInA4() {
        return this.xPosInA4;
    }

    public double getYPosInA4() {
        return this.yPosInA4;
    }

    public boolean isCentered() {
        return this != TOP_LEFT_CORNER;
    }

    public String toString() {
        return this.label;
    }
}

